/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDataSniffer {
    private static final Log log = LogFactory.getLog(XmlDataSniffer.class);
    private static final String SAX_EXCEPTION_MESSAGE_VALID_XML = "something unique";
    private static final String FEATURE_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public static boolean isXmlData(byte[] data) {
        XmlSniffResult sniffResult = XmlDataSniffer.sniffXml(data);
        return sniffResult != null;
    }

    public static XmlSniffResult sniffXml(byte[] data) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setXIncludeAware(false);
        XmlDataSniffer.setParserFeature(factory, FEATURE_EXTERNAL_GENERAL_ENTITIES, false);
        XmlDataSniffer.setParserFeature(factory, FEATURE_EXTERNAL_PARAMETER_ENTITIES, false);
        XmlDataSniffer.setParserFeature(factory, FEATURE_LOAD_EXTERNAL_DTD, false);
        SaxHandler handler = new SaxHandler();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)bais, (DefaultHandler)handler);
            return new XmlSniffResult(handler.rootElementName);
        }
        catch (ValidXmlSAXException e) {
            return new XmlSniffResult(handler.rootElementName);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
    }

    protected static void setParserFeature(SAXParserFactory factory, String feature, boolean value) {
        block2: {
            try {
                factory.setFeature(feature, value);
            }
            catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Failed to set parser feature " + feature + ", error " + e);
            }
        }
    }

    public static class XmlSniffResult {
        private final String rootElementName;

        public XmlSniffResult(String rootElementName) {
            this.rootElementName = rootElementName;
        }

        public String getRootElementName() {
            return this.rootElementName;
        }
    }

    private static class SaxHandler
    extends DefaultHandler {
        private String rootElementName;

        private SaxHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.rootElementName = qName != null && !qName.isEmpty() ? qName : (localName != null && !localName.isEmpty() ? localName : null);
            throw new ValidXmlSAXException();
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            throw new ValidXmlSAXException();
        }
    }

    private static class ValidXmlSAXException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        ValidXmlSAXException() {
            super(XmlDataSniffer.SAX_EXCEPTION_MESSAGE_VALID_XML);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

