/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.digester.Rule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;

public abstract class TransformedPropertyRule
extends Rule {
    private static final Log log = LogFactory.getLog(TransformedPropertyRule.class);
    protected final String attributeName;
    protected final String propertyName;

    protected TransformedPropertyRule(String attributeName) {
        this(attributeName, attributeName);
    }

    protected TransformedPropertyRule(String attributeName, String propertyName) {
        this.attributeName = attributeName;
        this.propertyName = propertyName;
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        String attrValue = attributes.getValue(this.attributeName);
        if (attrValue != null) {
            Object value = this.toPropertyValue(attrValue);
            if (value != null) {
                Object top = this.digester.peek();
                if (log.isDebugEnabled()) {
                    log.debug("Setting property " + this.propertyName + " on " + top + " to " + value + " from attribute \"" + attrValue + "\"");
                }
                BeanUtils.setProperty(top, this.propertyName, value);
            } else if (log.isDebugEnabled()) {
                log.debug("Attribute value " + attrValue + " resulted in null property value, not setting");
            }
        }
    }

    protected abstract Object toPropertyValue(String var1);
}

