/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.jasperreports.data.excel.ExcelFormatEnum;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;
import net.sf.jasperreports.engine.query.AbstractXlsQueryExecuter;
import net.sf.jasperreports.engine.query.QueryExecutionContext;
import net.sf.jasperreports.engine.query.SimpleQueryExecutionContext;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.repo.RepositoryContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExcelQueryExecuter
extends AbstractXlsQueryExecuter {
    private static final Log log = LogFactory.getLog(ExcelQueryExecuter.class);
    private static final String EXCEL_DATA_SOURCE_CLASS = "net.sf.jasperreports.engine.data.ExcelDataSource";
    private static final String XLS_DATA_SOURCE_CLASS = "net.sf.jasperreports.engine.data.XlsDataSource";
    private static final String XLSX_DATA_SOURCE_CLASS = "net.sf.jasperreports.engine.data.JRXlsxDataSource";
    private static final String XLS_WORKBOOK_CLASS = "org.apache.poi.hssf.usermodel.HSSFWorkbook";
    private static final String XLSX_WORKBOOK_CLASS = "org.apache.poi.xssf.usermodel.XSSFWorkbook";

    protected ExcelQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(SimpleQueryExecutionContext.of(jasperReportsContext), dataset, parametersMap);
    }

    protected ExcelQueryExecuter(QueryExecutionContext context, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(context, dataset, parametersMap);
    }

    protected ExcelQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    @Override
    public JRDataSource createDatasource() throws JRException {
        String dataSourceClassName = null;
        Class[] constrParamTypes = null;
        Object[] constrParamValues = null;
        Object workbook = this.getParameterValue("XLSX_WORKBOOK", true);
        if (workbook == null) {
            workbook = this.getParameterValue("XLS_WORKBOOK", true);
        }
        if (workbook != null) {
            String workbookClassName = workbook.getClass().getName();
            if (XLS_WORKBOOK_CLASS.equals(workbookClassName)) {
                dataSourceClassName = XLS_DATA_SOURCE_CLASS;
            } else if (XLSX_WORKBOOK_CLASS.equals(workbookClassName)) {
                dataSourceClassName = XLSX_DATA_SOURCE_CLASS;
            }
            constrParamTypes = new Class[]{workbook.getClass()};
            constrParamValues = new Object[]{workbook};
        } else {
            ExcelFormatEnum format = null;
            Object objFormat = this.getParameterValue("net.sf.jasperreports.xls.format", true);
            if (objFormat instanceof ExcelFormatEnum) {
                format = (ExcelFormatEnum)objFormat;
            }
            if (format == null) {
                format = ExcelFormatEnum.getByName(this.getStringParameterOrProperty("net.sf.jasperreports.xls.format"));
            }
            if (format == null) {
                format = ExcelFormatEnum.AUTODETECT;
            }
            switch (format) {
                case XLS: {
                    dataSourceClassName = XLS_DATA_SOURCE_CLASS;
                    break;
                }
                case XLSX: {
                    dataSourceClassName = XLSX_DATA_SOURCE_CLASS;
                    break;
                }
                default: {
                    dataSourceClassName = EXCEL_DATA_SOURCE_CLASS;
                }
            }
            InputStream xlsInputStream = (InputStream)this.getParameterValue("XLSX_INPUT_STREAM", true);
            if (xlsInputStream == null) {
                xlsInputStream = (InputStream)this.getParameterValue("XLS_INPUT_STREAM", true);
            }
            if (xlsInputStream != null) {
                constrParamTypes = new Class[]{InputStream.class};
                constrParamValues = new Object[]{xlsInputStream};
            } else {
                File xlsFile = (File)this.getParameterValue("XLSX_FILE", true);
                if (xlsFile == null) {
                    xlsFile = (File)this.getParameterValue("XLS_FILE", true);
                }
                if (xlsFile != null) {
                    constrParamTypes = new Class[]{File.class};
                    constrParamValues = new Object[]{xlsFile};
                } else {
                    String xlsSource = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.source");
                    if (xlsSource == null) {
                        xlsSource = this.getStringParameterOrProperty("net.sf.jasperreports.xls.source");
                    }
                    if (xlsSource != null) {
                        constrParamTypes = new Class[]{RepositoryContext.class, String.class};
                        constrParamValues = new Object[]{this.getRepositoryContext(), xlsSource};
                    } else if (log.isWarnEnabled()) {
                        log.warn("No Excel source was provided.");
                    }
                }
            }
        }
        AbstractXlsDataSource datasource = this.createDatasource(dataSourceClassName, constrParamTypes, constrParamValues);
        if (datasource != null) {
            this.initDatasource(datasource);
        }
        return datasource;
    }

    private AbstractXlsDataSource createDatasource(String dataSourceClassName, Class<?>[] constrParamTypes, Object[] constrParamValues) throws JRException {
        AbstractXlsDataSource datasource = null;
        try {
            Class<?> dataSourceClass = JRClassLoader.loadClassForName(dataSourceClassName);
            Constructor<?> constructor = dataSourceClass.getConstructor(constrParamTypes);
            datasource = (AbstractXlsDataSource)constructor.newInstance(constrParamValues);
        }
        catch (InvocationTargetException e) {
            throw new JRException(e);
        }
        catch (IllegalAccessException e) {
            throw new JRException(e);
        }
        catch (InstantiationException e) {
            throw new JRException(e);
        }
        catch (NoSuchMethodException e) {
            throw new JRException(e);
        }
        catch (ClassNotFoundException e) {
            throw new JRException(e);
        }
        return datasource;
    }
}

