/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.AbstractPdfTextRenderer;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.export.pdf.PdfPhrase;
import net.sf.jasperreports.export.pdf.PdfProducer;
import net.sf.jasperreports.export.pdf.PdfTextAlignment;
import net.sf.jasperreports.export.pdf.TextDirection;

public class SimplePdfTextRenderer
extends AbstractPdfTextRenderer {
    private float yLine = 0.0f;

    public SimplePdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont) {
        this(jasperReportsContext, ignoreMissingFont, true, false);
    }

    public SimplePdfTextRenderer(JasperReportsContext jasperReportsContext, boolean ignoreMissingFont, boolean defaultIndentFirstLine, boolean defaultJustifyLastLine) {
        super(jasperReportsContext, ignoreMissingFont, defaultIndentFirstLine, defaultJustifyLastLine);
    }

    @Override
    public void initialize(JRPdfExporter pdfExporter, PdfProducer pdfProducer, JRPrintText text, JRStyledText styledText, int offsetX, int offsetY) {
        super.initialize(pdfExporter, pdfProducer, text, styledText, offsetX, offsetY);
        this.yLine = (float)(pdfExporter.getCurrentPageFormat().getPageHeight() - this.y - this.topPadding) - this.verticalAlignOffset - text.getLeadingOffset();
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    protected void renderParagraph(AttributedCharacterIterator allParagraphs, int paragraphStart, String paragraphText) {
        AttributedString paragraph = null;
        if (paragraphText == null) {
            paragraphText = " ";
            paragraph = new AttributedString(paragraphText, new AttributedString(allParagraphs, paragraphStart, paragraphStart + paragraphText.length()).getIterator().getAttributes());
        } else {
            paragraph = new AttributedString(allParagraphs, paragraphStart, paragraphStart + paragraphText.length());
        }
        PdfPhrase phrase = this.pdfProducer.createPhrase();
        this.pdfExporter.getPhrase(paragraph, paragraphText, this.text, phrase);
        this.yLine = phrase.go(this.x + this.leftPadding, this.yLine, this.x + this.width - this.rightPadding, this.pdfExporter.getCurrentPageFormat().getPageHeight() - this.y - this.height + this.bottomPadding, 0.0f, this.text.getLineSpacingFactor(), this.horizontalAlignment == PdfTextAlignment.JUSTIFIED && this.isLastParagraph && this.justifyLastLine ? PdfTextAlignment.JUSTIFIED_ALL : this.horizontalAlignment, this.text.getRunDirectionValue() == RunDirectionEnum.LTR ? TextDirection.LTR : TextDirection.RTL);
    }

    @Override
    protected AttributedString getAttributedString() {
        return this.styledText.getAttributedString();
    }

    @Override
    public void draw() {
    }

    @Override
    public boolean addActualText() {
        return false;
    }
}

