/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.MTree;
import org.compiere.model.MTree_Node;
import org.compiere.model.MTree_NodeBP;
import org.compiere.model.MTree_NodeMM;
import org.compiere.model.MTree_NodePR;
import org.compiere.model.MTree_NodeU1;
import org.compiere.model.MTree_NodeU2;
import org.compiere.model.MTree_NodeU3;
import org.compiere.model.MTree_NodeU4;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class TreeMaintenance
extends SvrProcess {
    private int m_AD_Tree_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.m_AD_Tree_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("AD_Tree_ID=" + this.m_AD_Tree_ID);
        if (this.m_AD_Tree_ID == 0) {
            throw new IllegalArgumentException("Tree_ID = 0");
        }
        MTree tree = new MTree(this.getCtx(), this.m_AD_Tree_ID, this.get_TrxName());
        if (tree == null || tree.getAD_Tree_ID() == 0) {
            throw new IllegalArgumentException("No Tree -" + String.valueOf(tree));
        }
        if ("BB".equals(tree.getTreeType())) {
            return "BOM Trees not implemented";
        }
        return this.verifyTree(tree);
    }

    private String verifyTree(MTree tree) {
        String nodeTableName = tree.getNodeTableName();
        String sourceTableName = tree.getSourceTableName();
        String sourceTableKey = sourceTableName + "_ID";
        int AD_Client_ID = tree.getAD_Client_ID();
        ArrayList<Integer> treeElements = new ArrayList<Integer>();
        if ("EV".equals(tree.getTreeType()) || "U1".equals(tree.getTreeType()) || "U2".equals(tree.getTreeType()) || "U3".equals(tree.getTreeType()) || "U4".equals(tree.getTreeType())) {
            int[] elements;
            String sql = "SELECT C_Element_ID FROM C_Element WHERE AD_Tree_ID= ?";
            for (int i : elements = DB.getIDsEx(null, (String)sql, (Object[])new Object[]{tree.getAD_Tree_ID()})) {
                treeElements.add(i);
            }
            if (elements.length <= 0) {
                throw new IllegalStateException("No Account Element found");
            }
        } else {
            treeElements.add(0);
        }
        AtomicReference<Boolean> ok = new AtomicReference<Boolean>();
        ok.set(true);
        treeElements.forEach(treeElement -> {
            MColumn parentColumn = null;
            MTable sourceTable = null;
            String[] keyColumns = null;
            if (tree.getParent_Column_ID() > 0) {
                parentColumn = MColumn.get((Properties)Env.getCtx(), (int)tree.getParent_Column_ID());
                sourceTable = MTable.get((Properties)Env.getCtx(), (int)tree.getAD_Table_ID());
                keyColumns = sourceTable.getKeyColumns();
            }
            int C_Element_ID = treeElement;
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM ").append(nodeTableName).append(" WHERE AD_Tree_ID=").append(tree.getAD_Tree_ID()).append(" AND Node_ID NOT IN (SELECT ").append(sourceTableKey).append(" FROM ").append(sourceTableName).append(" st WHERE st.AD_Client_ID=").append(AD_Client_ID);
            if (C_Element_ID > 0) {
                sql.append(" AND EXISTS (SELECT 1 FROM C_Element WHERE ").append(" C_Element_ID=").append(C_Element_ID).append(" AND C_Element.AD_Tree_ID = ").append(nodeTableName).append(".AD_Tree_ID)");
            }
            sql.append(")");
            this.log.finer(sql.toString());
            int deletes = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
            this.addLog(0, null, new BigDecimal(deletes), tree.getName() + " Deleted");
            if (tree.isAllNodes()) {
                int inserts = 0;
                sql = new StringBuffer();
                sql.append("SELECT ").append(sourceTableKey).append(" FROM ").append(sourceTableName).append(" WHERE AD_Client_ID=").append(AD_Client_ID);
                if (C_Element_ID > 0) {
                    sql.append(" AND C_Element_ID=").append(C_Element_ID);
                }
                sql.append(" AND ").append(sourceTableKey).append("  NOT IN (SELECT Node_ID FROM ").append(nodeTableName).append(" WHERE AD_Tree_ID=").append(tree.getAD_Tree_ID()).append(")");
                this.log.finer(sql.toString());
                CPreparedStatement pstmt = null;
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int Node_ID = rs.getInt(1);
                        MTree_Node node = null;
                        if (nodeTableName.equals("AD_TreeNode")) {
                            node = new MTree_Node(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodeBP")) {
                            node = new MTree_NodeBP(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodePR")) {
                            node = new MTree_NodePR(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodeMM")) {
                            node = new MTree_NodeMM(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodeU1")) {
                            node = new MTree_NodeU1(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodeU2")) {
                            node = new MTree_NodeU2(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodeU3")) {
                            node = new MTree_NodeU3(tree, Node_ID);
                        } else if (nodeTableName.equals("AD_TreeNodeU4")) {
                            node = new MTree_NodeU4(tree, Node_ID);
                        }
                        if (node == null) {
                            this.log.log(Level.SEVERE, "No Model for " + nodeTableName);
                            continue;
                        }
                        if (keyColumns != null && keyColumns.length > 0 && parentColumn != null) {
                            String whereClause = keyColumns[0] + "=" + node.get_ValueAsInt("Node_ID");
                            PO table = MTable.get((Properties)Env.getCtx(), (String)sourceTableName).getPO(whereClause, node.get_TrxName());
                            if (table.get_ID() > 0) {
                                if (node.get_ID() > 0) {
                                    node.set_ValueOfColumn("Parent_ID", (Object)table.get_ValueAsInt(parentColumn.getColumnName()));
                                } else {
                                    node.set_ValueOfColumn("Parent_ID", null);
                                }
                            }
                        }
                        if (node.save()) {
                            ++inserts;
                            continue;
                        }
                        this.log.log(Level.SEVERE, "Could not add to " + String.valueOf(tree) + " Node_ID=" + Node_ID);
                    }
                    rs.close();
                    sql = new StringBuffer();
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "verifyTree", (Throwable)e);
                    ok.set(false);
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    pstmt = null;
                }
                catch (Exception e) {
                    pstmt = null;
                }
                if (keyColumns != null && keyColumns.length > 0 && parentColumn != null) {
                    Object elementFilter = "";
                    if (C_Element_ID > 0) {
                        elementFilter = " AND st.C_Element_ID=" + C_Element_ID;
                    }
                    String whereClause = "NOT EXISTS (SELECT 1 FROM " + sourceTableName + " st WHERE " + nodeTableName + ".Node_ID = st." + keyColumns[0] + " AND " + nodeTableName + ".Parent_ID = COALESCE(st." + parentColumn.getColumnName() + ",0) " + (String)elementFilter + ") AND EXISTS (SELECT 1 FROM " + sourceTableName + " st WHERE " + nodeTableName + ".Parent_ID = st." + keyColumns[0] + (String)elementFilter + ") AND AD_Tree_ID = ? ";
                    List parentNodes = new Query(this.getCtx(), nodeTableName, whereClause, this.get_TrxName()).setParameters(new Object[]{tree.getAD_Tree_ID()}).list();
                    int updated = 0;
                    for (PO node : parentNodes) {
                        whereClause = keyColumns[0] + "=" + node.get_ID();
                        PO table = MTable.get((Properties)Env.getCtx(), (String)sourceTableName).getPO(whereClause, node.get_TrxName());
                        if (table.get_ID() > 0 && node.get_ID() > 0) {
                            if (node.get_ValueAsInt("Parent_ID") > 0) {
                                table.set_ValueOfColumn(parentColumn.getColumnName(), (Object)node.get_ValueAsInt("Parent_ID"));
                            } else {
                                table.set_ValueOfColumn(parentColumn.getColumnName(), null);
                            }
                            table.saveEx();
                        }
                        ++updated;
                    }
                    this.addLog(0, null, new BigDecimal(updated), tree.getName() + " Updated");
                }
                this.addLog(0, null, new BigDecimal(inserts), tree.getName() + " Inserted");
            }
        });
        return tree.getName() + ((Boolean)ok.get() != false ? " OK" : " Error");
    }
}

