/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.exceptions.InvoiceFullyMatchedException;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.process.InvoiceCreateInOutAbstract;
import org.compiere.util.Env;

public class InvoiceCreateInOut
extends InvoiceCreateInOutAbstract {
    public static final String PARAM_M_Warehouse_ID = "M_Warehouse_ID";
    private MInOut inOut = null;

    protected void prepare() {
        super.prepare();
    }

    protected String doIt() throws Exception {
        this.log.info("C_Invoice_ID=" + this.getRecord_ID() + ", M_Warehouse_ID=" + this.getWarehouseId());
        if (this.getRecord_ID() <= 0) {
            throw new FillMandatoryException(new String[]{"C_Invoice_ID"});
        }
        if (this.getWarehouseId() == 0) {
            throw new FillMandatoryException(new String[]{PARAM_M_Warehouse_ID});
        }
        MInvoice invoice = new MInvoice(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (invoice.get_ID() <= 0) {
            throw new AdempiereException("@NotFound@ @C_Invoice_ID@");
        }
        if (!"CO".equals(invoice.getDocStatus())) {
            throw new AdempiereException("@InvoiceCreateDocNotCompleted@");
        }
        for (MInvoiceLine invoiceLine : invoice.getLines(false)) {
            this.createLine(invoice, invoiceLine);
        }
        if (this.inOut == null) {
            throw new InvoiceFullyMatchedException();
        }
        return this.inOut.getDocumentNo();
    }

    private MInOut getCreateHeader(MInvoice invoice) {
        if (this.inOut != null) {
            return this.inOut;
        }
        this.inOut = new MInOut(invoice, 0, null, this.getWarehouseId());
        this.inOut.saveEx();
        return this.inOut;
    }

    private void createLine(MInvoice invoice, MInvoiceLine invoiceLine) {
        MOrderLine orderLine;
        BigDecimal qtyNotMatched;
        if (invoiceLine.getM_InOutLine_ID() > 0) {
            MInOutLine oldIol = new MInOutLine(this.getCtx(), invoiceLine.getM_InOutLine_ID(), this.get_TrxName());
            MInOut oldIo = (MInOut)oldIol.getM_InOut();
            String ds = oldIo.getDocStatus();
            if ("VO".equals(ds) || "RE".equals(ds)) {
                invoiceLine.setM_InOutLine_ID(0);
                invoiceLine.saveEx();
            } else {
                return;
            }
        }
        if (invoiceLine.getC_OrderLine_ID() > 0 && (qtyNotMatched = (orderLine = (MOrderLine)invoiceLine.getC_OrderLine()).getQtyOrdered().subtract(MMatchPO.getPOMatchedQuantity((MOrderLine)orderLine)).subtract(invoiceLine.getQtyInvoiced())).signum() < 0) {
            return;
        }
        MInOut inOut = this.getCreateHeader(invoice);
        MInOutLine inOutLine = new MInOutLine(inOut);
        inOutLine.setInvoiceLine(invoiceLine, 0, invoice.isSOTrx() ? invoiceLine.getQtyInvoiced() : Env.ZERO);
        inOutLine.setQtyEntered(invoiceLine.getQtyInvoiced());
        inOutLine.setMovementQty(invoiceLine.getQtyInvoiced());
        if (invoice.isCreditMemo()) {
            inOutLine.setQtyEntered(inOutLine.getQtyEntered().negate());
            inOutLine.setMovementQty(inOutLine.getMovementQty().negate());
        }
        inOutLine.saveEx();
        invoiceLine.setM_InOutLine_ID(inOutLine.getM_InOutLine_ID());
        invoiceLine.saveEx();
    }
}

