/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_M_Storage;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MLocator;
import org.compiere.model.MProduct;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MStorage
extends X_M_Storage {
    private static final long serialVersionUID = 9086223702645715061L;
    private static CLogger s_log = CLogger.getCLogger(MStorage.class);
    private int m_M_Warehouse_ID = 0;

    private static boolean isInstanceManaged(Properties ctx, int M_Product_ID) {
        MProduct prd = MProduct.get(ctx, M_Product_ID);
        if (prd == null) {
            return false;
        }
        int attributeSetId = prd.getM_AttributeSet_ID();
        if (attributeSetId <= 0) {
            return false;
        }
        MAttributeSet mas = MAttributeSet.get((Properties)ctx, (int)attributeSetId);
        return mas != null && mas.isInstanceAttribute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MStorage get(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        MStorage retValue = null;
        Object sql = "SELECT * FROM M_Storage WHERE M_Locator_ID=? AND M_Product_ID=? AND ";
        sql = M_AttributeSetInstance_ID == 0 ? (String)sql + "(M_AttributeSetInstance_ID=? OR M_AttributeSetInstance_ID IS NULL)" : (String)sql + "M_AttributeSetInstance_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Locator_ID);
            pstmt.setInt(2, M_Product_ID);
            pstmt.setInt(3, M_AttributeSetInstance_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MStorage(ctx, rs, trxName);
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, (String)sql, (Throwable)ex);
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (retValue == null) {
            s_log.fine("Not Found - M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
        } else {
            s_log.fine("M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID);
        }
        return retValue;
    }

    public static MStorage getQtyReserved(Properties ctx, int productId, int warehouseId, int attributeSetInstanceId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("EXISTS (SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID=M_Storage.M_Locator_ID AND l.M_Warehouse_ID=? ) AND ");
        whereClause.append("M_Product_ID").append("=? AND ");
        if (attributeSetInstanceId == 0) {
            whereClause.append("(").append("M_AttributeSetInstance_ID").append("=?").append(" OR ").append("M_AttributeSetInstance_ID").append(" IS NULL").append(")");
        } else {
            whereClause.append("M_AttributeSetInstance_ID").append("=?");
        }
        whereClause.append(" AND QtyReserved <> 0");
        return (MStorage)new Query(ctx, "M_Storage", whereClause.toString(), trxName).setClient_ID().setParameters(new Object[]{warehouseId, productId, attributeSetInstanceId}).setOrderBy("QtyReserved Desc").first();
    }

    public static MStorage getQtyOrdered(Properties ctx, int productId, int warehouseId, int attributeSetInstanceId, String trxName) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("EXISTS (SELECT 1 FROM M_Locator l WHERE l.M_Locator_ID=M_Storage.M_Locator_ID AND l.M_Warehouse_ID=? ) AND ");
        whereClause.append("M_Product_ID").append("=? AND ");
        if (attributeSetInstanceId == 0) {
            whereClause.append("(").append("M_AttributeSetInstance_ID").append("=?").append(" OR ").append("M_AttributeSetInstance_ID").append(" IS NULL").append(")");
        } else {
            whereClause.append("M_AttributeSetInstance_ID").append("=?");
        }
        whereClause.append(" AND QtyOrdered <> 0");
        return (MStorage)new Query(ctx, "M_Storage", whereClause.toString(), trxName).setClient_ID().setParameters(new Object[]{warehouseId, productId, attributeSetInstanceId}).setOrderBy("QtyOrdered").first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MStorage[] getAllWithASI(Properties ctx, int M_Product_ID, int M_Locator_ID, boolean FiFo, String trxName) {
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        Object sql = "SELECT * FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID > 0  AND QtyOnHand <> 0 ORDER BY M_AttributeSetInstance_ID";
        if (!FiFo) {
            sql = (String)sql + " DESC";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Locator_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStorage(ctx, rs, trxName));
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, (String)sql, (Throwable)ex);
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MStorage[] getAll(Properties ctx, int M_Product_ID, int M_Locator_ID, String trxName) {
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        String sql = "SELECT * FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=? AND QtyOnHand <> 0 ORDER BY M_AttributeSetInstance_ID";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Locator_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStorage(ctx, rs, trxName));
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MStorage[] getOfProduct(Properties ctx, int M_Product_ID, String trxName) {
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        String sql = "SELECT * FROM M_Storage WHERE M_Product_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Product_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStorage(ctx, rs, trxName));
            }
        }
        catch (SQLException ex) {
            try {
                s_log.log(Level.SEVERE, sql, (Throwable)ex);
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorage[] getWarehouse(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int M_AttributeSet_ID, boolean allAttributeInstances, Timestamp minGuaranteeDate, boolean FiFo, String trxName) {
        return MStorage.getWarehouse(ctx, M_Warehouse_ID, M_Product_ID, M_AttributeSetInstance_ID, minGuaranteeDate, FiFo, false, 0, trxName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MStorage[] getWarehouse(Properties ctx, int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, Timestamp minGuaranteeDate, boolean FiFo, boolean positiveOnly, int M_Locator_ID, String trxName) {
        if (M_Warehouse_ID == 0 && M_Locator_ID == 0 || M_Product_ID == 0) {
            return new MStorage[0];
        }
        boolean allAttributeInstances = M_AttributeSetInstance_ID == 0;
        ArrayList<MStorage> list = new ArrayList<MStorage>();
        Object sql = "SELECT s.* FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) ";
        sql = M_Locator_ID > 0 ? (String)sql + "WHERE l.M_Locator_ID = ?" : (String)sql + "WHERE l.M_Warehouse_ID=?";
        sql = (String)sql + " AND s.M_Product_ID=? AND COALESCE(s.M_AttributeSetInstance_ID,0)=? ";
        sql = positiveOnly ? (String)sql + " AND s.QtyOnHand > 0 " : (String)sql + " AND s.QtyOnHand <> 0 ";
        sql = (String)sql + " ORDER BY l.PriorityNo DESC, M_AttributeSetInstance_ID";
        if (!FiFo) {
            sql = (String)sql + " DESC";
        }
        if (allAttributeInstances) {
            sql = "SELECT s.* FROM M_Storage s INNER JOIN M_Locator l ON (l.M_Locator_ID=s.M_Locator_ID) LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) ";
            sql = M_Locator_ID > 0 ? (String)sql + "WHERE l.M_Locator_ID = ?" : (String)sql + "WHERE l.M_Warehouse_ID=?";
            sql = (String)sql + " AND s.M_Product_ID=? ";
            sql = positiveOnly ? (String)sql + " AND s.QtyOnHand > 0 " : (String)sql + " AND s.QtyOnHand <> 0 ";
            if (minGuaranteeDate != null) {
                sql = (String)sql + "AND (asi.GuaranteeDate IS NULL OR asi.GuaranteeDate>?) ORDER BY l.PriorityNo DESC, asi.GuaranteeDate, s.QtyOnHand ,M_AttributeSetInstance_ID";
                if (!FiFo) {
                    sql = (String)sql + " DESC";
                }
            } else {
                sql = (String)sql + "ORDER BY l.PriorityNo DESC, l.M_Locator_ID, s.QtyOnHand,s.M_AttributeSetInstance_ID";
                if (!FiFo) {
                    sql = (String)sql + " DESC";
                }
            }
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Locator_ID > 0 ? M_Locator_ID : M_Warehouse_ID);
            pstmt.setInt(2, M_Product_ID);
            if (!allAttributeInstances) {
                pstmt.setInt(3, M_AttributeSetInstance_ID);
            } else if (minGuaranteeDate != null) {
                pstmt.setTimestamp(3, minGuaranteeDate);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getBigDecimal("QtyOnHand").signum() == 0) continue;
                list.add(new MStorage(ctx, rs, trxName));
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, (String)sql, (Throwable)e);
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        MStorage[] retValue = new MStorage[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MStorage getCreate(Properties ctx, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        if (M_Locator_ID == 0) {
            throw new IllegalArgumentException("M_Locator_ID=0");
        }
        if (M_Product_ID == 0) {
            throw new IllegalArgumentException("M_Product_ID=0");
        }
        MStorage retValue = MStorage.get(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, trxName);
        if (retValue != null) {
            return retValue;
        }
        MLocator locator = new MLocator(ctx, M_Locator_ID, trxName);
        if (locator.get_ID() != M_Locator_ID) {
            throw new IllegalArgumentException("Not found M_Locator_ID=" + M_Locator_ID);
        }
        retValue = new MStorage(locator, M_Product_ID, M_AttributeSetInstance_ID);
        retValue.saveEx(trxName);
        s_log.fine("New " + String.valueOf((Object)retValue));
        return retValue;
    }

    public static boolean add(Properties ctx, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, int reservationAttributeSetInstance_ID, BigDecimal qtyOnHand, BigDecimal qtyReserved, BigDecimal qtyOrdered, String trxName) {
        boolean needSeparateResOrd;
        MStorage storage;
        if (!(qtyOnHand != null && qtyOnHand.signum() != 0 || qtyReserved != null && qtyReserved.signum() != 0 || qtyOrdered != null && qtyOrdered.signum() != 0)) {
            return true;
        }
        boolean isInstance = MStorage.isInstanceManaged(ctx, M_Product_ID);
        if (!isInstance) {
            M_AttributeSetInstance_ID = 0;
            reservationAttributeSetInstance_ID = 0;
        }
        if ((storage = MStorage.get(ctx, M_Locator_ID, M_Product_ID, M_AttributeSetInstance_ID, trxName)) == null) {
            MWarehouse wh = MWarehouse.get((Properties)ctx, (int)M_Warehouse_ID);
            storage = new MStorage(ctx, 0, trxName);
            storage.setClientOrg(wh.getAD_Client_ID(), wh.getAD_Org_ID());
            storage.setM_Locator_ID(M_Locator_ID);
            storage.setM_Product_ID(M_Product_ID);
            storage.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
            storage.setQtyOnHand(Env.ZERO);
            storage.setQtyReserved(Env.ZERO);
            storage.setQtyOrdered(Env.ZERO);
        }
        if (qtyOnHand != null && qtyOnHand.signum() != 0) {
            storage.setQtyOnHand(storage.getQtyOnHand().add(qtyOnHand));
        }
        MStorage storageResOrd = storage;
        boolean bl = needSeparateResOrd = reservationAttributeSetInstance_ID != M_AttributeSetInstance_ID;
        if (needSeparateResOrd) {
            MWarehouse wh;
            int xM_Locator_ID;
            MStorage s0 = MStorage.getQtyReserved(ctx, M_Product_ID, M_Warehouse_ID, reservationAttributeSetInstance_ID, trxName);
            if (s0 == null) {
                s0 = MStorage.getQtyOrdered(ctx, M_Product_ID, M_Warehouse_ID, reservationAttributeSetInstance_ID, trxName);
            }
            if (s0 == null && (s0 = MStorage.get(ctx, xM_Locator_ID = (wh = MWarehouse.get((Properties)ctx, (int)M_Warehouse_ID)).getDefaultLocator().getM_Locator_ID(), M_Product_ID, reservationAttributeSetInstance_ID, trxName)) == null) {
                s0 = new MStorage(ctx, 0, trxName);
                s0.setClientOrg(wh.getAD_Client_ID(), wh.getAD_Org_ID());
                s0.setM_Locator_ID(xM_Locator_ID);
                s0.setM_Product_ID(M_Product_ID);
                s0.setM_AttributeSetInstance_ID(reservationAttributeSetInstance_ID);
                s0.setQtyOnHand(Env.ZERO);
                s0.setQtyReserved(Env.ZERO);
                s0.setQtyOrdered(Env.ZERO);
            }
            storageResOrd = s0;
        }
        if (qtyReserved != null && qtyReserved.signum() != 0) {
            storageResOrd.setQtyReserved(storageResOrd.getQtyReserved().add(qtyReserved));
        }
        if (qtyOrdered != null && qtyOrdered.signum() != 0) {
            storageResOrd.setQtyOrdered(storageResOrd.getQtyOrdered().add(qtyOrdered));
        }
        if (storageResOrd != storage) {
            storageResOrd.saveEx(trxName);
        }
        storage.saveEx(trxName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getM_Locator_ID(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, BigDecimal Qty, String trxName) {
        int M_Locator_ID = 0;
        int firstM_Locator_ID = 0;
        String sql = "SELECT s.M_Locator_ID, s.QtyOnHand FROM M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Product p ON (s.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN M_AttributeSet mas ON (p.M_AttributeSet_ID=mas.M_AttributeSet_ID) WHERE l.M_Warehouse_ID=? AND s.M_Product_ID=? AND (mas.IsInstanceAttribute IS NULL OR mas.IsInstanceAttribute='N' OR s.M_AttributeSetInstance_ID=?) AND l.IsActive='Y' ORDER BY l.PriorityNo DESC, s.QtyOnHand DESC";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)trxName);
            pstmt.setInt(1, M_Warehouse_ID);
            pstmt.setInt(2, M_Product_ID);
            pstmt.setInt(3, M_AttributeSetInstance_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal QtyOnHand = rs.getBigDecimal(2);
                if (QtyOnHand != null && Qty.compareTo(QtyOnHand) <= 0) {
                    M_Locator_ID = rs.getInt(1);
                    break;
                }
                if (firstM_Locator_ID != 0) continue;
                firstM_Locator_ID = rs.getInt(1);
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        finally {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (M_Locator_ID != 0) {
            return M_Locator_ID;
        }
        return firstM_Locator_ID;
    }

    public static BigDecimal getQtyAvailable(int M_Warehouse_ID, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        return MStorage.getQtyAvailable(M_Warehouse_ID, 0, M_Product_ID, M_AttributeSetInstance_ID, trxName);
    }

    public static BigDecimal getQtyAvailable(int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuffer sql = new StringBuffer("SELECT COALESCE(SUM(s.QtyOnHand-s.QtyReserved),0)").append(" FROM M_Storage s").append(" WHERE s.M_Product_ID=?");
        params.add(M_Product_ID);
        if (M_Locator_ID == 0) {
            sql.append(" AND EXISTS (SELECT 1 FROM M_Locator l WHERE s.M_Locator_ID=l.M_Locator_ID AND l.M_Warehouse_ID=?)");
            params.add(M_Warehouse_ID);
        } else {
            sql.append(" AND s.M_Locator_ID=?");
            params.add(M_Locator_ID);
        }
        if (M_AttributeSetInstance_ID != 0) {
            sql.append(" AND s.M_AttributeSetInstance_ID=?");
            params.add(M_AttributeSetInstance_ID);
        }
        BigDecimal retValue = DB.getSQLValueBD((String)trxName, (String)sql.toString(), params);
        if (CLogMgt.isLevelFine()) {
            s_log.fine("M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID + ",M_Product_ID=" + M_Product_ID + " = " + String.valueOf(retValue));
        }
        return retValue;
    }

    public MStorage(Properties ctx, int storageId, String trxName) {
        super(ctx, storageId, trxName);
        if (storageId <= 0) {
            this.setQtyOnHand(Env.ZERO);
            this.setQtyOrdered(Env.ZERO);
            this.setQtyReserved(Env.ZERO);
        }
    }

    public MStorage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    private MStorage(MLocator locator, int M_Product_ID, int M_AttributeSetInstance_ID) {
        this(locator.getCtx(), 0, locator.get_TrxName());
        this.setClientOrg((PO)locator);
        this.setM_Locator_ID(locator.getM_Locator_ID());
        this.setM_Product_ID(M_Product_ID);
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
    }

    public void changeQtyOnHand(BigDecimal qty, boolean add) {
        if (qty == null || qty.signum() == 0) {
            return;
        }
        if (add) {
            this.setQtyOnHand(this.getQtyOnHand().add(qty));
        } else {
            this.setQtyOnHand(this.getQtyOnHand().subtract(qty));
        }
    }

    public int getM_Warehouse_ID() {
        if (this.m_M_Warehouse_ID == 0) {
            MLocator loc = MLocator.get((Properties)this.getCtx(), (int)this.getM_Locator_ID());
            this.m_M_Warehouse_ID = loc.getM_Warehouse_ID();
        }
        return this.m_M_Warehouse_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MStorage[").append("M_Locator_ID=").append(this.getM_Locator_ID()).append(",M_Product_ID=").append(this.getM_Product_ID()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append(": OnHand=").append(this.getQtyOnHand()).append(",Reserved=").append(this.getQtyReserved()).append(",Ordered=").append(this.getQtyOrdered()).append("]");
        return sb.toString();
    }
}

