/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.adempiere.core.domains.models.I_C_BPartner;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.core.domains.models.X_PP_Product_BOM;
import org.adempiere.core.domains.models.X_PP_Product_BOMLine;
import org.adempiere.core.domains.models.X_PP_Product_Planning;
import org.adempiere.exceptions.BPartnerNoBillToAddressException;
import org.adempiere.exceptions.BPartnerNoShipToAddressException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderTax;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MRMA;
import org.compiere.model.MRefList;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MSalesRegion;
import org.compiere.model.MStorage;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MOrder
extends X_C_Order
implements DocAction {
    private static final long serialVersionUID = 6238231989649199067L;
    private MOrderLine[] m_lines = null;
    private MOrderTax[] m_taxes = null;
    private boolean m_forceCreation = false;
    public static final String DocSubTypeSO_Standard = "SO";
    public static final String DocSubTypeSO_Quotation = "OB";
    public static final String DocSubTypeSO_Proposal = "ON";
    public static final String DocSubTypeSO_Prepay = "PR";
    public static final String DocSubTypeSO_POS = "WR";
    public static final String DocSubTypeSO_Warehouse = "WP";
    public static final String DocSubTypeSO_OnCredit = "WI";
    public static final String DocSubTypeSO_RMA = "RM";
    public static final String DocSubTypeSO_InvoiceOrder = "IO";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MOrder copyFrom(MOrder from, Timestamp dateDoc, int C_DocTypeTarget_ID, boolean isSOTrx, boolean counter, boolean copyASI, String trxName) {
        MOrder to = new MOrder(from.getCtx(), 0, trxName);
        to.set_TrxName(trxName);
        PO.copyValues((PO)from, (PO)to, (int)from.getAD_Client_ID(), (int)from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Order_ID", I_ZERO);
        to.set_ValueNoCheck("DocumentNo", null);
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        to.setIsSOTrx(isSOTrx);
        to.setC_Opportunity_ID(from.getC_Opportunity_ID());
        to.setIsSelected(false);
        to.setDateOrdered(dateDoc);
        to.setDateAcct(dateDoc);
        to.setDatePromised(dateDoc);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setIsCreditApproved(false);
        to.setC_Payment_ID(0);
        to.setC_CashLine_ID(0);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setIsDelivered(false);
        to.setIsInvoiced(false);
        to.setIsSelfService(false);
        to.setIsTransferred(false);
        to.setPosted(false);
        to.setProcessed(false);
        if (counter) {
            to.setRef_Order_ID(from.getC_Order_ID());
        } else {
            to.setRef_Order_ID(0);
        }
        to.saveEx(trxName);
        if (counter) {
            from.setRef_Order_ID(to.getC_Order_ID());
        }
        if (to.copyLinesFrom(from, counter, copyASI) == 0) {
            throw new IllegalStateException("Could not create Order Lines");
        }
        to.setLink_Order_ID(0);
        return to;
    }

    public MOrder(Properties ctx, int C_Order_ID, String trxName) {
        super(ctx, C_Order_ID, trxName);
        if (C_Order_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction(DocSubTypeSO_Prepay);
            this.setDeliveryRule("A");
            this.setFreightCostRule("I");
            this.setInvoiceRule("I");
            this.setPaymentRule("P");
            this.setPriorityRule("5");
            this.setDeliveryViaRule("P");
            this.setIsDiscountPrinted(false);
            this.setIsSelected(false);
            this.setIsTaxIncluded(false);
            this.setIsSOTrx(true);
            this.setIsDropShip(false);
            this.setSendEMail(false);
            this.setIsApproved(false);
            this.setIsPrinted(false);
            this.setIsCreditApproved(false);
            this.setIsDelivered(false);
            this.setIsInvoiced(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            super.setProcessed(false);
            this.setProcessing(false);
            this.setPosted(false);
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setDatePromised(new Timestamp(System.currentTimeMillis()));
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
            this.setFreightAmt(Env.ZERO);
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
        }
    }

    public MOrder(MProject project, boolean IsSOTrx, String DocSubTypeSO) {
        this(project.getCtx(), 0, project.get_TrxName());
        this.setAD_Client_ID(project.getAD_Client_ID());
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setSalesRep_ID(project.getSalesRep_ID());
        this.setC_Project_ID(project.getC_Project_ID());
        this.setC_Activity_ID(project.getC_Activity_ID());
        this.setC_Campaign_ID(project.getC_Campaign_ID());
        this.setAD_OrgTrx_ID(project.getAD_OrgTrx_ID());
        this.setUser1_ID(project.getUser1_ID());
        this.setUser2_ID(project.getUser2_ID());
        this.setUser3_ID(project.getUser3_ID());
        this.setUser4_ID(project.getUser4_ID());
        this.setDescription(project.getName());
        Timestamp ts = project.getDateContract();
        if (ts != null) {
            this.setDateOrdered(ts);
        }
        if ((ts = project.getDateFinish()) != null) {
            this.setDatePromised(ts);
        }
        this.setC_BPartner_ID(project.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(project.getC_BPartner_Location_ID());
        this.setAD_User_ID(project.getAD_User_ID());
        this.setM_Warehouse_ID(project.getM_Warehouse_ID());
        this.setM_PriceList_ID(project.getM_PriceList_ID());
        this.setC_PaymentTerm_ID(project.getC_PaymentTerm_ID());
        this.setIsSOTrx(IsSOTrx);
        if (IsSOTrx) {
            if (DocSubTypeSO == null || DocSubTypeSO.length() == 0) {
                this.setC_DocTypeTarget_ID(DocSubTypeSO_OnCredit);
            } else {
                this.setC_DocTypeTarget_ID(DocSubTypeSO);
            }
        } else {
            this.setC_DocTypeTarget_ID();
        }
    }

    public MOrder(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public void setC_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
        super.setBill_BPartner_ID(C_BPartner_ID);
    }

    public void setC_BPartner_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
        super.setBill_Location_ID(C_BPartner_Location_ID);
    }

    public void setAD_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
        super.setBill_User_ID(AD_User_ID);
    }

    public void setShip_BPartner_ID(int C_BPartner_ID) {
        super.setC_BPartner_ID(C_BPartner_ID);
    }

    public void setShip_Location_ID(int C_BPartner_Location_ID) {
        super.setC_BPartner_Location_ID(C_BPartner_Location_ID);
    }

    public void setShip_User_ID(int AD_User_ID) {
        super.setAD_User_ID(AD_User_ID);
    }

    public void setM_Warehouse_ID(int M_Warehouse_ID) {
        super.setM_Warehouse_ID(M_Warehouse_ID);
    }

    public void setIsDropShip(boolean IsDropShip) {
        super.setIsDropShip(IsDropShip);
    }

    public void setC_DocTypeTarget_ID(String DocSubTypeSO_x) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocSubTypeSO=?  AND IsActive='Y' ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID(), (String)DocSubTypeSO_x);
        if (C_DocType_ID <= 0) {
            this.log.severe("Not found for AD_Client_ID=" + this.getAD_Client_ID() + ", SubType=" + DocSubTypeSO_x);
        } else {
            this.log.fine("(SO) - " + DocSubTypeSO_x);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            this.setIsSOTrx(true);
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
            return;
        }
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID IN (0," + this.getAD_Org_ID() + ") AND DocBaseType='POO' ORDER BY AD_Org_ID DESC, IsDefault DESC";
        int C_DocType_ID = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
        if (C_DocType_ID <= 0) {
            this.log.severe("No POO found for AD_Client_ID=" + this.getAD_Client_ID());
        } else {
            this.log.fine("(PO) - " + C_DocType_ID);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
        }
    }

    public void setBPartner(MBPartner bp) {
        String ss;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getDeliveryRule()) != null && ss.trim().length() != 0) {
            this.setDeliveryRule(ss);
        }
        if ((ss = bp.getDeliveryViaRule()) != null && ss.trim().length() != 0) {
            this.setDeliveryViaRule(ss);
        }
        if ((ss = bp.getInvoiceRule()) != null && ss.trim().length() != 0) {
            this.setInvoiceRule(ss);
        }
        if ((ss = bp.getPaymentRule()) != null && ss.trim().length() != 0) {
            this.setPaymentRule(ss);
        }
        if ((ii = bp.getSalesRep_ID()) != 0) {
            this.setSalesRep_ID(ii);
        }
        this.setIsDiscountPrinted(bp.isDiscountPrinted());
        MBPartnerLocation[] locs = bp.getLocations(false);
        if (locs != null) {
            for (int i = 0; i < locs.length; ++i) {
                if (locs[i].isShipTo()) {
                    super.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
                }
                if (!locs[i].isBillTo()) continue;
                this.setBill_Location_ID(locs[i].getC_BPartner_Location_ID());
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                super.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
            if (this.getBill_Location_ID() == 0 && locs.length > 0) {
                this.setBill_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            throw new BPartnerNoShipToAddressException((I_C_BPartner)bp);
        }
        if (this.getBill_Location_ID() == 0) {
            throw new BPartnerNoBillToAddressException((I_C_BPartner)bp);
        }
        MUser[] contacts = bp.getContacts(false);
        if (contacts != null && contacts.length == 1) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public int copyLinesFrom(MOrder otherOrder, boolean counter, boolean copyASI) {
        if (this.isProcessed() || this.isPosted() || otherOrder == null) {
            return 0;
        }
        MOrderLine[] fromLines = otherOrder.getLines(false, null);
        int count = 0;
        for (int i = 0; i < fromLines.length; ++i) {
            MOrderLine line = new MOrderLine(this);
            PO.copyValues((PO)fromLines[i], (PO)line, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID());
            line.setC_Order_ID(this.getC_Order_ID());
            line.setQtyDelivered(Env.ZERO);
            line.setQtyInvoiced(Env.ZERO);
            line.setQtyReserved(Env.ZERO);
            line.setDateDelivered(null);
            line.setDateInvoiced(null);
            line.setOrder(this);
            line.set_ValueNoCheck("C_OrderLine_ID", I_ZERO);
            if (!copyASI) {
                line.setM_AttributeSetInstance_ID(0);
                line.setS_ResourceAssignment_ID(0);
            }
            if (counter) {
                line.setRef_OrderLine_ID(fromLines[i].getC_OrderLine_ID());
            } else {
                line.setRef_OrderLine_ID(0);
            }
            line.setLink_OrderLine_ID(0);
            if (this.getC_BPartner_ID() != otherOrder.getC_BPartner_ID()) {
                line.setTax();
            }
            line.setProcessed(false);
            line.saveEx(this.get_TrxName());
            ++count;
            if (!counter) continue;
            fromLines[i].setRef_OrderLine_ID(line.getC_OrderLine_ID());
            fromLines[i].saveEx(this.get_TrxName());
        }
        if (fromLines.length != count) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MOrder[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",IsSOTrx=").append(this.isSOTrx()).append(",C_DocType_ID=").append(this.getC_DocType_ID()).append(", GrandTotal=").append(this.getGrandTotal()).append("]");
        return sb.toString();
    }

    public String getDocumentInfo() {
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get((Properties)this.getCtx(), (int)0, (int)this.getC_Order_ID(), (String)this.get_TrxName());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get((Properties)this.getCtx(), (int)M_PriceList_ID, (String)this.get_TrxName());
        if (pl.get_ID() == M_PriceList_ID) {
            super.setM_PriceList_ID(M_PriceList_ID);
            this.setC_Currency_ID(pl.getC_Currency_ID());
            this.setIsTaxIncluded(pl.isTaxIncluded());
        }
    }

    public MOrderLine[] getLines(String whereClause, String orderClause) {
        StringBuffer whereClauseFinal = new StringBuffer("C_Order_ID=? ");
        if (!Util.isEmpty((String)whereClause, (boolean)true)) {
            whereClauseFinal.append(whereClause);
        }
        if (orderClause.length() == 0) {
            orderClause = "Line";
        }
        List list = new Query(this.getCtx(), "C_OrderLine", whereClauseFinal.toString(), this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy(orderClause).list();
        for (MOrderLine ol : list) {
            ol.setHeaderInfo(this);
        }
        return list.toArray(new MOrderLine[list.size()]);
    }

    public MOrderLine[] getLines(boolean requery, String orderBy) {
        if (this.m_lines != null && this.m_lines.length > 0 && !requery) {
            MOrder.set_TrxName((PO[])this.m_lines, (String)this.get_TrxName());
            return this.m_lines;
        }
        Object orderClause = "";
        orderClause = orderBy != null && orderBy.length() > 0 ? (String)orderClause + orderBy : (String)orderClause + "Line";
        this.m_lines = this.getLines(null, (String)orderClause);
        return this.m_lines;
    }

    public MOrderLine[] getLines() {
        return this.getLines(false, null);
    }

    public void renumberLines(int step) {
        int number = step;
        MOrderLine[] lines = this.getLines(true, null);
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine line = lines[i];
            line.setLine(number);
            line.saveEx(this.get_TrxName());
            number += step;
        }
        this.m_lines = null;
    }

    public boolean isOrderLine(int C_OrderLine_ID) {
        if (this.m_lines == null) {
            this.getLines();
        }
        for (int i = 0; i < this.m_lines.length; ++i) {
            if (this.m_lines[i].getC_OrderLine_ID() != C_OrderLine_ID) continue;
            return true;
        }
        return false;
    }

    public MOrderTax[] getTaxes(boolean requery) {
        if (this.m_taxes != null && !requery) {
            return this.m_taxes;
        }
        List list = new Query(this.getCtx(), "C_OrderTax", "C_Order_ID=?", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).list();
        this.m_taxes = list.toArray(new MOrderTax[list.size()]);
        return this.m_taxes;
    }

    public MInvoice[] getInvoices() {
        String whereClause = "EXISTS (SELECT 1 FROM C_InvoiceLine il, C_OrderLine ol WHERE il.C_Invoice_ID=C_Invoice.C_Invoice_ID AND il.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)";
        List list = new Query(this.getCtx(), "C_Invoice", "EXISTS (SELECT 1 FROM C_InvoiceLine il, C_OrderLine ol WHERE il.C_Invoice_ID=C_Invoice.C_Invoice_ID AND il.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("C_Invoice_ID DESC").list();
        return list.toArray(new MInvoice[list.size()]);
    }

    public int getC_Invoice_ID() {
        String sql = "SELECT C_Invoice_ID FROM C_Invoice WHERE C_Order_ID=? AND DocStatus IN ('CO','CL') ORDER BY C_Invoice_ID DESC";
        int C_Invoice_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.get_ID());
        return C_Invoice_ID;
    }

    public MInOut[] getShipments() {
        String whereClause = "EXISTS (SELECT 1 FROM M_InOutLine iol, C_OrderLine ol WHERE iol.M_InOut_ID=M_InOut.M_InOut_ID AND iol.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)";
        List list = new Query(this.getCtx(), "M_InOut", "EXISTS (SELECT 1 FROM M_InOutLine iol, C_OrderLine ol WHERE iol.M_InOut_ID=M_InOut.M_InOut_ID AND iol.C_OrderLine_ID=ol.C_OrderLine_ID AND ol.C_Order_ID=?)", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("M_InOut_ID DESC").list();
        return list.toArray(new MInOut[list.size()]);
    }

    public List<MRMA> getRMA() {
        String whereClause = "EXISTS (SELECT 1 FROM M_InOut io  WHERE io.M_InOut_ID=M_RMA.InOut_ID AND io.C_Order_ID = ?)";
        return new Query(this.getCtx(), "M_RMA", "EXISTS (SELECT 1 FROM M_InOut io  WHERE io.M_InOut_ID=M_RMA.InOut_ID AND io.C_Order_ID = ?)", this.get_TrxName()).setParameters(new Object[]{this.get_ID()}).setOrderBy("M_RMA_ID DESC").list();
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision((Properties)this.getCtx(), (int)this.getC_Currency_ID());
    }

    public String getDocStatusName() {
        return MRefList.getListName((Properties)this.getCtx(), (int)131, (String)this.getDocStatus());
    }

    public void setDocAction(String DocAction2) {
        this.setDocAction(DocAction2, false);
    }

    public void setDocAction(String DocAction2, boolean forceCreation) {
        super.setDocAction(DocAction2);
        this.m_forceCreation = forceCreation;
    }

    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Order_ID=" + this.getC_Order_ID();
        int noLine = DB.executeUpdateEx((String)("UPDATE C_OrderLine " + set), (String)this.get_TrxName());
        int noTax = DB.executeUpdateEx((String)("UPDATE C_OrderTax " + set), (String)this.get_TrxName());
        this.m_lines = null;
        this.m_taxes = null;
        this.log.fine("setProcessed - " + processed + " - Lines=" + noLine + ", Tax=" + noTax);
    }

    protected boolean beforeSave(boolean newRecord) {
        int ii;
        MWarehouse wh;
        int context_AD_Org_ID;
        if (this.getAD_Org_ID() == 0 && (context_AD_Org_ID = Env.getAD_Org_ID((Properties)this.getCtx())) != 0) {
            this.setAD_Org_ID(context_AD_Org_ID);
            this.log.warning("Changed Org to Context=" + context_AD_Org_ID);
        }
        if (this.getAD_Client_ID() == 0) {
            this.m_processMsg = "AD_Client_ID = 0";
            return false;
        }
        if (newRecord && this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getM_Warehouse_ID() == 0) {
            int ii2 = Env.getContextAsInt((Properties)this.getCtx(), (String)"#M_Warehouse_ID");
            if (ii2 != 0) {
                this.setM_Warehouse_ID(ii2);
            } else {
                throw new FillMandatoryException(new String[]{"M_Warehouse_ID"});
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("M_Warehouse_ID")) && (wh = MWarehouse.get((Properties)this.getCtx(), (int)this.getM_Warehouse_ID())).getAD_Org_ID() != this.getAD_Org_ID()) {
            this.log.saveWarning("WarehouseOrgConflict", "");
        }
        if (!newRecord && this.is_ValueChanged("M_Warehouse_ID")) {
            MOrderLine[] lines = this.getLines(false, null);
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].canChangeWarehouse()) continue;
                return false;
            }
        }
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate((Properties)this.getCtx(), (int)this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null));
        }
        if (this.getBill_BPartner_ID() == 0) {
            this.setBill_BPartner_ID(this.getC_BPartner_ID());
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if (this.getBill_Location_ID() == 0) {
            this.setBill_Location_ID(this.getC_BPartner_Location_ID());
        }
        if (this.getM_PriceList_ID() == 0 && (ii = DB.getSQLValueEx(null, (String)"SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsSOPriceList=? AND IsActive=? ORDER BY IsDefault DESC", (Object[])new Object[]{this.getAD_Client_ID(), this.isSOTrx(), true})) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if (this.getC_Currency_ID() == 0) {
            String sql = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, (String)sql, (int)this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(Env.getContextAsInt((Properties)this.getCtx(), (String)"#C_Currency_ID"));
            }
        }
        if (this.getC_SalesRegion_ID() == 0) {
            MBPartnerLocation shiLocation;
            MBPartnerLocation shipLocation;
            int salesRegionId = 0;
            if (this.getC_BPartner_Location_ID() != 0 && (shipLocation = (MBPartnerLocation)this.getC_BPartner_Location()).getC_SalesRegion_ID() != 0) {
                salesRegionId = shipLocation.getC_SalesRegion_ID();
            }
            if (this.getBill_Location_ID() != 0 && (shiLocation = (MBPartnerLocation)this.getBill_Location()).getC_SalesRegion_ID() != 0) {
                salesRegionId = shiLocation.getC_SalesRegion_ID();
            }
            if (salesRegionId != 0) {
                this.setC_SalesRegion_ID(salesRegionId);
            }
        }
        if (this.getSalesRep_ID() == 0) {
            MSalesRegion salesRegion;
            int salesRepresentativeId = 0;
            MBPartner businessPartner = (MBPartner)this.getC_BPartner();
            if (businessPartner.getSalesRep_ID() != 0) {
                salesRepresentativeId = businessPartner.getSalesRep_ID();
            }
            if (salesRepresentativeId == 0 && this.getC_SalesRegion_ID() != 0 && (salesRegion = MSalesRegion.getById((Properties)this.getCtx(), (int)this.getC_SalesRegion_ID(), (String)this.get_TrxName())).getSalesRep_ID() != 0) {
                salesRepresentativeId = salesRegion.getSalesRep_ID();
            }
            if (salesRepresentativeId == 0) {
                salesRepresentativeId = Env.getContextAsInt((Properties)this.getCtx(), (String)"#SalesRep_ID");
            }
            if (salesRepresentativeId != 0) {
                this.setSalesRep_ID(salesRepresentativeId);
            }
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(DocSubTypeSO_Standard);
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = Env.getContextAsInt((Properties)this.getCtx(), (String)"#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                String sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii = DB.getSQLValue(null, (String)sql, (int)this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        return true;
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        int no;
        String sql;
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("Description") || this.is_ValueChanged("POReference")) {
            sql = "UPDATE C_Invoice i SET (Description,POReference)=(SELECT Description,POReference FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID) WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdateEx((String)sql, (String)this.get_TrxName());
            this.log.fine("Description -> #" + no);
        }
        if (this.is_ValueChanged("PaymentRule") || this.is_ValueChanged("C_PaymentTerm_ID") || this.is_ValueChanged("C_Payment_ID") || this.is_ValueChanged("C_CashLine_ID")) {
            sql = "UPDATE C_Invoice i SET (PaymentRule,C_PaymentTerm_ID,C_Payment_ID,C_CashLine_ID)=(SELECT PaymentRule,C_PaymentTerm_ID,C_Payment_ID,C_CashLine_ID FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID)WHERE DocStatus NOT IN ('RE','CL') AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("Payment -> #" + no);
        }
        if (this.is_ValueChanged("DateAcct")) {
            sql = "UPDATE C_Invoice i SET (DateAcct)=(SELECT DateAcct FROM C_Order o WHERE i.C_Order_ID=o.C_Order_ID)WHERE DocStatus NOT IN ('CO','RE','CL') AND Processed='N' AND C_Order_ID=" + this.getC_Order_ID();
            no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
            this.log.fine("DateAcct -> #" + no);
        }
        if (this.is_ValueChanged("AD_Org_ID") || this.is_ValueChanged("C_BPartner_ID") || this.is_ValueChanged("C_BPartner_Location_ID") || this.is_ValueChanged("DateOrdered") || this.is_ValueChanged("DatePromised") || this.is_ValueChanged("M_Warehouse_ID") || this.is_ValueChanged("M_Shipper_ID") || this.is_ValueChanged("C_Currency_ID")) {
            MOrderLine[] lines;
            for (MOrderLine line : lines = this.getLines()) {
                if (this.is_ValueChanged("AD_Org_ID")) {
                    line.setAD_Org_ID(this.getAD_Org_ID());
                }
                if (this.is_ValueChanged("C_BPartner_ID")) {
                    line.setC_BPartner_ID(this.getC_BPartner_ID());
                }
                if (this.is_ValueChanged("C_BPartner_Location_ID")) {
                    line.setC_BPartner_Location_ID(this.getC_BPartner_Location_ID());
                }
                if (this.is_ValueChanged("DateOrdered")) {
                    line.setDateOrdered(this.getDateOrdered());
                }
                if (this.is_ValueChanged("DatePromised")) {
                    line.setDatePromised(this.getDatePromised());
                }
                if (this.is_ValueChanged("M_Warehouse_ID")) {
                    line.setM_Warehouse_ID(this.getM_Warehouse_ID());
                }
                if (this.is_ValueChanged("M_Shipper_ID")) {
                    line.setM_Shipper_ID(this.getM_Shipper_ID());
                }
                if (this.is_ValueChanged("C_Currency_ID")) {
                    line.setC_Currency_ID(this.getC_Currency_ID());
                }
                line.saveEx();
            }
        }
        return true;
    }

    protected boolean beforeDelete() {
        if (this.isProcessed()) {
            return false;
        }
        for (MOrderLine line : this.getLines()) {
            line.deleteEx(true);
        }
        return true;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction(DocSubTypeSO_Prepay);
        return true;
    }

    public boolean isReturnOrder() {
        MDocType documentType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocTypeTarget_ID());
        return this.getC_DocTypeTarget_ID() != 0 && !Util.isEmpty((String)documentType.getDocSubTypeSO()) && documentType.getDocSubTypeSO().equals(DocSubTypeSO_RMA);
    }

    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen((Properties)this.getCtx(), (Timestamp)this.getDateAcct(), (String)this.getDocumentType().getDocBaseType(), (int)this.getAD_Org_ID(), (String)this.get_TrxName())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        if (this.isReturnOrder()) {
            this.setDeliveryRule("F");
            if (this.getC_POS_ID() != 0) {
                this.setInvoiceRule("I");
            } else {
                this.setInvoiceRule("D");
            }
        }
        if (this.getDeliveryRule() != null && this.getDeliveryRule().equals("O")) {
            for (int i = 0; i < lines.length; ++i) {
                MOrderLine line = lines[i];
                MProduct product = line.getProduct();
                if (product == null || !product.isExcludeAutoDelivery()) continue;
                this.m_processMsg = "@M_Product_ID@ " + product.getValue() + " @IsExcludeAutoDelivery@";
                return "IN";
            }
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            MDocType dtOld;
            if (this.getC_DocType_ID() != 0 && DocSubTypeSO_Standard.equals((dtOld = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID())).getDocSubTypeSO()) && !DocSubTypeSO_Standard.equals(this.getDocumentType().getDocSubTypeSO())) {
                for (int i = 0; i < lines.length; ++i) {
                    if (lines[i].getM_Warehouse_ID() == this.getM_Warehouse_ID()) continue;
                    this.log.warning("different Warehouse " + String.valueOf((Object)lines[i]));
                    this.m_processMsg = "@CannotChangeDocType@";
                    return "IN";
                }
            }
            if ("DR".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || this.getC_DocType_ID() == 0) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else if (this.getDocumentType().isOffer()) {
                this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
            } else {
                this.m_processMsg = "@CannotChangeDocType@";
                return "IN";
            }
        }
        if (this.explodeBOM()) {
            lines = this.getLines(true, "M_Product_ID");
        }
        if (!this.reserveStock(lines)) {
            this.m_processMsg = "@Error@ @Qty@ @QtyNotReserved@";
            return "IN";
        }
        this.calculateOrderSizes(Arrays.asList(lines));
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "Error calculating tax";
            return "IN";
        }
        if (!(!this.isSOTrx() || DocSubTypeSO_POS.equals(this.getDocumentType().getDocSubTypeSO()) && "B".equals(this.getPaymentRule()) && !MSysConfig.getBooleanValue((String)"CHECK_CREDIT_ON_CASH_POS_ORDER", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID()) || DocSubTypeSO_Prepay.equals(this.getDocumentType().getDocSubTypeSO()) && !MSysConfig.getBooleanValue((String)"CHECK_CREDIT_ON_PREPAY_ORDER", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID()) || DocSubTypeSO_Proposal.equals(this.getDocumentType().getDocSubTypeSO()) && !MSysConfig.getBooleanValue((String)"CHECK_CREDIT_ON_PROPOSAL", (boolean)true, (int)this.getAD_Client_ID(), (int)this.getAD_Org_ID()))) {
            MBPartner bp = new MBPartner(this.getCtx(), this.getBill_BPartner_ID(), this.get_TrxName());
            if ("S".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
                return "IN";
            }
            if ("H".equals(bp.getSOCreditStatus())) {
                this.m_processMsg = "@BPartnerCreditHold@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
                return "IN";
            }
            BigDecimal grandTotal = MConversionRate.convertBase(this.getCtx(), this.getGrandTotal(), this.getC_Currency_ID(), this.getDateOrdered(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
            if ("H".equals(bp.getSOCreditStatus(grandTotal))) {
                this.m_processMsg = "@BPartnerOverOCreditHold@ - @TotalOpenBalance@=" + String.valueOf(bp.getTotalOpenBalance()) + ", @GrandTotal@=" + String.valueOf(grandTotal) + ", @SO_CreditLimit@=" + String.valueOf(bp.getSO_CreditLimit());
                return "IN";
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        return "IP";
    }

    public MDocType getDocumentType() {
        return MDocType.get((Properties)this.getCtx(), (int)this.getC_DocTypeTarget_ID());
    }

    private boolean explodeBOM() {
        boolean retValue = false;
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_OrderLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_OrderLine WHERE C_Order_ID=? " + where;
        int count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Order_ID());
        while (count != 0) {
            retValue = true;
            this.renumberLines(1000);
            MOrderLine[] lines = this.getLines(where, "Line");
            for (int i = 0; i < lines.length; ++i) {
                MOrderLine line = lines[i];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                this.log.fine(product.getName());
                AtomicInteger lineNumber = new AtomicInteger(line.getLine());
                X_PP_Product_BOM bom = this.getProductBom(product, this.getAD_Org_ID(), this.getDatePromised(), this.get_TrxName());
                if (bom != null) {
                    this.getProductBomLines(bom.getPP_Product_BOM_ID()).forEach(productBomLineId -> {
                        X_PP_Product_BOMLine productBomLine = new X_PP_Product_BOMLine(this.getCtx(), productBomLineId.intValue(), this.get_TrxName());
                        if (TimeUtil.isValid((Timestamp)productBomLine.getValidFrom(), (Timestamp)productBomLine.getValidTo(), (Timestamp)this.getDatePromised())) {
                            MOrderLine newLine = new MOrderLine(this);
                            newLine.setLine(lineNumber.incrementAndGet());
                            newLine.setM_Product_ID(productBomLine.getM_Product_ID());
                            newLine.setC_UOM_ID(productBomLine.getC_UOM_ID());
                            newLine.setQty(line.getQtyOrdered().multiply(productBomLine.getQtyBOM()));
                            if (productBomLine.getDescription() != null) {
                                newLine.setDescription(productBomLine.getDescription());
                            }
                            newLine.setPrice();
                            newLine.save(this.get_TrxName());
                        }
                    });
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPrice(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.setFreightAmt(Env.ZERO);
                Object description = product.getName();
                if (product.getDescription() != null) {
                    description = (String)description + " " + product.getDescription();
                }
                if (line.getDescription() != null) {
                    description = (String)description + " " + line.getDescription();
                }
                line.setDescription((String)description);
                line.save(this.get_TrxName());
            }
            this.m_lines = null;
            count = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)this.getC_Invoice_ID());
            this.renumberLines(10);
        }
        return retValue;
    }

    private List<Integer> getProductBomLines(int productBomId) {
        return new Query(this.getCtx(), "PP_Product_BOMLine", "PP_Product_BOM_ID=?", this.get_TrxName()).setParameters(new Object[]{productBomId}).setClient_ID().setOnlyActiveRecords(true).setOrderBy("Line").getIDsAsList();
    }

    private X_PP_Product_BOM getProductBom(MProduct product, int organizationId, Timestamp promisedDate, String transactionName) {
        X_PP_Product_Planning pp;
        X_PP_Product_BOM bom = null;
        Properties ctx = product.getCtx();
        if (organizationId > 0 && (pp = this.getProductPlanning(ctx, product.getAD_Client_ID(), organizationId, product.getM_Product_ID(), transactionName)) != null && pp.getPP_Product_BOM_ID() > 0) {
            bom = new X_PP_Product_BOM(ctx, pp.getPP_Product_BOM_ID(), transactionName);
        }
        if (bom == null) {
            bom = this.getDefaultProductBom(product, transactionName);
        }
        return bom;
    }

    private X_PP_Product_BOM getDefaultProductBom(MProduct product, String trxName) {
        return (X_PP_Product_BOM)new Query(product.getCtx(), "PP_Product_BOM", "M_Product_ID=? AND Value=?", trxName).setParameters(new Object[]{product.getM_Product_ID(), product.getValue()}).setOnlyActiveRecords(true).setOnlyActiveRecords(true).setClient_ID().first();
    }

    private X_PP_Product_Planning getProductPlanning(Properties ctx, int clientId, int organizationId, int productId, String transactionName) {
        int warehouseId = MOrgInfo.get((Properties)ctx, (int)organizationId, (String)transactionName).getM_Warehouse_ID();
        if (warehouseId <= 0) {
            return null;
        }
        int resourceId = this.getPlantForWarehouse(warehouseId);
        if (resourceId <= 0) {
            return null;
        }
        return this.getProductPlanning(ctx, clientId, organizationId, warehouseId, resourceId, productId, transactionName);
    }

    private int getPlantForWarehouse(int warehouseId) {
        String sql = "SELECT MIN(S_Resource_ID) FROM S_Resource WHERE IsManufacturingResource=? AND ManufacturingResourceType=? AND M_Warehouse_ID=?";
        int plantId = DB.getSQLValueEx(null, (String)"SELECT MIN(S_Resource_ID) FROM S_Resource WHERE IsManufacturingResource=? AND ManufacturingResourceType=? AND M_Warehouse_ID=?", (Object[])new Object[]{true, "PT", warehouseId});
        return plantId;
    }

    private X_PP_Product_Planning getProductPlanning(Properties ctx, int clientId, int organizationId, int warehouseId, int resourceId, int productId, String transactionName) {
        this.log.info("AD_Client_ID=" + clientId + " AD_Org_ID=" + organizationId + " M_Product_ID=" + productId + " M_Warehouse_ID=" + warehouseId + " S_Resource_ID=" + resourceId);
        Object sql_warehouse = "M_Warehouse_ID=?";
        if (warehouseId == 0) {
            sql_warehouse = (String)sql_warehouse + " OR M_Warehouse_ID IS NULL";
        }
        String whereClause = " AD_Client_ID=? AND AD_Org_ID=? AND M_Product_ID=? AND (" + (String)sql_warehouse + ") AND S_Resource_ID=?";
        return (X_PP_Product_Planning)new Query(ctx, "PP_Product_Planning", whereClause, transactionName).setParameters(new Object[]{clientId, organizationId, productId, warehouseId, resourceId}).setOnlyActiveRecords(true).firstOnly();
    }

    public boolean isBinding() {
        boolean binding;
        boolean bl = binding = !this.getDocumentType().isProposal() && !this.isReturnOrder();
        if ("VO".equals(this.getDocAction()) || DocSubTypeSO_Quotation.equals(this.getDocumentType().getDocSubTypeSO()) && "CL".equals(this.getDocAction())) {
            binding = false;
        }
        return binding;
    }

    private void forceSameWarehouseToLine(int headerWarehouseId, MOrderLine orderLine) {
        if (headerWarehouseId != 0) {
            if (headerWarehouseId != orderLine.getM_Warehouse_ID()) {
                orderLine.setM_Warehouse_ID(headerWarehouseId);
                orderLine.saveEx();
            }
            if (this.getAD_Org_ID() != orderLine.getAD_Org_ID()) {
                orderLine.setAD_Org_ID(this.getAD_Org_ID());
                orderLine.saveEx();
            }
        }
    }

    private void calculateOrderSizes(List<MOrderLine> orderLines) {
        this.setVolume(orderLines.stream().filter(orderLine -> orderLine.getM_Product_ID() > 0).map(orderLine -> Optional.ofNullable(orderLine.getProduct().getVolume()).orElse(BigDecimal.ZERO).multiply(orderLine.getQtyOrdered())).reduce(BigDecimal.ZERO, BigDecimal::add));
        this.setWeight(orderLines.stream().filter(orderLine -> orderLine.getM_Product_ID() > 0).map(orderLine -> Optional.ofNullable(orderLine.getProduct().getWeight()).orElse(BigDecimal.ZERO).multiply(orderLine.getQtyOrdered())).reduce(BigDecimal.ZERO, BigDecimal::add));
    }

    private boolean reserveStock(MOrderLine[] lines) {
        List<MOrderLine> orderLines = Arrays.asList(lines);
        boolean binding = this.isBinding();
        boolean isSOTrx = this.isSOTrx();
        int headerWarehouseId = DocSubTypeSO_Standard.equals(this.getDocumentType().getDocSubTypeSO()) || "POO".equals(this.getDocumentType().getDocBaseType()) ? 0 : this.getM_Warehouse_ID();
        this.log.fine("Binding=" + binding + " - IsSOTrx=" + isSOTrx);
        orderLines.forEach(orderLine -> {
            this.forceSameWarehouseToLine(headerWarehouseId, (MOrderLine)((Object)orderLine));
            BigDecimal target = binding ? orderLine.getQtyOrdered() : Env.ZERO;
            BigDecimal difference = target.subtract(orderLine.getQtyReserved()).subtract(orderLine.getQtyDelivered());
            if (difference.signum() != 0) {
                Optional<MProduct> maybeProduct = Optional.ofNullable(orderLine.getProduct());
                maybeProduct.ifPresent(product -> {
                    if (product.isStocked()) {
                        orderLine.reserveStock();
                        orderLine.saveEx();
                        this.log.fine("Line=" + orderLine.getLine() + " - Target=" + String.valueOf(target) + ",Difference=" + String.valueOf(difference) + " - Ordered=" + String.valueOf(orderLine.getQtyOrdered()) + ",Reserved=" + String.valueOf(orderLine.getQtyReserved()) + ",Delivered=" + String.valueOf(orderLine.getQtyDelivered()));
                    }
                });
            }
        });
        return true;
    }

    public boolean calculateTaxTotal() {
        MOrderLine[] orderLines;
        this.log.fine("");
        DB.executeUpdateEx((String)("DELETE C_OrderTax WHERE C_Order_ID=" + this.getC_Order_ID()), (String)this.get_TrxName());
        this.m_taxes = null;
        AtomicReference<BigDecimal> totalLines = new AtomicReference<BigDecimal>(Env.ZERO);
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        for (MOrderLine orderLine : orderLines = this.getLines(true, null)) {
            Optional<MOrderTax> maybeOrderTax;
            if (!taxList.contains(orderLine.getC_Tax_ID()) && (maybeOrderTax = Optional.ofNullable(MOrderTax.get((MOrderLine)orderLine, (int)this.getPrecision(), (boolean)false, (String)this.get_TrxName()))).isPresent()) {
                MOrderTax orderTax2 = maybeOrderTax.get();
                orderTax2.setIsTaxIncluded(this.isTaxIncluded());
                if (!orderTax2.calculateTaxFromLines()) {
                    return false;
                }
                orderTax2.saveEx();
                taxList.add(orderLine.getC_Tax_ID());
            }
            totalLines.getAndUpdate(total -> total.add(orderLine.getLineNetAmt()));
        }
        AtomicReference<BigDecimal> grandTotal = new AtomicReference<BigDecimal>(totalLines.get());
        Arrays.stream(this.getTaxes(true)).forEach(orderTax -> {
            MTax tax = orderTax.getTax();
            if (tax.isSummary()) {
                Arrays.stream(tax.getChildTaxes(false)).forEach(childrenTax -> {
                    BigDecimal taxAmount = childrenTax.calculateTax(orderTax.getTaxBaseAmt(), this.isTaxIncluded(), this.getPrecision());
                    MOrderTax newOrderTax = new MOrderTax(this.getCtx(), 0, this.get_TrxName());
                    newOrderTax.setClientOrg((PO)this);
                    newOrderTax.setC_Order_ID(this.getC_Order_ID());
                    newOrderTax.setC_Tax_ID(childrenTax.getC_Tax_ID());
                    newOrderTax.setPrecision(this.getPrecision());
                    newOrderTax.setIsTaxIncluded(this.isTaxIncluded());
                    newOrderTax.setTaxBaseAmt(orderTax.getTaxBaseAmt());
                    newOrderTax.setTaxAmt(taxAmount);
                    newOrderTax.saveEx();
                    if (!this.isTaxIncluded()) {
                        grandTotal.getAndUpdate(total -> total.add(taxAmount));
                    }
                });
                orderTax.deleteEx(true);
                orderTax.saveEx();
            } else if (!this.isTaxIncluded()) {
                grandTotal.getAndUpdate(total -> total.add(orderTax.getTaxAmt()));
            }
        });
        this.setTotalLines(totalLines.get());
        this.setGrandTotal(grandTotal.get());
        return true;
    }

    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String valid;
        MOrder counter;
        String status;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(this.getDocAction())) {
            this.setProcessed(false);
            return "IP";
        }
        if (DocSubTypeSO_Proposal.equals(DocSubTypeSO) || DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
            if (DocSubTypeSO_Quotation.equals(DocSubTypeSO)) {
                MOrderLine[] orderLines = this.getLines(true, "M_Product_ID");
                this.reserveStock(orderLines);
                this.calculateOrderSizes(Arrays.asList(orderLines));
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
            if (this.m_processMsg != null) {
                return "IN";
            }
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
            if (this.m_processMsg != null) {
                return "IN";
            }
            this.setDefiniteDocumentNo();
            this.setProcessed(true);
            return "CO";
        }
        if (!this.m_forceCreation && DocSubTypeSO_Prepay.equals(DocSubTypeSO) && this.getC_Payment_ID() == 0 && this.getC_CashLine_ID() == 0) {
            this.setProcessed(true);
            return DocSubTypeSO_Warehouse;
        }
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.getLines(true, null);
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        boolean realTimePOS = MSysConfig.getBooleanValue((String)"REAL_TIME_POS", (boolean)false, (int)this.getAD_Client_ID());
        MInOut shipment = null;
        if (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            if (!"F".equals(this.getDeliveryRule())) {
                this.setDeliveryRule("F");
            }
            if ((shipment = this.createShipment(dt, realTimePOS ? null : this.getDateOrdered())) == null) {
                return "IN";
            }
            info.append("@M_InOut_ID@: ").append(shipment.getDocumentNo());
            String msg = shipment.getProcessMsg();
            if (msg != null && msg.length() > 0) {
                info.append(" (").append(msg).append(")");
            }
        }
        if (DocSubTypeSO_POS.equals(DocSubTypeSO) || DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Prepay.equals(DocSubTypeSO) || DocSubTypeSO_InvoiceOrder.equals(DocSubTypeSO)) {
            MInvoice invoice = this.createInvoice(dt, shipment, realTimePOS ? null : this.getDateOrdered());
            if (invoice == null) {
                return "IN";
            }
            if (shipment != null) {
                shipment.setC_Invoice_ID(invoice.getC_Invoice_ID());
                shipment.saveEx();
            }
            info.append(" - @C_Invoice_ID@: ").append(invoice.getDocumentNo());
            String msg = invoice.getProcessMsg();
            if (msg != null && msg.length() > 0) {
                info.append(" (").append(msg).append(")");
            }
        }
        if ((counter = this.createCounterDoc()) != null) {
            info.append(" - @CounterDoc@: @Order@=").append(counter.getDocumentNo());
        }
        if ((valid = ModelValidationEngine.get().fireDocValidate((PO)this, 9)) != null) {
            if (info.length() > 0) {
                info.append(" - ");
            }
            info.append(valid);
            this.m_processMsg = info.toString();
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.m_processMsg = info.toString();
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        String value;
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateOrdered(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (value = DB.getDocumentNo((int)this.getC_DocType_ID(), (String)this.get_TrxName(), (boolean)true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private MInOut createShipment(MDocType dt, Timestamp movementDate) {
        this.log.info("For " + String.valueOf(dt));
        MInOut shipment = new MInOut(this, dt.getC_DocTypeShipment_ID(), movementDate);
        shipment.saveEx(this.get_TrxName());
        MOrderLine[] oLines = this.getLines(true, null);
        for (int i = 0; i < oLines.length; ++i) {
            MOrderLine oLine = oLines[i];
            MInOutLine ioLine = new MInOutLine(shipment);
            BigDecimal MovementQty = oLine.getQtyOrdered().subtract(oLine.getQtyDelivered());
            int M_Locator_ID = MStorage.getM_Locator_ID(oLine.getM_Warehouse_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), MovementQty, this.get_TrxName());
            if (M_Locator_ID == 0) {
                MWarehouse wh = MWarehouse.get((Properties)this.getCtx(), (int)oLine.getM_Warehouse_ID());
                M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
            }
            ioLine.setOrderLine(oLine, M_Locator_ID, MovementQty);
            ioLine.setQty(MovementQty);
            if (oLine.getQtyEntered().compareTo(oLine.getQtyOrdered()) != 0) {
                ioLine.setQtyEntered(MovementQty.multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 6, RoundingMode.HALF_UP));
            }
            ioLine.saveEx(this.get_TrxName());
        }
        shipment.processIt("CO");
        shipment.saveEx(this.get_TrxName());
        if (!"CO".equals(shipment.getDocStatus())) {
            this.m_processMsg = "@M_InOut_ID@: " + shipment.getProcessMsg();
            return null;
        }
        return shipment;
    }

    private MInvoice createInvoice(MDocType dt, MInOut shipment, Timestamp invoiceDate) {
        this.log.info(dt.toString());
        MInvoice invoice = new MInvoice(this, dt.getC_DocTypeInvoice_ID(), invoiceDate);
        invoice.saveEx(this.get_TrxName());
        if (shipment != null) {
            if (!"D".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("D");
            }
            MInOutLine[] sLines = shipment.getLines(false);
            for (int i = 0; i < sLines.length; ++i) {
                MInOutLine sLine = sLines[i];
                MInvoiceLine iLine = new MInvoiceLine(invoice);
                iLine.setShipLine(sLine);
                if (sLine.sameOrderLineUOM()) {
                    iLine.setQtyEntered(sLine.getQtyEntered());
                } else {
                    iLine.setQtyEntered(sLine.getMovementQty());
                }
                iLine.setQtyInvoiced(sLine.getMovementQty());
                iLine.saveEx(this.get_TrxName());
                sLine.setIsInvoiced(true);
                sLine.saveEx(this.get_TrxName());
            }
        } else {
            if (!"I".equals(this.getInvoiceRule())) {
                this.setInvoiceRule("I");
            }
            MOrderLine[] oLines = this.getLines();
            for (int i = 0; i < oLines.length; ++i) {
                MOrderLine oLine = oLines[i];
                MInvoiceLine iLine = new MInvoiceLine(invoice);
                iLine.setOrderLine(oLine);
                iLine.setQtyInvoiced(oLine.getQtyOrdered().subtract(oLine.getQtyInvoiced()));
                if (oLine.getQtyOrdered().compareTo(oLine.getQtyEntered()) == 0) {
                    iLine.setQtyEntered(iLine.getQtyInvoiced());
                } else {
                    iLine.setQtyEntered(iLine.getQtyInvoiced().multiply(oLine.getQtyEntered()).divide(oLine.getQtyOrdered(), 12, RoundingMode.HALF_UP));
                }
                iLine.saveEx(this.get_TrxName());
            }
        }
        invoice.processIt("CO");
        invoice.saveEx(this.get_TrxName());
        this.setC_CashLine_ID(invoice.getC_CashLine_ID());
        if (!"CO".equals(invoice.getDocStatus())) {
            this.m_processMsg = "@C_Invoice_ID@: " + invoice.getProcessMsg();
            return null;
        }
        return invoice;
    }

    private MOrder createCounterDoc() {
        if (this.getRef_Order_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get((Properties)this.getCtx(), (int)this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        MOrgInfo counterOrgInfo = MOrgInfo.get((Properties)this.getCtx(), (int)counterAD_Org_ID, (String)this.get_TrxName());
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID((Properties)this.getCtx(), (int)this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MOrder counter = MOrder.copyFrom(this, this.getDateOrdered(), C_DocTypeTarget_ID, !this.isSOTrx(), true, false, this.get_TrxName());
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setM_Warehouse_ID(counterOrgInfo.getM_Warehouse_ID());
        counter.setBPartner(counterBP);
        counter.setDatePromised(this.getDatePromised());
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.saveEx(this.get_TrxName());
        MOrderLine[] counterLines = counter.getLines(true, null);
        for (int i = 0; i < counterLines.length; ++i) {
            MOrderLine counterLine = counterLines[i];
            counterLine.setOrder(counter);
            counterLine.setPrice();
            counterLine.setTax();
            counterLine.saveEx(this.get_TrxName());
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.saveEx(this.get_TrxName());
        }
        return counter;
    }

    public boolean voidIt() {
        MOrderTax[] taxes;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.isSOTrx()) {
            MDocType documentType = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
            String docSubTypeSO = documentType.getDocSubTypeSO();
            if (DocSubTypeSO_Warehouse.equals(docSubTypeSO)) {
                this.createReversals(true);
            } else {
                StringBuffer receipts = new StringBuffer();
                Arrays.asList(this.getShipments()).forEach(receipt -> {
                    receipts.append(Env.NL);
                    receipts.append(receipt.getDocumentNo());
                });
                if (receipts.length() > 0) {
                    this.m_processMsg = "@SQLErrorReferenced@ @M_InOut_ID@ " + receipts.toString();
                    return false;
                }
            }
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine line = lines[i];
            BigDecimal old = line.getQtyOrdered();
            if (old.signum() != 0) {
                line.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided") + " (" + String.valueOf(old) + ")");
                line.setQty(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.saveEx(this.get_TrxName());
            }
            if (this.isSOTrx()) continue;
            this.deleteMatchPOCostDetail(line);
        }
        for (MOrderTax tax : taxes = this.getTaxes(true)) {
            if (!tax.calculateTaxFromLines()) {
                return false;
            }
            tax.saveEx();
        }
        this.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
        if (!this.reserveStock(lines)) {
            this.m_processMsg = "@Error@ @Undo@ @QtyReserved@ @From@ (@Voided@)";
            return false;
        }
        this.calculateOrderSizes(Arrays.asList(lines));
        MRequisitionLine.unlinkC_Order_ID((Properties)this.getCtx(), (int)this.get_ID(), (String)this.get_TrxName());
        if (!this.createReversals(false)) {
            return false;
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getC_Order_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private boolean createReversals(boolean enforcePO) {
        if (!this.isSOTrx() && !enforcePO) {
            return true;
        }
        this.log.info("createReversals");
        StringBuffer info = new StringBuffer();
        info.append("@M_InOut_ID@:");
        MInOut[] shipments = this.getShipments();
        for (int i = 0; i < shipments.length; ++i) {
            MInOut ship = shipments[i];
            if ("CL".equals(ship.getDocStatus()) || "RE".equals(ship.getDocStatus()) || "VO".equals(ship.getDocStatus())) continue;
            ship.set_TrxName(this.get_TrxName());
            if (!"CO".equals(ship.getDocStatus())) {
                if (ship.voidIt()) {
                    ship.setDocStatus("VO");
                }
            } else if (ship.reverseCorrectIt()) {
                ship.setDocStatus("RE");
                info.append(" ").append(ship.getDocumentNo());
            } else {
                this.m_processMsg = "Could not reverse Shipment " + String.valueOf((Object)ship);
                return false;
            }
            ship.setDocAction("--");
            ship.saveEx(this.get_TrxName());
        }
        info.append(" - @C_Invoice_ID@:");
        MInvoice[] invoices = this.getInvoices();
        for (int i = 0; i < invoices.length; ++i) {
            MInvoice invoice = invoices[i];
            if ("CL".equals(invoice.getDocStatus()) || "RE".equals(invoice.getDocStatus()) || "VO".equals(invoice.getDocStatus())) continue;
            invoice.set_TrxName(this.get_TrxName());
            if (!"CO".equals(invoice.getDocStatus())) {
                if (invoice.voidIt()) {
                    invoice.setDocStatus("VO");
                }
            } else if (invoice.reverseCorrectIt()) {
                invoice.setDocStatus("RE");
                info.append(" ").append(invoice.getDocumentNo());
            } else {
                this.m_processMsg = "@Error@ " + String.valueOf((Object)invoice);
                return false;
            }
            invoice.setDocAction("--");
            invoice.saveEx(this.get_TrxName());
        }
        this.m_processMsg = info.toString();
        return true;
    }

    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine line = lines[i];
            BigDecimal old = line.getQtyOrdered();
            if (old.compareTo(line.getQtyDelivered()) == 0) continue;
            line.setQtyLostSales(line.getQtyOrdered().subtract(line.getQtyDelivered()));
            line.setQtyOrdered(line.getQtyDelivered());
            line.addDescription("Close (" + String.valueOf(old) + ")");
            line.saveEx(this.get_TrxName());
        }
        if (!this.reserveStock(lines)) {
            this.m_processMsg = "@FailedToUpdateReservations@";
            return false;
        }
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "@ErrorCalculatingTax@";
            return false;
        }
        this.calculateOrderSizes(Arrays.asList(lines));
        this.setProcessed(true);
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 11);
        return this.m_processMsg == null;
    }

    public String reopenIt() {
        this.log.info(this.toString());
        if (!"CL".equals(this.getDocStatus())) {
            return "Not closed - can't reopen";
        }
        MOrderLine[] lines = this.getLines(true, "M_Product_ID");
        for (int i = 0; i < lines.length; ++i) {
            MOrderLine line = lines[i];
            if (Env.ZERO.compareTo(line.getQtyLostSales()) == 0) continue;
            line.setQtyOrdered(line.getQtyLostSales().add(line.getQtyDelivered()));
            line.setQtyLostSales(Env.ZERO);
            String desc = line.getDescription();
            if (desc == null) {
                desc = "";
            }
            Pattern pattern = Pattern.compile("( \\| )?Close \\(.*\\)");
            String[] parts = pattern.split(desc);
            desc = "";
            for (String s : parts) {
                desc = desc.concat(s);
            }
            line.setDescription(desc);
            line.saveEx(this.get_TrxName());
        }
        if (!this.reserveStock(lines)) {
            this.m_processMsg = "@FailedToUpdateReservations@";
            return this.m_processMsg;
        }
        if (!this.calculateTaxTotal()) {
            this.m_processMsg = "@ErrorCalculatingTax@";
            return this.m_processMsg;
        }
        this.calculateOrderSizes(Arrays.asList(lines));
        this.setDocStatus("CO");
        this.setDocAction("CL");
        this.saveEx(this.get_TrxName());
        return "";
    }

    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return this.voidIt();
    }

    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        MDocType dt = MDocType.get((Properties)this.getCtx(), (int)this.getC_DocType_ID());
        String DocSubTypeSO = dt.getDocSubTypeSO();
        if (DocSubTypeSO_Prepay.equals(DocSubTypeSO)) {
            MDocType newDT = null;
            MDocType[] dts = MDocType.getOfClient((Properties)this.getCtx());
            for (int i = 0; i < dts.length; ++i) {
                MDocType type = dts[i];
                if (!DocSubTypeSO_Prepay.equals(type.getDocSubTypeSO()) || !type.isDefault() && newDT != null) continue;
                newDT = type;
            }
            if (newDT == null) {
                return false;
            }
            this.setC_DocType_ID(newDT.getC_DocType_ID());
        }
        if (!this.isSOTrx()) {
            this.log.info("Existing documents not modified - " + String.valueOf(dt));
        } else if (DocSubTypeSO_OnCredit.equals(DocSubTypeSO) || DocSubTypeSO_Warehouse.equals(DocSubTypeSO) || DocSubTypeSO_POS.equals(DocSubTypeSO)) {
            if (!this.createReversals(false)) {
                return false;
            }
        } else {
            this.log.info("Existing documents not modified - SubType=" + DocSubTypeSO);
        }
        MFactAcct.deleteEx((int)Table_ID, (int)this.getC_Order_ID(), (String)this.get_TrxName());
        this.setPosted(false);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("CO");
        this.setProcessed(false);
        return true;
    }

    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate((Properties)this.getCtx(), (String)"GrandTotal")).append("=").append(this.getGrandTotal());
        if (this.m_lines != null) {
            sb.append(" (#").append(this.m_lines.length).append(")");
        }
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    private String deleteMatchPOCostDetail(MOrderLine line) {
        MAcctSchema[] acctschemas = MAcctSchema.getClientAcctSchema((Properties)this.getCtx(), (int)this.getAD_Client_ID());
        for (int asn = 0; asn < acctschemas.length; ++asn) {
            MCostDetail cd;
            MMatchPO[] mPO;
            MAcctSchema as = acctschemas[asn];
            if (as.isSkipOrg(this.getAD_Org_ID()) || (mPO = MMatchPO.getOrderLine((Properties)this.getCtx(), (int)line.getC_OrderLine_ID(), (String)this.get_TrxName())).length != 0 || (cd = MCostDetail.get((Properties)this.getCtx(), (String)"C_OrderLine_ID=?", (int)line.getC_OrderLine_ID(), (int)line.getM_AttributeSetInstance_ID(), (int)as.getC_AcctSchema_ID(), (String)this.get_TrxName())) == null) continue;
            cd.setProcessed(false);
            cd.delete(true);
        }
        return "";
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public void updateIsDelivered() throws SQLException {
        String query = "SELECT COUNT(*) FROM C_OrderLine WHERE C_Order_ID=? and QtyOrdered > QtyDelivered ";
        CPreparedStatement ps = DB.prepareStatement((String)query, (String)this.get_TrxName());
        ps.setInt(1, this.get_ID());
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            int delta = rs.getInt(1);
            if (delta == 0) {
                this.setIsDelivered(true);
            } else {
                this.setIsDelivered(false);
            }
        }
        rs.close();
        ps.close();
    }
}

