/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_Conversion_Rate;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.MCurrency;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;

public class MConversionRate
extends X_C_Conversion_Rate {
    private static final long serialVersionUID = -8171829790483133141L;
    private static CLogger s_log = CLogger.getCLogger(MConversionRate.class);
    private static CCache<Integer, MConversionRate> s_cache = new CCache("C_Conversion_Rate", 40, 5);

    public static BigDecimal convertBase(Properties ctx, BigDecimal Amt, int CurFrom_ID, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        return MConversionRate.convert(ctx, Amt, CurFrom_ID, MClient.get((Properties)ctx).getC_Currency_ID(), ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
    }

    public static BigDecimal convert(Properties ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, int AD_Client_ID, int AD_Org_ID) {
        return MConversionRate.convert(ctx, Amt, CurFrom_ID, CurTo_ID, null, 0, AD_Client_ID, AD_Org_ID);
    }

    public static BigDecimal convert(Properties ctx, BigDecimal Amt, int CurFrom_ID, int CurTo_ID, Timestamp ConvDate, int C_ConversionType_ID, int AD_Client_ID, int AD_Org_ID) {
        if (Amt == null) {
            throw new IllegalArgumentException("Required parameter missing - Amt");
        }
        if (CurFrom_ID == CurTo_ID || Amt.compareTo(Env.ZERO) == 0) {
            return Amt;
        }
        BigDecimal retValue = MConversionRate.getRate(CurFrom_ID, CurTo_ID, ConvDate, C_ConversionType_ID, AD_Client_ID, AD_Org_ID);
        if (retValue == null) {
            return null;
        }
        retValue = retValue.multiply(Amt);
        int stdPrecision = MCurrency.getStdPrecision((Properties)ctx, (int)CurTo_ID);
        if (retValue.scale() > stdPrecision) {
            retValue = retValue.setScale(stdPrecision, RoundingMode.HALF_UP);
        }
        return retValue;
    }

    public static void setRate(String CurFrom_ISO, String CurTo_ISO, Date spotDate, BigDecimal MultiplyRate) throws Exception {
        String trxName = Trx.createTrxName();
        Trx trx = Trx.get((String)trxName, (boolean)true);
        Properties ctx = Env.getCtx();
        MCurrency curFrom = MCurrency.get((Properties)ctx, (String)CurFrom_ISO);
        if (curFrom == null) {
            throw new Exception("Invalid currency " + CurFrom_ISO);
        }
        MCurrency curTo = MCurrency.get((Properties)ctx, (String)CurTo_ISO);
        if (curTo == null) {
            throw new Exception("Invalid currency " + CurTo_ISO);
        }
        if (spotDate == null) {
            spotDate = Calendar.getInstance().getTime();
        }
        Calendar spotCal = Calendar.getInstance();
        spotCal.setTime(spotDate);
        spotCal.set(11, 0);
        spotCal.set(12, 0);
        spotCal.set(13, 0);
        spotCal.set(14, 0);
        Timestamp startTs = new Timestamp(spotCal.getTimeInMillis());
        String whereClause = "C_Currency_ID=? and C_Currency_ID_To=? and ValidFrom>=? and ValidTo<=? and C_ConversionType_ID=?";
        MConversionRate updateRate = null;
        List rates = new Query(ctx, "C_Conversion_Rate", "C_Currency_ID=? and C_Currency_ID_To=? and ValidFrom>=? and ValidTo<=? and C_ConversionType_ID=?", trxName).setParameters(new Object[]{curFrom.get_ID(), curTo.get_ID(), startTs, startTs, 114}).list();
        if (rates.size() > 0) {
            for (MConversionRate rate : rates) {
                if (!rate.getValidFrom().equals(rate.getValidTo())) {
                    rate.deleteEx(true, trxName);
                    continue;
                }
                updateRate = rate;
            }
        }
        if (updateRate == null) {
            updateRate = new MConversionRate(ctx, 0, trxName);
            updateRate.setAD_Client_ID(0);
            updateRate.setAD_Org_ID(0);
            updateRate.setC_Currency_ID(curFrom.get_ID());
            updateRate.setC_Currency_ID_To(curTo.get_ID());
            updateRate.setValidFrom(startTs);
            updateRate.setValidTo(startTs);
            updateRate.setC_ConversionType_ID(114);
        }
        updateRate.setMultiplyRate(MultiplyRate);
        updateRate.saveEx(trxName);
        trx.commit(true);
        trx.close();
    }

    public static BigDecimal getRate(int currencyFromId, int currencyToId, Timestamp conversionDate, int conversionTypeId, int clientId, int OrganizationId) {
        BigDecimal inverseRate;
        String sql;
        BigDecimal rate;
        if (currencyFromId == currencyToId) {
            return Env.ONE;
        }
        int C_ConversionType_ID = conversionTypeId;
        if (C_ConversionType_ID == 0) {
            C_ConversionType_ID = MConversionType.getDefault((int)clientId);
        }
        if (conversionDate == null) {
            conversionDate = new Timestamp(System.currentTimeMillis());
        }
        if (((rate = DB.getSQLValueBD(null, (String)(sql = "SELECT MultiplyRate FROM C_Conversion_Rate WHERE C_Currency_ID=?  AND C_Currency_ID_To=?  AND C_ConversionType_ID=?  AND ? >= ValidFrom  AND ? <= ValidTo  AND AD_Client_ID IN (0,?)  AND AD_Org_ID IN (0,?)  AND IsActive='Y' ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC"), (Object[])new Object[]{currencyFromId, currencyToId, C_ConversionType_ID, conversionDate, conversionDate, clientId, OrganizationId})) == null || rate.signum() == 0) && (inverseRate = DB.getSQLValueBD(null, (String)sql, (Object[])new Object[]{currencyToId, currencyFromId, C_ConversionType_ID, conversionDate, conversionDate, clientId, OrganizationId})) != null && inverseRate.signum() != 0) {
            rate = BigDecimal.ONE.divide(inverseRate, 12, RoundingMode.HALF_UP);
            s_log.info("getRate - used inverse rate from " + currencyToId + " to " + currencyFromId);
        }
        if (rate == null) {
            s_log.info("getRate - not found - CurFrom=" + currencyFromId + ", CurTo=" + currencyToId + ", " + String.valueOf(conversionDate) + ", Type=" + conversionTypeId + (String)(conversionTypeId == C_ConversionType_ID ? "" : "->" + C_ConversionType_ID) + ", Client=" + clientId + ", Org=" + OrganizationId);
        }
        return rate;
    }

    public static int getConversionRateId(int currencyFromId, int CurencyToId, Timestamp conversionDate, int conversionTypeId, int clientId, int organizationId) {
        String sql;
        int conversionRateId;
        if (currencyFromId == CurencyToId) {
            return 0;
        }
        int internalConversionTypeId = conversionTypeId;
        if (internalConversionTypeId == 0) {
            internalConversionTypeId = MConversionType.getDefault((int)clientId);
        }
        if (conversionDate == null) {
            conversionDate = new Timestamp(System.currentTimeMillis());
        }
        if ((conversionRateId = DB.getSQLValue(null, (String)(sql = "SELECT C_Conversion_Rate_ID FROM C_Conversion_Rate WHERE C_Currency_ID=? AND C_Currency_ID_To=? AND\tC_ConversionType_ID=? AND\t? >= ValidFrom AND\t? <= ValidTo AND AD_Client_ID IN (0,?) AND AD_Org_ID IN (0,?)  AND IsActive = 'Y' ORDER BY AD_Client_ID DESC, AD_Org_ID DESC, ValidFrom DESC"), (Object[])new Object[]{currencyFromId, CurencyToId, internalConversionTypeId, conversionDate, conversionDate, clientId, organizationId})) == -1) {
            s_log.info("getRate - not found - CurFrom=" + currencyFromId + ", CurTo=" + CurencyToId + ", " + String.valueOf(conversionDate) + ", Type=" + conversionTypeId + (String)(conversionTypeId == internalConversionTypeId ? "" : "->" + internalConversionTypeId) + ", Client=" + clientId + ", Org=" + organizationId);
        }
        return conversionRateId;
    }

    public static BigDecimal getRate(Properties ctx, int C_Conversion_Rate_ID) {
        MConversionRate conversion = MConversionRate.get(ctx, C_Conversion_Rate_ID);
        if (conversion == null) {
            return null;
        }
        return conversion.getMultiplyRate();
    }

    public static MConversionRate get(Properties ctx, int C_Conversion_Rate_ID) {
        if (C_Conversion_Rate_ID <= 0) {
            return null;
        }
        Integer key = C_Conversion_Rate_ID;
        MConversionRate retValue = (MConversionRate)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MConversionRate(ctx, C_Conversion_Rate_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MConversionRate(Properties ctx, int C_Conversion_Rate_ID, String trxName) {
        super(ctx, C_Conversion_Rate_ID, trxName);
        if (C_Conversion_Rate_ID == 0) {
            super.setDivideRate(Env.ZERO);
            super.setMultiplyRate(Env.ZERO);
            this.setValidFrom(new Timestamp(System.currentTimeMillis()));
        }
    }

    public MConversionRate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MConversionRate(PO po, int C_ConversionType_ID, int C_Currency_ID, int C_Currency_ID_To, BigDecimal MultiplyRate, Timestamp ValidFrom) {
        this(po.getCtx(), 0, po.get_TrxName());
        this.setClientOrg(po);
        this.setC_ConversionType_ID(C_ConversionType_ID);
        this.setC_Currency_ID(C_Currency_ID);
        this.setC_Currency_ID_To(C_Currency_ID_To);
        this.setMultiplyRate(MultiplyRate);
        this.setValidFrom(ValidFrom);
    }

    public void setMultiplyRate(BigDecimal MultiplyRate) {
        if (MultiplyRate == null || MultiplyRate.compareTo(Env.ZERO) == 0 || MultiplyRate.compareTo(Env.ONE) == 0) {
            super.setDivideRate(Env.ONE);
            super.setMultiplyRate(Env.ONE);
        } else {
            super.setMultiplyRate(MultiplyRate);
            super.setDivideRate(Env.ONE.divide(MultiplyRate, MathContext.DECIMAL128));
        }
    }

    public void setDivideRate(BigDecimal DivideRate) {
        if (DivideRate == null || DivideRate.compareTo(Env.ZERO) == 0 || DivideRate.compareTo(Env.ONE) == 0) {
            super.setDivideRate(Env.ONE);
            super.setMultiplyRate(Env.ONE);
        } else {
            super.setDivideRate(DivideRate);
            super.setMultiplyRate(Env.ONE.divide(DivideRate, MathContext.DECIMAL128));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MConversionRate[");
        sb.append(this.get_ID()).append(",Currency=").append(this.getC_Currency_ID()).append(",To=").append(this.getC_Currency_ID_To()).append(", Multiply=").append(this.getMultiplyRate()).append(",Divide=").append(this.getDivideRate()).append(", ValidFrom=").append(this.getValidFrom());
        sb.append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        Timestamp to;
        if (this.getC_Currency_ID() == this.getC_Currency_ID_To()) {
            this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"@C_Currency_ID@ = @C_Currency_ID@"));
            return false;
        }
        if (this.getMultiplyRate().compareTo(Env.ZERO) <= 0) {
            this.log.saveError("Error", Msg.parseTranslation((Properties)this.getCtx(), (String)"@MultiplyRate@ <= 0"));
            return false;
        }
        Timestamp from = this.getValidFrom();
        if (this.getValidTo() == null) {
            this.setValidTo(TimeUtil.getDay((int)2056, (int)1, (int)29));
        }
        if ((to = this.getValidTo()).before(from)) {
            SimpleDateFormat df = DisplayType.getDateFormat((int)15);
            this.log.saveError("Error", df.format(to) + " < " + df.format(from));
            return false;
        }
        return true;
    }

    public static String getErrorMessage(Properties ctx, String adMessage, int currencyFromID, int currencyToID, int convertionTypeId, Timestamp date, String trxName) {
        if (convertionTypeId == 0) {
            convertionTypeId = MConversionType.getDefault((int)Env.getAD_Client_ID((Properties)ctx));
        }
        String retValue = Msg.getMsg((Properties)ctx, (String)adMessage, (Object[])new Object[]{MCurrency.get((Properties)ctx, (int)currencyFromID).getISO_Code(), MCurrency.get((Properties)ctx, (int)currencyToID).getISO_Code(), new MConversionType(ctx, convertionTypeId, trxName).getName(), date});
        return retValue;
    }
}

