/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import io.vavr.control.Option;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.adempiere.core.domains.models.X_C_BPartner_Location;
import org.compiere.model.MBPartner;
import org.compiere.model.MCity;
import org.compiere.model.MLocation;
import org.compiere.model.PO;
import org.compiere.model.Query;

public class MBPartnerLocation
extends X_C_BPartner_Location {
    private static final long serialVersionUID = 1062151267747257338L;
    private MLocation m_location = null;
    private String m_uniqueName = null;
    private int m_unique = 0;

    public static MBPartnerLocation[] getForBPartner(Properties ctx, int C_BPartner_ID) {
        return MBPartnerLocation.getForBPartner(ctx, C_BPartner_ID, null);
    }

    public static MBPartnerLocation[] getForBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        return MBPartnerLocation.getForBPartner(ctx, C_BPartner_ID, null, trxName);
    }

    public static MBPartnerLocation[] getForBPartner(Properties ctx, int C_BPartner_ID, String whereClause, String trxName) {
        Object finalwhereClause = "C_BPartner_ID=?";
        if (whereClause != null && !whereClause.isEmpty()) {
            finalwhereClause = (String)finalwhereClause + " AND " + whereClause;
        }
        List list = new Query(ctx, "C_BPartner_Location", (String)finalwhereClause, trxName).setParameters(new Object[]{C_BPartner_ID}).list();
        MBPartnerLocation[] retValue = new MBPartnerLocation[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBPartnerLocation(Properties ctx, int C_BPartner_Location_ID, String trxName) {
        super(ctx, C_BPartner_Location_ID, trxName);
        if (C_BPartner_Location_ID == 0) {
            this.setName(".");
            this.setIsShipTo(true);
            this.setIsRemitTo(true);
            this.setIsPayFrom(true);
            this.setIsBillTo(true);
        }
    }

    public MBPartnerLocation(MBPartner bp) {
        this(bp.getCtx(), 0, bp.get_TrxName());
        this.setClientOrg((PO)bp);
        this.set_ValueNoCheck("C_BPartner_ID", bp.getC_BPartner_ID());
    }

    public MBPartnerLocation(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MLocation getLocation(boolean requery) {
        if (this.m_location == null) {
            this.m_location = MLocation.get((Properties)this.getCtx(), (int)this.getC_Location_ID(), (String)this.get_TrxName());
        }
        return this.m_location;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MBPartner_Location[ID=").append(this.get_ID()).append(",C_Location_ID=").append(this.getC_Location_ID()).append(",Name=").append(this.getName()).append("]");
        return sb.toString();
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        this.setLatitudeAndLongitude();
        if (!success || newRecord) {
            return success;
        }
        return true;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (!newRecord) {
            return true;
        }
        MCity city = MCity.get((Properties)this.p_ctx, (int)this.get_ValueAsInt("C_City_ID"));
        String newName = this.get_ValueAsString("Address1").concat(", ").concat(city.getName());
        this.setName(newName);
        return true;
    }

    public void setLatitudeAndLongitude() {
        if (this.getC_Location_ID() <= 0) {
            return;
        }
        Option maybeMapUrl = Option.of((Object)this.getMapURL());
        maybeMapUrl.filter(mapUrl -> mapUrl != null && mapUrl.contains("?q=")).map(mapUrl -> {
            String locationInfo = mapUrl.substring(mapUrl.indexOf("?q=") + 3);
            StringTokenizer tokenizer = new StringTokenizer(locationInfo, ",");
            String latitude = tokenizer.nextToken();
            String longitude = tokenizer.nextToken();
            Integer longitudeCheck = longitude.indexOf("&");
            if (longitudeCheck <= 0) {
                longitudeCheck = longitude.length();
            }
            MLocation location = new MLocation(this.getCtx(), this.getC_Location_ID(), this.get_TrxName());
            location.setLatitude(new BigDecimal(latitude));
            location.setLongitude(new BigDecimal(longitude.substring(0, longitudeCheck)));
            location.saveEx();
            return location;
        });
    }

    private void makeUnique() {
        String xx;
        this.m_uniqueName = "";
        if ((this.m_unique >= 0 || this.m_uniqueName.length() == 0) && (xx = this.getC_City().getName()) != null && xx.length() > 0) {
            this.m_uniqueName = xx;
        }
        if ((this.m_unique >= 1 || this.m_uniqueName.length() == 0) && (xx = this.getAddress1()) != null && xx.length() > 0) {
            if (this.m_uniqueName.length() > 0) {
                this.m_uniqueName = this.m_uniqueName + " ";
            }
            this.m_uniqueName = this.m_uniqueName + xx;
        }
        if ((this.m_unique >= 3 || this.m_uniqueName.length() == 0) && (xx = this.getC_Region().getName()) != null && xx.length() > 0) {
            if (this.m_uniqueName.length() > 0) {
                this.m_uniqueName = this.m_uniqueName + " ";
            }
            this.m_uniqueName = this.m_uniqueName + xx;
        }
        if (this.m_unique >= 4 || this.m_uniqueName.length() == 0) {
            int id = this.get_ID();
            if (id == 0) {
                id = this.get_ID();
            }
            this.m_uniqueName = this.m_uniqueName + "#" + id;
        }
    }
}

