/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model.validator;

import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.I_M_InOut;
import org.adempiere.core.domains.models.I_M_Product;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.acct.Fact;
import org.compiere.asset.exceptions.AssetProductStockedException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetAddition;
import org.compiere.asset.model.MAssetDisposed;
import org.compiere.asset.model.MAssetGroup;
import org.compiere.asset.model.SetGetModel;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class FixedAsset
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(FixedAsset.class);
    private int clientId = -1;

    public int getAD_Client_ID() {
        return this.clientId;
    }

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.clientId = client.getAD_Client_ID();
        }
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
        engine.addModelChange("M_MatchInv", (ModelValidator)this);
        engine.addModelChange("A_Asset_Group", (ModelValidator)this);
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addDocValidate("M_InOut", (ModelValidator)this);
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    public String modelChange(PO po, int type) throws Exception {
        if (po instanceof MMatchInv && (4 == type || 5 == type && po.is_ValueChanged("Processed"))) {
            MInvoiceLine invoiceLine;
            MMatchInv mi = (MMatchInv)po;
            if (mi.isProcessed() && (invoiceLine = new MInvoiceLine(mi.getCtx(), mi.getC_InvoiceLine_ID(), mi.get_TrxName())).isA_CreateAsset() && !invoiceLine.isA_Processed()) {
                int loopQty = 1;
                if ("Exp".equals(invoiceLine.getA_CapvsExp())) {
                    invoiceLine.set_ValueOfColumn("IsCollectiveAsset", (Object)false);
                }
                if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() > 0) {
                    invoiceLine.set_ValueOfColumn("IsCollectiveAsset", (Object)false);
                }
                if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() <= 0 && !invoiceLine.get_ValueAsBoolean("IsCollectiveAsset")) {
                    loopQty = mi.getQty().intValue();
                }
                for (int i = 0; i < loopQty; ++i) {
                    MAssetAddition.createAsset(mi);
                }
            }
        } else if (po instanceof MInvoiceLine) {
            MInvoiceLine il = (MInvoiceLine)po;
            if (type == 2 || type == 1) {
                this.beforeSave(il, type == 1);
            }
            FixedAsset.modelChange_InvoiceLine(SetGetUtil.wrap(po), type);
        } else if (po.get_TableName().equals("A_Asset_Group")) {
            MAssetGroup assetGroup = (MAssetGroup)po;
            if (type == 1 || type == 2) {
                this.beforeSave(assetGroup, type == 1);
            } else if (type == 4 || type == 5) {
                this.afterSave(assetGroup, type == 4);
            } else if (type == 3) {
                this.beforeDelete(assetGroup);
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        log.info(po.get_TableName() + " Timing: " + timing);
        String result = null;
        String tableName = po.get_TableName();
        if (tableName.equals("C_Invoice")) {
            String string;
            String string2;
            MInvoice invoice;
            if (timing == 9 && (invoice = (MInvoice)po).isSOTrx()) {
                MInvoiceLine[] mInvoiceLineArray;
                MInvoiceLine[] mInvoiceLineArray2 = mInvoiceLineArray = invoice.getLines();
                int n = mInvoiceLineArray2.length;
                for (int i = 0; i < n; ++i) {
                    MInvoiceLine mInvoiceLine = mInvoiceLineArray2[i];
                    if (!mInvoiceLine.isA_CreateAsset() || mInvoiceLine.isA_Processed()) continue;
                    if (mInvoiceLine.getA_Asset_ID() <= 0) {
                        throw new AdempiereException("@A_Asset_ID@ @NotFound@");
                    }
                    MAssetDisposed.createAssetDisposed(mInvoiceLine);
                }
            }
            if (timing == 10 && (string2 = this.afterVoid(invoice = (MInvoice)po)) != null) {
                return string2;
            }
            if (timing == 5 && (string = this.beforeReverseCorrect(invoice = (MInvoice)po)) != null) {
                return string;
            }
        }
        if (tableName.equals("M_InOut")) {
            MInOut inOut;
            if (timing == 9) {
                inOut = (MInOut)po;
                for (MInOutLine inOutLine : inOut.getLines()) {
                    if (inOutLine.getM_Product_ID() <= 0) continue;
                    MProduct mProduct = inOutLine.getProduct();
                    MProductCategory productCategory = MProductCategory.get((Properties)mProduct.getCtx(), (int)mProduct.getM_Product_Category_ID());
                    MAssetGroup assetGroup = MAssetGroup.get(mProduct.getCtx(), productCategory.getA_Asset_Group_ID());
                    if (mProduct == null || !inOut.isSOTrx() || !mProduct.isCreateAsset() || assetGroup.isFixedAsset() || inOutLine.getMovementQty().signum() <= 0 || inOut.isReversal()) continue;
                    log.fine("Asset");
                    int noAssets = inOutLine.getMovementQty().intValue();
                    if (!mProduct.isOneAssetPerUOM()) {
                        noAssets = 1;
                    }
                    for (int i = 0; i < noAssets; ++i) {
                        int deliveryCount = i + 1;
                        if (!mProduct.isOneAssetPerUOM()) {
                            deliveryCount = 0;
                        }
                        MAsset asset = new MAsset(inOut, inOutLine, deliveryCount);
                        asset.saveEx(inOut.get_TrxName());
                    }
                }
            }
            if (timing == 13) {
                inOut = (MInOut)po;
                I_M_InOut i_M_InOut = inOut.getReversal();
                for (MInOutLine mInOutLine : inOut.getLines()) {
                    MAsset asset = MAsset.getFromShipment(inOut.getCtx(), mInOutLine.getM_InOutLine_ID(), inOut.get_TrxName());
                    if (asset == null) continue;
                    asset.setIsActive(false);
                    asset.setDescription(asset.getDescription() + " (" + i_M_InOut.getDocumentNo() + " #" + mInOutLine.getLine() + "<-)");
                    asset.saveEx();
                }
            }
        }
        return result;
    }

    public static void modelChange_InvoiceLine(SetGetModel model, int changeType) {
        if (-1 == changeType || 1 == changeType || 2 == changeType) {
            boolean isAsset = false;
            int assetGroupId = 0;
            isAsset = SetGetUtil.get_AttrValueAsBoolean(model, "A_CreateAsset");
            int productId = SetGetUtil.get_AttrValueAsInt(model, "M_Product_ID");
            if (productId > 0) {
                MProduct product = MProduct.get(model.getCtx(), productId, model.get_TrxName());
                if (product.isCreateAsset()) {
                    isAsset = product != null && product.get_ID() > 0 && product.isCreateAsset();
                    assetGroupId = product.getA_Asset_Group_ID();
                } else {
                    assetGroupId = SetGetUtil.get_AttrValueAsInt(model, "A_Asset_Group_ID");
                }
            }
            model.set_AttrValue("A_CreateAsset", isAsset);
            if (isAsset) {
                model.set_AttrValue("A_Asset_Group_ID", assetGroupId);
                model.set_AttrValue("IsFixedAssetInvoice", isAsset);
                model.set_AttrValue("A_CreateAsset", "Y");
            } else {
                model.set_AttrValue("A_Asset_Group_ID", null);
                model.set_AttrValue("A_Asset_ID", null);
                model.set_AttrValue("IsFixedAssetInvoice", false);
            }
            if (isAsset && model instanceof MInvoiceLine) {
                MInvoiceLine invoiceLine = (MInvoiceLine)model;
                if ("Exp".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() <= 0) {
                    throw new FillMandatoryException(new String[]{"A_Asset_ID"});
                }
                if (invoiceLine.getLineNetAmt().signum() == 0) {
                    throw new FillMandatoryException(new String[]{"QtyEntered", "PriceEntered"});
                }
                MProduct product = invoiceLine.getProduct();
                if (product.isStocked() && invoiceLine.get_ValueAsBoolean("IsFixedAssetInvoice")) {
                    throw new AssetProductStockedException(product);
                }
            }
        }
        if (4 == changeType || 5 == changeType || 6 == changeType) {
            int invoiceId = SetGetUtil.get_AttrValueAsInt(model, "C_Invoice_ID");
            String sql = "UPDATE C_Invoice i SET IsFixedAssetInvoice=(SELECT COALESCE(MAX(il.IsFixedAssetInvoice),'N') FROM C_InvoiceLine il WHERE il.C_Invoice_ID=i.C_Invoice_ID AND il.IsDescription='N') WHERE C_Invoice_ID=?";
            DB.executeUpdateEx((String)sql, (Object[])new Object[]{invoiceId}, (String)model.get_TrxName());
        }
    }

    private String beforeSave(MAssetGroup assetGroup, boolean newRecord) throws Exception {
        int no;
        if (assetGroup.is_ValueChanged("IsDefault") && (no = DB.getSQLValue((String)assetGroup.get_TrxName(), (String)"SELECT count(*) FROM A_Asset_Group WHERE IsActive='Y' AND IsDefault='Y' AND Ad_Client_ID=? AND Ad_Org_ID=?", (int)assetGroup.getAD_Client_ID(), (int)assetGroup.getAD_Org_ID())) == 1 && !assetGroup.isDefault() && !newRecord) {
            throw new IllegalStateException("One active Default is expected");
        }
        return null;
    }

    private String afterSave(MAssetGroup assetGroup, boolean newRecord) throws Exception {
        if (assetGroup.isDefault()) {
            DB.executeUpdateEx((String)"UPDATE A_Asset_Group SET IsDefault='N' WHERE IsActive='Y' AND Ad_Client_ID=? AND Ad_Org_ID=? AND A_Asset_Group_ID !=?", (Object[])new Object[]{assetGroup.getAD_Client_ID(), assetGroup.getAD_Org_ID(), assetGroup.getA_Asset_Group_ID()}, (String)assetGroup.get_TrxName());
        }
        return null;
    }

    private String beforeDelete(MAssetGroup assetGroup) throws Exception {
        int no = DB.getSQLValue((String)assetGroup.get_TrxName(), (String)"SELECT count(*) FROM A_Asset_Group WHERE IsActive='Y' AND IsDefault='Y' AND Ad_Client_ID=? AND Ad_Org_ID=? AND A_Asset_Group_ID=? ", (Object[])new Object[]{assetGroup.getAD_Client_ID(), assetGroup.getAD_Org_ID(), assetGroup.getA_Asset_Group_ID()});
        if (no == 1) {
            throw new IllegalStateException("One active Default is expected");
        }
        return null;
    }

    private boolean beforeSave(MInvoiceLine invoiceLine, boolean newRecord) {
        if (invoiceLine.isA_CreateAsset()) {
            MAsset asset;
            I_M_Product product = invoiceLine.getM_Product();
            if ("Cap".equals(invoiceLine.getA_CapvsExp()) && product.getM_Product_Category().getA_Asset_Group_ID() == 0) {
                throw new AdempiereException("@A_Asset_Group_ID@ @NotFound@ @To@ @M_Product_ID@ : " + product.getName());
            }
            if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() > 0) {
                asset = MAsset.get(invoiceLine.getCtx(), invoiceLine.getA_Asset_ID(), null);
                if (invoiceLine.getA_Asset_Group_ID() != asset.getA_Asset_Group_ID()) {
                    throw new AdempiereException(Msg.translate((Properties)invoiceLine.getCtx(), (String)"Asset Group on Invoice Line is different from Asset Group on Asset"));
                }
                if (invoiceLine.getM_Product_ID() != asset.getM_Product_ID()) {
                    throw new AdempiereException(Msg.translate((Properties)invoiceLine.getCtx(), (String)"Product on Invoice Line is different from Asset Product"));
                }
            }
            if ("Exp".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() > 0) {
                asset = MAsset.get(invoiceLine.getCtx(), invoiceLine.getA_Asset_ID(), null);
                invoiceLine.setA_Asset_ID(asset.getA_Asset_ID());
                invoiceLine.setA_Asset_Group_ID(asset.getA_Asset_Group_ID());
                invoiceLine.setA_CapvsExp("Exp");
            }
        }
        return true;
    }

    private String beforeReverseCorrect(MInvoice invoice) {
        if (invoice.get_ValueAsBoolean("IsFixedAssetInvoice")) {
            String sql = "SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ";
            int A_Asset_Addition_ID = DB.getSQLValueEx((String)invoice.get_TrxName(), (String)"SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ", (Object[])new Object[]{invoice.get_ID()});
            MAssetAddition assetAdd = new MAssetAddition(invoice.getCtx(), A_Asset_Addition_ID, invoice.get_TrxName());
            if (assetAdd.getDocStatus().equals("CO") || assetAdd.getDocStatus().equals("CL")) {
                return "Can't Void or Reverse Invoice with Completed Asset Addition";
            }
        }
        return null;
    }

    private String afterVoid(MInvoice invoice) {
        if (invoice.get_ValueAsBoolean("IsFixedAssetInvoice")) {
            String sql = "SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ";
            int A_Asset_Addition_ID = DB.getSQLValueEx((String)invoice.get_TrxName(), (String)"SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ", (Object[])new Object[]{invoice.get_ID()});
            MAssetAddition assetAdd = new MAssetAddition(invoice.getCtx(), A_Asset_Addition_ID, invoice.get_TrxName());
            if ("DR".equals(assetAdd.getDocStatus()) || "IP".equals(assetAdd.getDocStatus()) || "IN".equals(assetAdd.getDocStatus()) || "AP".equals(assetAdd.getDocStatus()) || "NA".equals(assetAdd.getDocStatus())) {
                if (!assetAdd.processIt("VO")) {
                    log.warning("Asset Addition Process Failed: " + String.valueOf((Object)assetAdd) + " - " + assetAdd.getProcessMsg());
                    throw new IllegalStateException("Asset Addition Process Failed: " + String.valueOf((Object)assetAdd) + " - " + assetAdd.getProcessMsg());
                }
                assetAdd.saveEx();
            }
        }
        return null;
    }

    public String factsValidate(MAcctSchema schema, List<Fact> facts, PO po) {
        return null;
    }
}

