/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_A_Asset_Addition;
import org.adempiere.exceptions.FillMandatoryException;
import org.adempiere.util.POCacheLocal;
import org.compiere.asset.exceptions.AssetAlreadyDepreciatedException;
import org.compiere.asset.exceptions.AssetCheckDocumentException;
import org.compiere.asset.exceptions.AssetException;
import org.compiere.asset.exceptions.AssetNotImplementedException;
import org.compiere.asset.exceptions.AssetNotSupportedException;
import org.compiere.asset.feature.UseLifeImpl;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetChange;
import org.compiere.asset.model.MAssetGroupAcct;
import org.compiere.asset.model.MAssetProduct;
import org.compiere.asset.model.MConversionRateUtil;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.asset.model.MIFixedAsset;
import org.compiere.asset.model.SetGetModel;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MConversionType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.project.process.ProjectClose;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class MAssetAddition
extends X_A_Asset_Addition
implements DocAction {
    private static final long serialVersionUID = 5977180589101094202L;
    private static CLogger s_log = CLogger.getCLogger(MAssetAddition.class);
    private final POCacheLocal<MProject> m_cacheCProject = POCacheLocal.newInstance((PO)this, MProject.class);
    private final POCacheLocal<MMatchInv> m_cacheMatchInv = POCacheLocal.newInstance((PO)this, MMatchInv.class);
    private final POCacheLocal<MIFixedAsset> m_cacheIFixedAsset = POCacheLocal.newInstance((PO)this, MIFixedAsset.class);
    private String m_processMsg = null;
    private boolean m_justPrepared = false;
    private final POCacheLocal<MAsset> m_cacheAsset = POCacheLocal.newInstance((PO)this, MAsset.class);

    public MAssetAddition(Properties ctx, int A_Asset_Addition_ID, String trxName) {
        super(ctx, A_Asset_Addition_ID, trxName);
        if (A_Asset_Addition_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setProcessed(false);
        }
    }

    public MAssetAddition(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        this.setA_CreateAsset();
        MAsset asset = MAsset.get(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
        MAssetGroupAcct assetGrpAcct = MAssetGroupAcct.forA_Asset_Group_ID(this.getCtx(), asset.getA_Asset_Group_ID(), "A", this.get_TrxName());
        if (this.isA_CreateAsset()) {
            this.setDeltaUseLifeYears(assetGrpAcct.getUseLifeYears());
            this.setDeltaUseLifeYears_F(assetGrpAcct.getUseLifeYears_F());
        }
        if ("INV".equals(this.getA_SourceType())) {
            MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), this.getC_InvoiceLine_ID(), this.get_TrxName());
            if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() == 0) {
                if (!invoiceLine.isCollectiveAsset()) {
                    this.setA_QTY_Current(Env.ONE);
                } else {
                    this.setA_QTY_Current(invoiceLine.getQtyEntered());
                }
            }
            if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() > 0) {
                this.setA_QTY_Current(Env.ZERO);
                this.setA_CreateAsset(false);
            }
            this.setA_CapvsExp(invoiceLine.getA_CapvsExp());
        }
        if (this.isA_CreateAsset() && this.getA_QTY_Current().signum() == 0 && !"INV".equals(this.getA_SourceType())) {
            this.setA_QTY_Current(Env.ONE);
        }
        if (this.getC_Currency_ID() <= 0) {
            this.setC_Currency_ID(MClient.get((Properties)this.getCtx()).getAcctSchema().getC_Currency_ID());
        }
        if (this.getC_ConversionType_ID() <= 0) {
            this.setC_ConversionType_ID(MConversionType.getDefault((int)this.getAD_Client_ID()));
        }
        this.getDateAcct();
        this.setAssetValueAmt();
        if (this.isA_CreateAsset()) {
            this.setA_CapvsExp("Cap");
        }
        this.setIsApproved();
        return true;
    }

    public static MAssetAddition createAsset(MMatchInv matchInvoice) {
        MInvoiceLine invoiceLine = (MInvoiceLine)matchInvoice.getC_InvoiceLine();
        MAssetAddition assetAddition = new MAssetAddition(matchInvoice);
        assetAddition.dump();
        if (invoiceLine.getA_Asset_ID() == 0 && invoiceLine.isA_CreateAsset()) {
            MAsset asset = assetAddition.createAsset();
            asset.dump();
            MAssetGroupAcct assetGroupAcct = MAssetGroupAcct.forA_Asset_Group_ID(asset.getCtx(), asset.getA_Asset_Group_ID(), assetAddition.getPostingType(), asset.get_TrxName());
            assetAddition.setDeltaUseLifeYears(assetGroupAcct.getUseLifeYears());
            assetAddition.setDeltaUseLifeYears_F(assetGroupAcct.getUseLifeYears_F());
        } else {
            assetAddition.setA_Asset_ID(matchInvoice.getC_InvoiceLine().getA_Asset_ID());
        }
        assetAddition.saveEx();
        return assetAddition;
    }

    public static MAssetAddition createAsset(MIFixedAsset importFixedAsset) {
        MAssetAddition assetAddition = new MAssetAddition(importFixedAsset);
        assetAddition.dump();
        if ("Cap".equals(assetAddition.getA_CapvsExp()) && importFixedAsset.getA_Asset_ID() == 0) {
            MAsset asset = assetAddition.createAsset();
            asset.dump();
        }
        assetAddition.saveEx();
        return assetAddition;
    }

    public static MAssetAddition createAsset(MProject project, MProduct product) {
        MAssetAddition assetAddition = new MAssetAddition(project);
        assetAddition.dump();
        MAsset asset = assetAddition.createAsset();
        if (product != null) {
            asset.setM_Product_ID(product.getM_Product_ID());
            asset.setA_Asset_Group_ID(product.getA_Asset_Group_ID());
            MAttributeSetInstance asi = MAttributeSetInstance.create(Env.getCtx(), product, null);
            asset.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
        asset.setName(product.getName().concat(project.getName()));
        asset.setValue(product.getName().concat(project.getName()));
        asset.saveEx();
        asset.dump();
        MAssetGroupAcct assetgrpacct = MAssetGroupAcct.forA_Asset_Group_ID(asset.getCtx(), asset.getA_Asset_Group_ID(), assetAddition.getPostingType(), null);
        assetAddition.setDeltaUseLifeYears(assetgrpacct.getUseLifeYears());
        assetAddition.setDeltaUseLifeYears_F(assetgrpacct.getUseLifeYears_F());
        assetAddition.setA_Asset(asset);
        assetAddition.saveEx();
        return assetAddition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MAsset createAsset() {
        MAsset asset = null;
        if (this.getA_Asset_ID() > 0) return this.getA_Asset(false);
        String sourceType = this.getA_SourceType();
        if ("INV".equals(sourceType)) {
            asset = new MAsset(this.getMatchInv(false));
            asset.saveEx();
            asset.setName(asset.getName() + "-" + asset.getInventoryNo());
            asset.saveEx();
            this.setA_Asset(asset);
            return asset;
        } else if ("IMP".equals(sourceType)) {
            asset = new MAsset(this.getI_FixedAsset(false));
            asset.saveEx();
            this.setA_Asset(asset);
            return asset;
        } else {
            if (!"PRJ".equals(sourceType)) throw new AssetNotSupportedException("A_SourceType", sourceType);
            return new MAsset(this.getC_Project(false));
        }
    }

    private MAssetAddition(MMatchInv match) {
        this(match.getCtx(), 0, match.get_TrxName());
        this.setM_MatchInv(match);
        this.setC_DocType_ID();
    }

    private MAssetAddition(MProject project) {
        this(project.getCtx(), 0, project.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: Project=" + String.valueOf(project));
        }
        this.setAD_Org_ID(project.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("PRJ");
        this.setC_Currency_ID(project.getC_Currency_ID());
        if (project.get_ValueAsInt("C_ConversionType_ID") > 0) {
            this.setC_ConversionType_ID(project.get_ValueAsInt("C_ConversionType_ID"));
        }
        this.setSourceAmt(project.getProjectBalanceAmt());
        this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        this.setA_CreateAsset(true);
        this.setDeltaUseLifeYears(I_ZERO);
        this.setDeltaUseLifeYears_F(I_ZERO);
        this.setC_DocType_ID();
        Timestamp dateAcct = new Timestamp(System.currentTimeMillis());
        if (dateAcct != null) {
            dateAcct = UseLifeImpl.getDateAcct(dateAcct, 1);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DateAcct=" + String.valueOf(dateAcct));
            }
            this.setDateAcct(dateAcct);
        }
        this.setC_Project(project);
    }

    public MProject getC_Project(boolean requery) {
        return (MProject)this.m_cacheCProject.get(requery);
    }

    private void setC_Project(MProject project) {
        this.set_Value("C_Project_ID", project.get_ID());
        this.m_cacheCProject.set((PO)project);
    }

    private MAssetAddition(MIFixedAsset ifa) {
        this(ifa.getCtx(), 0, ifa.get_TrxName());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Entering: ifa=" + String.valueOf((Object)ifa));
        }
        this.setAD_Org_ID(ifa.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("IMP");
        this.setM_Product_ID(ifa.getM_Product_ID());
        this.setSourceAmt(ifa.getA_Asset_Cost());
        this.setDateDoc(ifa.getAssetServiceDate());
        this.setM_Locator_ID(ifa.getM_Locator_ID());
        boolean isAccmDeprAdjust = ifa.getA_Accumulated_Depr().compareTo(Env.ZERO) > 0;
        this.setA_Accumulated_Depr_Adjust(isAccmDeprAdjust);
        if (ifa.getA_Current_Period() == 0) {
            this.setA_Period_Start(ifa.getUseLifeMonths() + 1);
            ifa.setA_Accumulated_Depr_F(ifa.getA_Accumulated_Depr());
            ifa.setUseLifeMonths_F(ifa.getUseLifeMonths());
        } else {
            this.setA_Period_Start(ifa.getA_Current_Period());
        }
        this.setA_Accumulated_Depr(ifa.getA_Accumulated_Depr());
        this.setA_Accumulated_Depr_F(ifa.getA_Accumulated_Depr_F());
        this.setDeltaUseLifeYears(ifa.getUseLifeMonths() / 12);
        this.setDeltaUseLifeYears_F(ifa.getUseLifeMonths_F() / 12);
        this.setA_CapvsExp("Cap");
        this.setA_CreateAsset(true);
        this.setA_Salvage_Value(ifa.getA_Salvage_Value());
        this.setC_DocType_ID();
        Timestamp dateAcct = ifa.getDateAcct();
        if (dateAcct != null) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DateAcct=" + String.valueOf(dateAcct));
            }
            this.setDateAcct(dateAcct);
        }
        this.setI_FixedAsset(ifa);
    }

    private MMatchInv getMatchInv(boolean requery) {
        return (MMatchInv)this.m_cacheMatchInv.get(requery);
    }

    private void setM_MatchInv(MMatchInv matchInvoice) {
        MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), matchInvoice.getC_InvoiceLine_ID(), this.get_TrxName());
        matchInvoice.load(this.get_TrxName());
        this.setAD_Org_ID(matchInvoice.getAD_Org_ID());
        this.setPostingType("A");
        this.setA_SourceType("INV");
        this.setM_MatchInv_ID(matchInvoice.get_ID());
        this.setA_CreateAsset(invoiceLine.isA_CreateAsset());
        if ("Cap".equals(invoiceLine.getA_CapvsExp())) {
            if (matchInvoice.getC_InvoiceLine().getA_Asset_ID() == 0) {
                this.setA_CreateAsset(true);
            }
            if (matchInvoice.getC_InvoiceLine().getA_Asset_ID() > 0) {
                this.setA_CreateAsset(false);
            }
        }
        this.setC_Invoice_ID(invoiceLine.getC_Invoice_ID());
        this.setC_InvoiceLine_ID(invoiceLine.getC_InvoiceLine_ID());
        this.setM_InOutLine_ID(matchInvoice.getM_InOutLine_ID());
        this.setM_Product_ID(matchInvoice.getM_Product_ID());
        this.setM_AttributeSetInstance_ID(matchInvoice.getM_AttributeSetInstance_ID());
        this.setLine(invoiceLine.getLine());
        this.setM_Locator_ID(matchInvoice.getM_InOutLine().getM_Locator_ID());
        this.setA_CapvsExp(invoiceLine.getA_CapvsExp());
        this.setC_Currency_ID(invoiceLine.getC_Invoice().getC_Currency_ID());
        if (invoiceLine.getC_Invoice().getC_ConversionType_ID() > 0) {
            this.setC_ConversionType_ID(invoiceLine.getC_Invoice().getC_ConversionType_ID());
        }
        this.setDateDoc(matchInvoice.getM_InOutLine().getM_InOut().getMovementDate());
        this.setDateAcct(matchInvoice.getM_InOutLine().getM_InOut().getMovementDate());
        if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.isCollectiveAsset()) {
            this.setA_QTY_Current(matchInvoice.getQty());
            this.setAssetAmtEntered(invoiceLine.getLineNetAmt());
            this.setAssetSourceAmt(invoiceLine.getLineNetAmt());
        }
        if ("Cap".equals(invoiceLine.getA_CapvsExp()) && !invoiceLine.isCollectiveAsset() && invoiceLine.getA_Asset_ID() <= 0) {
            this.setA_QTY_Current(Env.ONE);
            this.setAssetAmtEntered(invoiceLine.getLineNetAmt().divide(matchInvoice.getQty()));
            this.setAssetSourceAmt(matchInvoice.getC_InvoiceLine().getLineNetAmt().divide(matchInvoice.getQty()));
        }
        if ("Cap".equals(invoiceLine.getA_CapvsExp()) && invoiceLine.getA_Asset_ID() > 0 || "Exp".equals(invoiceLine.getA_CapvsExp())) {
            this.setA_QTY_Current(Env.ZERO);
            this.setAssetAmtEntered(invoiceLine.getLineNetAmt());
            this.setAssetSourceAmt(invoiceLine.getLineNetAmt());
        }
        this.m_cacheMatchInv.set((PO)matchInvoice);
    }

    public static boolean setM_MatchInv(SetGetModel model, int matchInvoiceId) {
        boolean newRecord = false;
        String trxName = null;
        if (model instanceof PO) {
            PO po = (PO)model;
            newRecord = po.is_new();
            trxName = po.get_TrxName();
        }
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Entering: model=" + String.valueOf(model) + ", M_MatchInv_ID=" + matchInvoiceId + ", newRecord=" + newRecord + ", trxName=" + trxName);
        }
        String qMatchInv_select = "SELECT  C_Invoice_ID, C_InvoiceLine_ID, M_InOutLine_ID, M_Product_ID, M_AttributeSetInstance_ID, Qty AS A_QTY_Current, InvoiceLine AS Line, M_Locator_ID, A_CapVsExp, MatchNetAmt AS AssetAmtEntered, MatchNetAmt AS AssetSourceAmt, C_Currency_ID, C_ConversionType_ID, MovementDate AS DateDoc";
        String qMatchInv_from = " FROM mb_matchinv WHERE M_MatchInv_ID=";
        Object query = "SELECT  C_Invoice_ID, C_InvoiceLine_ID, M_InOutLine_ID, M_Product_ID, M_AttributeSetInstance_ID, Qty AS A_QTY_Current, InvoiceLine AS Line, M_Locator_ID, A_CapVsExp, MatchNetAmt AS AssetAmtEntered, MatchNetAmt AS AssetSourceAmt, C_Currency_ID, C_ConversionType_ID, MovementDate AS DateDoc";
        if (newRecord) {
            query = (String)query + ", A_Asset_ID, A_CreateAsset";
        }
        query = (String)query + " FROM mb_matchinv WHERE M_MatchInv_ID=" + matchInvoiceId;
        SetGetUtil.updateColumns(model, null, (String)query, trxName);
        s_log.fine("Leaving: RETURN TRUE");
        return true;
    }

    public MIFixedAsset getI_FixedAsset(boolean requery) {
        return (MIFixedAsset)this.m_cacheIFixedAsset.get(requery);
    }

    private void setI_FixedAsset(MIFixedAsset ifa) {
        this.setI_FixedAsset_ID(ifa.get_ID());
        this.m_cacheIFixedAsset.set((PO)ifa);
    }

    private void setAssetValueAmt() {
        this.getDateAcct();
        MConversionRateUtil.convertBase(SetGetUtil.wrap((Object)this), "DateAcct", "AssetSourceAmt", "AssetValueAmt", null);
    }

    public void setSourceAmt(BigDecimal amt) {
        this.setAssetAmtEntered(amt);
        this.setAssetSourceAmt(amt);
    }

    public void setIsApproved() {
        if (!this.isProcessed()) {
            String str = Env.getContext((Properties)this.getCtx(), (String)"#IsCanApproveOwnDoc");
            boolean isApproved = "Y".equals(str);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("#IsCanApproveOwnDoc=" + str + "=" + isApproved);
            }
            this.setIsApproved(isApproved);
        }
    }

    public Timestamp getDateAcct() {
        Timestamp dateAcct = super.getDateAcct();
        if (dateAcct == null) {
            dateAcct = this.getDateDoc();
            this.setDateAcct(dateAcct);
        }
        return dateAcct;
    }

    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine((DocAction)this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    public boolean unlockIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("unlockIt - " + this.toString());
        }
        return true;
    }

    public boolean invalidateIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("invalidateIt - " + this.toString());
        }
        return false;
    }

    public String prepareIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.setA_CreateAsset();
        MAsset asset = this.getA_Asset(true);
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if ("DI".equals(asset.getA_Asset_Status())) {
            this.m_processMsg = "Asset aldready disposed";
            return "IN";
        }
        if (!"NW".equals(asset.getA_Asset_Status()) && assetwk != null && assetwk.getDateAcct() != null && assetwk.isDepreciated(this.getDateAcct())) {
            this.m_processMsg = "Asset already depreciated for this period";
            return "IN";
        }
        if (this.getDateDoc().before(asset.getA_Asset_CreateDate())) {
            throw new AssetCheckDocumentException("Document is date older than Asset Create Date");
        }
        if (asset.getAssetServiceDate() != null && this.getDateDoc().before(asset.getAssetServiceDate())) {
            throw new AssetCheckDocumentException("Document is date older than Asset Service Date");
        }
        if (this.isA_CreateAsset() && this.hasZeroValues() && asset.isDepreciated()) {
            throw new AssetException("New document must have non-zero values");
        }
        if (!this.isA_CreateAsset() && this.getDeltaUseLifeYears() < 0) {
            throw new AssetException("Delta Use Life Years cannot be negative values");
        }
        if ("DP".equals(asset.getA_Asset_Status())) {
            throw new AssetException("Asset is fully depreciated");
        }
        if (this.isA_CreateAsset() && !"NW".equals(asset.getA_Asset_Status())) {
            throw new AssetException("Only new assets can be activated");
        }
        if ("INV".equals(this.getA_SourceType())) {
            int C_Invoice_ID = this.getC_Invoice_ID();
            MInvoice invoice = new MInvoice(this.getCtx(), C_Invoice_ID, this.get_TrxName());
            if ("VO".equals(invoice.getDocStatus())) {
                throw new AssetException("You cannot add asset from voided document(s)");
            }
        }
        if ("PRJ".equals(this.getA_SourceType())) {
            if (this.getC_Project_ID() <= 0) {
                throw new FillMandatoryException(new String[]{"C_Project_ID"});
            }
            String whereClause = "C_Project_ID=? AND DocStatus IN ('IP','CO','CL') AND A_Asset_Addition_ID<>?";
            List list = new Query(this.getCtx(), "A_Asset_Addition", "C_Project_ID=? AND DocStatus IN ('IP','CO','CL') AND A_Asset_Addition_ID<>?", this.get_TrxName()).setParameters(new Object[]{this.getC_Project_ID(), this.get_ID()}).list();
            if (list.size() > 0) {
                StringBuilder sb = new StringBuilder("You can not create project for this asset, Project already has assets. View: ");
                for (MAssetAddition aa : list) {
                    sb.append(aa.getDocumentInfo()).append("; ");
                }
                throw new AssetException(sb.toString());
            }
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean approveIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("approveIt - " + this.toString());
        }
        this.setIsApproved(true);
        return true;
    }

    public boolean rejectIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("rejectIt - " + this.toString());
        }
        this.setIsApproved(false);
        return true;
    }

    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.toString());
        }
        this.checkCreateASI();
        MAsset asset = this.getA_Asset(!this.m_justPrepared);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("asset=" + String.valueOf((Object)asset));
        }
        if (asset == null) {
            this.m_processMsg = "Asset not created/selected";
            return "IN";
        }
        asset.setM_AttributeSetInstance_ID(this.getM_AttributeSetInstance_ID());
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (assetwk == null) {
            assetwk = new MDepreciationWorkfile(asset, this.getPostingType(), null);
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("workfile: " + String.valueOf(assetwk));
        }
        if (this.getA_CapvsExp().equals("Cap")) {
            MDepreciationExp.checkExistsNotProcessedEntries(assetwk.getCtx(), assetwk.getA_Asset_ID(), this.getDateAcct(), assetwk.getPostingType(), assetwk.get_TrxName());
            if (this.getA_Salvage_Value().signum() > 0) {
                assetwk.setA_Salvage_Value(this.getA_Salvage_Value());
            }
            assetwk.adjustCost(this.getAssetValueAmt(), this.getA_QTY_Current(), this.isA_CreateAsset());
            assetwk.setA_Asset_Life_Current_Year(BigDecimal.ZERO);
            assetwk.adjustUseLife(this.getDeltaUseLifeYears(), this.getDeltaUseLifeYears_F(), this.isA_CreateAsset());
            assetwk.setDateAcct(this.getDateAcct());
            assetwk.setProcessed(true);
            assetwk.saveEx();
        }
        MAssetChange.createAddition(this, assetwk);
        if (this.isA_CreateAsset() && this.getM_Locator_ID() > 0) {
            asset.setM_Locator_ID(this.getM_Locator_ID());
        }
        this.updateA_Asset_Product(false);
        if (this.isA_CreateAsset()) {
            asset.setAssetServiceDate(this.getDateDoc());
            asset.changeStatus("AC", this.getDateAcct());
            asset.setA_QTY_Original(this.getA_QTY_Current());
        }
        asset.saveEx();
        if (this.isA_CreateAsset() && !this.isA_Accumulated_Depr_Adjust()) {
            assetwk.setA_Current_Period(1);
            assetwk.saveEx();
        }
        if (this.isA_CreateAsset() && this.isA_Accumulated_Depr_Adjust()) {
            assetwk.setA_Current_Period(this.getA_Period_Start());
            assetwk.setA_Accumulated_Depr(this.getA_Accumulated_Depr());
            assetwk.setA_Accumulated_Depr_F(this.getA_Accumulated_Depr_F());
            assetwk.saveEx();
        }
        assetwk.buildDepreciation();
        this.updateSourceDocument(false);
        this.setProcessed(true);
        this.setDocAction("CL");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 9);
        if (this.m_processMsg != null) {
            return "IN";
        }
        return "CO";
    }

    public boolean voidIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.setA_CreateAsset(false);
        } else {
            this.reverseIt(false);
        }
        String errmsg = ModelValidationEngine.get().fireDocValidate((PO)this, 10);
        if (errmsg != null) {
            this.m_processMsg = errmsg;
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    private void reverseIt(boolean isReActivate) {
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.setDocAction("--");
            throw new AssetException("Document Closed: " + this.getDocStatus());
        }
        MAsset asset = this.getA_Asset(true);
        if ("DI".equals(asset.getA_Asset_Status())) {
            this.setDocAction("--");
            throw new AssetException("Asset already disposed");
        }
        MDepreciationWorkfile assetwk = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        if (assetwk == null) {
            throw new AssetException("@NotFound@ @A_DepreciationWorkfile_ID");
        }
        String additionClause = "A_Asset_Addition_ID>? AND A_Asset_ID=? AND A_CapvsExp=? AND M_AttributeSetInstance_ID>? AND AssetAmtEntered>? AND DateAcct>=? AND Processed=?";
        List listAddition = new Query(this.getCtx(), "A_Asset_Addition", "A_Asset_Addition_ID>? AND A_Asset_ID=? AND A_CapvsExp=? AND M_AttributeSetInstance_ID>? AND AssetAmtEntered>? AND DateAcct>=? AND Processed=?", this.get_TrxName()).setParameters(new Object[]{this.getA_Asset_Addition_ID(), this.getA_Asset_ID(), "Cap", this.getM_AttributeSetInstance_ID(), BigDecimal.ZERO, this.getDateAcct(), "Y"}).setOrderBy("DateAcct ASC ,A_Asset_Addition_ID ASC ,M_AttributeSetInstance_ID ASC ").list();
        if (assetwk.isFullyDepreciated()) {
            throw new AssetNotImplementedException("Unable to verify if it is fully depreciated");
        }
        if (assetwk.isDepreciated(this.getDateAcct())) {
            throw new AssetAlreadyDepreciatedException();
        }
        assetwk.adjustCost(this.getAssetValueAmt().negate(), this.getA_QTY_Current().negate(), false);
        assetwk.adjustUseLife(0 - this.getDeltaUseLifeYears(), 0 - this.getDeltaUseLifeYears_F(), false);
        assetwk.saveEx();
        if (listAddition.size() == 0) {
            if (this.isA_CreateAsset()) {
                assetwk.buildDepreciation();
                assetwk.deleteEx(true);
            } else {
                assetwk.buildDepreciation();
            }
        } else {
            assetwk.setA_Current_Period();
            assetwk.saveEx();
            assetwk.buildDepreciation();
        }
        this.updateA_Asset_Product(true);
        if (this.isA_CreateAsset() && listAddition.size() == 0) {
            asset.changeStatus("NW", this.getDateAcct());
            asset.saveEx();
            if (!isReActivate) {
                this.setA_CreateAsset(false);
            }
        }
        MFactAcct.deleteEx((int)this.get_Table_ID(), (int)this.get_ID(), (String)this.get_TrxName());
        this.updateSourceDocument(true);
    }

    public boolean closeIt() {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("closeIt - " + this.toString());
        }
        this.setDocAction("--");
        return true;
    }

    public boolean reverseCorrectIt() {
        throw new AssetNotImplementedException("reverseCorrectIt");
    }

    public boolean reverseAccrualIt() {
        throw new AssetNotImplementedException("reverseAccrualIt");
    }

    public boolean reActivateIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate((PO)this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.reverseIt(true);
        String errmsg = ModelValidationEngine.get().fireDocValidate((PO)this, 12);
        if (errmsg != null) {
            this.m_processMsg = errmsg;
            return false;
        }
        this.setProcessed(false);
        this.setDocAction("CO");
        return true;
    }

    public String getSummary() {
        MAsset asset = this.getA_Asset(false);
        StringBuilder sb = new StringBuilder();
        sb.append("@DocumentNo@ #").append(this.getDocumentNo()).append(": @A_CreateAsset@=@").append(this.isA_CreateAsset() ? "Y" : "N").append("@");
        if (asset != null) {
            sb.append(", @A_Asset_ID@=").append(asset.getName());
        }
        return Msg.parseTranslation((Properties)this.getCtx(), (String)sb.toString());
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public BigDecimal getApprovalAmt() {
        return this.getAssetValueAmt();
    }

    public MAsset getA_Asset(boolean requery) {
        return (MAsset)this.m_cacheAsset.get(requery);
    }

    private void setA_Asset(MAsset asset) {
        this.setA_Asset_ID(asset.getA_Asset_ID());
        this.m_cacheAsset.set((PO)asset);
    }

    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return false;
        }
        this.updateSourceDocument(false);
        return true;
    }

    private void updateSourceDocument(boolean isReversalParam) {
        String sourceType;
        boolean isReversal = isReversalParam;
        String docStatus = this.getDocStatus();
        if (!isReversal && ("RE".equals(docStatus) || "VO".equals(docStatus))) {
            isReversal = true;
        }
        if ("INV".equals(sourceType = this.getA_SourceType()) && this.isProcessed()) {
            int invoiceLineId = this.getC_InvoiceLine_ID();
            MInvoiceLine invoiceLine = new MInvoiceLine(this.getCtx(), invoiceLineId, this.get_TrxName());
            invoiceLine.setA_Processed(!isReversal);
            if (invoiceLine.isCollectiveAsset()) {
                invoiceLine.setA_Asset_ID(isReversal ? 0 : this.getA_Asset_ID());
            } else {
                invoiceLine.setA_Asset_ID(isReversal ? 0 : -1);
            }
            invoiceLine.saveEx();
        } else if ("PRJ".equals(sourceType) && this.isProcessed()) {
            if (!isReversal) {
                int project_id = this.getC_Project_ID();
                ProcessInfo pi = new ProcessInfo("", 0, MProject.Table_ID, project_id);
                pi.setAD_Client_ID(this.getAD_Client_ID());
                pi.setAD_User_ID(Env.getAD_User_ID((Properties)this.getCtx()));
                ProjectClose proc = new ProjectClose();
                proc.startProcess(this.getCtx(), pi, Trx.get((String)this.get_TrxName(), (boolean)false));
                if (pi.isError()) {
                    throw new AssetException(pi.getSummary());
                }
            }
        } else if ("IMP".equals(sourceType) && !this.isProcessed()) {
            MIFixedAsset ifa;
            if (this.is_new() && this.getI_FixedAsset_ID() > 0 && (ifa = this.getI_FixedAsset(false)) != null) {
                ifa.setI_IsImported(true);
                ifa.setA_Asset_ID(this.getA_Asset_ID());
                ifa.saveEx(this.get_TrxName());
            }
        } else if ("MAN".equals(sourceType) && this.isProcessed()) {
            this.log.fine("Nothing to do");
        }
    }

    private void checkCreateASI() {
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        MAttributeSetInstance asi = null;
        if (product != null && this.getM_AttributeSetInstance_ID() == 0) {
            asi = new MAttributeSetInstance(this.getCtx(), 0, this.get_TrxName());
            asi.setAD_Org_ID(0);
            asi.setM_AttributeSet_ID(product.getM_AttributeSet_ID());
            asi.saveEx();
            this.setM_AttributeSetInstance_ID(asi.getM_AttributeSetInstance_ID());
        }
    }

    private void updateA_Asset_Product(boolean isReversal) {
        if (this.getM_Product_ID() <= 0) {
            return;
        }
        MAssetProduct assetProduct = MAssetProduct.getCreate(this.getCtx(), this.getA_Asset_ID(), this.getM_Product_ID(), this.getM_AttributeSetInstance_ID(), this.get_TrxName());
        if (assetProduct.get_ID() <= 0 && isReversal) {
            this.log.warning("No Product found " + String.valueOf((Object)this) + " [IGNORE]");
            return;
        }
        BigDecimal adjQty = this.getA_QTY_Current();
        if (isReversal) {
            adjQty = adjQty.negate();
        }
        assetProduct.addA_Qty_Current(adjQty);
        MAsset asset = this.getA_Asset(false);
        assetProduct.addA_Qty_Current(asset.getA_QTY_Current());
        assetProduct.setM_Locator_ID(this.getM_Locator_ID());
        if (asset.getA_Asset_Status().equals("AC") && assetProduct.getA_QTY_Current().compareTo(BigDecimal.ZERO) <= 0 && !isReversal) {
            assetProduct.addA_Qty_Current(BigDecimal.ONE);
        }
        assetProduct.setAD_Org_ID(asset.getAD_Org_ID());
        assetProduct.saveEx();
        if (this.isA_CreateAsset()) {
            assetProduct.updateAsset(asset);
            asset.setA_QTY_Current(this.getA_QTY_Current());
            asset.setA_QTY_Original(this.getA_QTY_Current());
            asset.setQty(this.getA_QTY_Current());
            asset.saveEx();
        } else {
            asset.setA_QTY_Current(assetProduct.getA_QTY_Current());
            asset.setQty(assetProduct.getA_QTY_Current());
            asset.saveEx();
        }
    }

    public boolean hasZeroValues() {
        return this.getDeltaUseLifeYears() <= 0 || this.getAssetValueAmt().signum() <= 0;
    }

    public File createPDF() {
        return null;
    }

    public String getDocumentInfo() {
        return this.getDocumentNo() + " / " + String.valueOf(this.getDateDoc());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("@DocumentNo@: " + this.getDocumentNo());
        MAsset asset = this.getA_Asset(false);
        if (asset != null && asset.get_ID() > 0) {
            sb.append(", @A_Asset_ID@: ").append(asset.getName());
        }
        return sb.toString();
    }

    private void setA_CreateAsset() {
        if ("VO".equals(this.getDocStatus())) {
            this.setA_CreateAsset(false);
        } else {
            String sql = "SELECT COUNT(*) FROM A_Asset_Addition WHERE A_Asset_ID=? AND A_CreateAsset='Y' AND DocStatus IN ('CO','CL') AND IsActive='Y' AND A_Asset_Addition_ID<>?";
            int countAddition = DB.getSQLValueEx(null, (String)"SELECT COUNT(*) FROM A_Asset_Addition WHERE A_Asset_ID=? AND A_CreateAsset='Y' AND DocStatus IN ('CO','CL') AND IsActive='Y' AND A_Asset_Addition_ID<>?", (Object[])new Object[]{this.getA_Asset_ID(), this.getA_Asset_Addition_ID()});
            MAsset asset = new MAsset(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
            if ("Cap".equals(this.getA_CapvsExp())) {
                this.setA_CreateAsset(true);
            }
            if ("Cap".equals(this.getA_CapvsExp()) && this.getA_Asset_ID() > 0) {
                this.setA_CreateAsset(false);
            }
            if ("Exp".equals(this.getA_CapvsExp())) {
                this.setA_CreateAsset(false);
            }
            if (this.isA_CreateAsset()) {
                if (countAddition >= 1) {
                    this.setA_CreateAsset(false);
                } else if (countAddition == 0) {
                    this.setA_CreateAsset(true);
                    if (asset.getA_Asset_Status().equals("AC") && !asset.getAssetActivationDate().equals(this.getDateDoc())) {
                        this.setA_CreateAsset(false);
                    }
                }
            } else if (countAddition == 0) {
                if (asset.getA_Asset_Status().equals("AC") && !asset.getAssetActivationDate().equals(this.getDateDoc())) {
                    this.setA_CreateAsset(false);
                } else {
                    this.setA_CreateAsset(true);
                }
            }
        }
    }

    private void setC_DocType_ID() {
        StringBuilder sql = new StringBuilder("SELECT C_DocType_ID FROM C_DocType ").append("WHERE AD_Client_ID=? AND AD_Org_ID IN (0,").append(this.getAD_Org_ID()).append(") AND DocBaseType='FAA' ").append("ORDER BY AD_Org_ID DESC, IsDefault DESC");
        int C_DocType_ID = DB.getSQLValue(null, (String)sql.toString(), (int)this.getAD_Client_ID());
        if (C_DocType_ID <= 0) {
            this.log.severe("No FAA found for AD_Client_ID=" + this.getAD_Client_ID());
        } else {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("(PO) - " + C_DocType_ID);
            }
            this.set_ValueOfColumn("C_DocType_ID", C_DocType_ID);
        }
    }
}

