/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_M_Production;
import org.adempiere.core.domains.models.X_M_ProductionLine;
import org.adempiere.engine.CostEngine;
import org.adempiere.engine.CostEngineFactory;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.MTransaction;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_Production
extends Doc {
    private int m_Reversal_ID = 0;
    private String m_DocStatus = "";

    public Doc_Production(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, X_M_Production.class, rs, "MMP", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        X_M_Production prod = (X_M_Production)this.getPO();
        this.setDateDoc(prod.getMovementDate());
        this.setDateAcct(prod.getMovementDate());
        this.m_Reversal_ID = prod.getReversal_ID();
        this.m_DocStatus = prod.getDocStatus();
        this.p_lines = this.loadLines(prod);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(X_M_Production prod) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        String sqlPL = "SELECT * FROM M_ProductionLine pl WHERE pl.M_Production_ID=? ORDER BY pl.line";
        try {
            CPreparedStatement pstmtPL = DB.prepareStatement((String)sqlPL, (String)this.getTrxName());
            pstmtPL.setInt(1, this.get_ID());
            ResultSet rsPL = pstmtPL.executeQuery();
            while (rsPL.next()) {
                X_M_ProductionLine line = new X_M_ProductionLine(this.getCtx(), rsPL, this.getTrxName());
                if (line.getMovementQty().signum() == 0) {
                    this.log.info("LineQty=0 - " + String.valueOf(line));
                    continue;
                }
                DocLine docLine = new DocLine((PO)line, (Doc)this);
                docLine.setQty(line.getMovementQty(), false);
                docLine.setProductionBOM(line.getM_Product_ID() == prod.getM_Product_ID());
                this.log.fine(docLine.toString());
                list.add(docLine);
            }
            rsPL.close();
            pstmtPL.close();
        }
        catch (Exception ee) {
            this.log.log(Level.SEVERE, sqlPL, (Throwable)ee);
        }
        DocLine[] dl = new DocLine[list.size()];
        list.toArray(dl);
        return dl;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        MProduction prod = new MProduction(this.getCtx(), ((X_M_Production)this.getPO()).getM_Production_ID(), this.getTrxName());
        Doc_Production.deleteExistingProductionCosts(prod);
        Fact fact = new Fact((Doc)this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        FactLine factLine = null;
        BigDecimal total = Env.ZERO;
        DocLine parentProductionLine = null;
        for (DocLine line : this.p_lines) {
            BigDecimal totalCosts;
            MProduct product = line.getProduct();
            if (line.isProductionBOM()) {
                parentProductionLine = line;
                continue;
            }
            if ("I".equals(product.getProductType())) {
                totalCosts = Env.ZERO;
                BigDecimal qty = line.getQty();
                totalCosts = product.getCurrentCost(as, line.getDateDoc()).multiply(qty);
                if (totalCosts.compareTo(Env.ZERO) == 0) {
                    this.p_Error = "Producto " + product.getName() + " no tiene costo a la fecha " + String.valueOf(line.getDateAcct());
                    this.log.saveError("PostingError", this.p_Error);
                    return null;
                }
                factLine = fact.createLine(line, line.getAccount(3, as), line.getAccount(3, as), as.getC_Currency_ID(), totalCosts);
                factLine.setM_Product_ID(line.getM_Product_ID());
                factLine.setM_Locator_ID(line.getM_Locator_ID());
                factLine.setDescription("");
                total = total.add(totalCosts);
                continue;
            }
            if ("I".equals(product.getProductType())) continue;
            totalCosts = line.getQty();
            if (totalCosts == null || totalCosts.signum() == 0) {
                this.log.warning("Servicio sin valor asignado en l\u00ednea de producci\u00f3n: " + product.getName());
                continue;
            }
            MAccount acct = line.getAccount(2, as);
            factLine = fact.createLine(line, acct, acct, as.getC_Currency_ID(), totalCosts);
            factLine.setM_Product_ID(line.getM_Product_ID());
            factLine.setM_Locator_ID(line.getM_Locator_ID());
            factLine.setDescription(line.getDescription());
            total = total.add(totalCosts);
        }
        BigDecimal totalFinalCost = total.negate();
        factLine = fact.createLine(parentProductionLine, parentProductionLine.getAccount(3, as), parentProductionLine.getAccount(3, as), as.getC_Currency_ID(), totalFinalCost);
        factLine.setM_Product_ID(parentProductionLine.getM_Product_ID());
        factLine.setM_Locator_ID(parentProductionLine.getM_Locator_ID());
        factLine.setDescription("");
        total = total.add(totalFinalCost);
        if (total.signum() != 0) {
            factLine = fact.createLine(parentProductionLine, parentProductionLine.getAccount(9, as), as.getC_Currency_ID(), total);
            factLine.setM_Product_ID(parentProductionLine.getM_Product_ID());
            factLine.setM_Locator_ID(parentProductionLine.getM_LocatorTo_ID());
            factLine.setDescription(" Adjustment Cost");
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        Doc_Production.createProductionCost(prod);
        return facts;
    }

    public static void createProductionCost(MProduction prod) {
        String flag = Env.getContext((Properties)prod.getCtx(), (String)"#AJ_NoCreateCost");
        if ("Y".equals(flag == null ? Character.valueOf('N') : flag)) {
            return;
        }
        CostEngine engine = CostEngineFactory.getCostEngine((int)prod.getAD_Client_ID());
        for (MProductionLine pl : prod.getLines()) {
            if (pl.getMovementQty().signum() == 0) continue;
            List trxs = new Query(prod.getCtx(), "M_Transaction", "M_ProductionLine_ID=?", prod.get_TrxName()).setParameters(new Object[]{pl.getM_ProductionLine_ID()}).list();
            for (MTransaction trx : trxs) {
                engine.createCostDetail(trx, pl);
            }
        }
    }

    public static String getDateAcctColumnName() {
        return "MovementDate";
    }

    public static void deleteExistingProductionCosts(MProduction prod) {
        String flag = Env.getContext((Properties)prod.getCtx(), (String)"#AJ_NoCreateCost");
        if ("Y".equals(flag == null ? Character.valueOf('N') : flag)) {
            return;
        }
        String sql = "DELETE FROM M_CostDetail WHERE M_ProductionLine_ID IN (    SELECT pl.M_ProductionLine_ID     FROM M_ProductionLine pl     WHERE pl.M_Production_ID=?) OR M_Transaction_ID IN (    SELECT t.M_Transaction_ID     FROM M_Transaction t     WHERE t.M_ProductionLine_ID IN (        SELECT pl.M_ProductionLine_ID         FROM M_ProductionLine pl         WHERE pl.M_Production_ID=?    ))";
        DB.executeUpdateEx((String)sql, (Object[])new Object[]{prod.getM_Production_ID(), prod.getM_Production_ID()}, (String)prod.get_TrxName());
    }
}

