/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Bank;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.util.Env;

public class Doc_BankStatement
extends Doc {
    private int m_C_BankAccount_ID = 0;

    public Doc_BankStatement(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MBankStatement.class, rs, "CMB", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MBankStatement bs = (MBankStatement)this.getPO();
        this.setDateDoc(bs.getStatementDate());
        this.setDateAcct(bs.getStatementDate());
        this.m_C_BankAccount_ID = bs.getC_BankAccount_ID();
        this.setAmount(0, bs.getStatementDifference());
        MBankAccount ba = MBankAccount.get((Properties)this.getCtx(), (int)this.m_C_BankAccount_ID);
        this.setC_Currency_ID(ba.getC_Currency_ID());
        this.p_lines = this.loadLines(bs);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MBankStatement bs) {
        ArrayList<DocLine_Bank> list = new ArrayList<DocLine_Bank>();
        MBankStatementLine[] lines = bs.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MPeriod period;
            MBankStatementLine line = lines[i];
            DocLine_Bank docLine = new DocLine_Bank(line, this);
            if (i == 0) {
                this.setDateAcct(line.getDateAcct());
            }
            if ((period = MPeriod.get((Properties)this.getCtx(), (Timestamp)line.getDateAcct(), (int)line.getAD_Org_ID())) != null && period.isOpen("CMB", line.getDateAcct())) {
                docLine.setC_Period_ID(period.getC_Period_ID());
            }
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        for (int i = 0; i < this.p_lines.length; ++i) {
            BigDecimal lineBalance = ((DocLine_Bank)this.p_lines[i]).getStmtAmt();
            retValue = retValue.subtract(lineBalance);
            sb.append("-").append(lineBalance);
        }
        sb.append("]");
        this.log.fine(this.toString() + " Balance=" + String.valueOf(retValue) + sb.toString());
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact((Doc)this, as, "A");
        int AD_Org_ID = this.getBank_Org_ID();
        for (int i = 0; i < this.p_lines.length; ++i) {
            FactLine fl;
            DocLine_Bank line = (DocLine_Bank)this.p_lines[i];
            int C_BPartner_ID = line.getC_BPartner_ID();
            MAccount acctAsset = this.getAccount(40, as);
            MAccount acctTransit = this.getAccount(11, as);
            String tenderTypeLine = null;
            MBankStatementLine bankLine = new MBankStatementLine(this.getCtx(), line.get_ID(), this.getTrxName());
            if (bankLine.getC_Payment_ID() > 0) {
                tenderTypeLine = new MPayment(this.getCtx(), bankLine.getC_Payment_ID(), this.getTrxName()).getTenderType();
            }
            if (!as.isPostIfClearingEqual() && acctAsset.equals((Object)acctTransit)) {
                BigDecimal diff = line.getStmtAmt().subtract(line.getTrxAmt());
                if (diff.signum() != 0) {
                    fl = fact.createLine((DocLine)line, acctAsset, line.getC_Currency_ID(), diff);
                    if (fl != null && AD_Org_ID != 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    }
                    if (fl != null && C_BPartner_ID != 0) {
                        fl.setC_BPartner_ID(C_BPartner_ID);
                    }
                }
            } else {
                fl = fact.createLine((DocLine)line, acctAsset, line.getC_Currency_ID(), line.getStmtAmt());
                if (fl != null && AD_Org_ID != 0) {
                    fl.setAD_Org_ID(AD_Org_ID);
                }
                if (fl != null && C_BPartner_ID != 0) {
                    fl.setC_BPartner_ID(C_BPartner_ID);
                }
                MAccount contraAccount = "K".equals(tenderTypeLine) ? (line.getStmtAmt().signum() > 0 ? this.getAccount(16, as) : this.getAccount(17, as)) : acctTransit;
                fl = fact.createLine((DocLine)line, contraAccount, line.getC_Currency_ID(), line.getTrxAmt().negate());
                if (fl != null && C_BPartner_ID != 0) {
                    fl.setC_BPartner_ID(C_BPartner_ID);
                }
                if (fl != null) {
                    if (AD_Org_ID != 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    } else {
                        fl.setAD_Org_ID(line.getAD_Org_ID(true));
                    }
                }
            }
            if (line.getChargeAmt().signum() != 0) {
                MAccount chargeAcct = line.getChargeAccount(as, line.getChargeAmt().negate());
                fl = line.getChargeAmt().signum() > 0 ? fact.createLine((DocLine)line, chargeAcct, line.getC_Currency_ID(), null, line.getChargeAmt()) : fact.createLine((DocLine)line, chargeAcct, line.getC_Currency_ID(), line.getChargeAmt().negate(), null);
                if (fl != null && C_BPartner_ID != 0) {
                    fl.setC_BPartner_ID(C_BPartner_ID);
                }
            }
            if (line.getInterestAmt().signum() == 0 || (fl = line.getInterestAmt().signum() < 0 ? fact.createLine((DocLine)line, this.getAccount(42, as), this.getAccount(42, as), line.getC_Currency_ID(), line.getInterestAmt().negate()) : fact.createLine((DocLine)line, this.getAccount(41, as), this.getAccount(41, as), line.getC_Currency_ID(), line.getInterestAmt().negate())) == null || C_BPartner_ID == 0) continue;
            fl.setC_BPartner_ID(C_BPartner_ID);
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private int getBank_Org_ID() {
        if (this.m_C_BankAccount_ID == 0) {
            return 0;
        }
        MBankAccount ba = MBankAccount.get((Properties)this.getCtx(), (int)this.m_C_BankAccount_ID);
        return ba.getAD_Org_ID();
    }

    public static String getDateAcctColumnName() {
        return "StatementDate";
    }
}

