/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.purchases;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisition;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessAddWithholding
extends SvrProcess {
    private int p_C_Order_ID;
    private MRequisition requisition;

    protected void prepare() {
        this.p_C_Order_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MOrder order = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
        int requisitionId = this.getRequisitionId();
        if (requisitionId <= 0) {
            throw new AdempiereUserError("El documento no tiene asociado una Solicitud de Compra");
        }
        this.requisition = new MRequisition(this.getCtx(), requisitionId, this.get_TrxName());
        BigDecimal prepaymentRate = this.getRate(this.requisition, "AJ_PrepaymentRate");
        BigDecimal withholdingRate = this.getRate(this.requisition, "AJ_WithholdingRate");
        StringBuilder message = new StringBuilder();
        if (withholdingRate.compareTo(Env.ZERO) > 0) {
            message.append(this.generarCargo(order, withholdingRate, "retencion"));
        }
        if (prepaymentRate.compareTo(Env.ZERO) > 0) {
            if (message.length() > 0) {
                message.append(" y ");
            }
            message.append(this.generarCargo(order, prepaymentRate, "anticipo"));
        }
        return message.length() > 0 ? "Se genera " + message.toString() : "No se generan cargos. Verifique los factores de retenci\u00f3n y anticipo de la solicitud de compra.";
    }

    private int getRequisitionId() {
        return DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(mrl.M_Requisition_ID)  FROM C_OrderLine col  JOIN M_RequisitionLine mrl ON mrl.M_RequisitionLine_ID = col.M_RequisitionLine_ID  WHERE col.C_Order_ID = ?", (int)this.p_C_Order_ID);
    }

    private BigDecimal getRate(MRequisition requisition, String columnName) {
        Object value = requisition.get_Value(columnName);
        return value instanceof BigDecimal ? (BigDecimal)value : Env.ZERO;
    }

    private String generarCargo(MOrder order, BigDecimal rate, String tipoCargo) {
        int chargeId = this.getChargeId(tipoCargo);
        if (chargeId <= 0) {
            throw new AdempiereException("No se encuentra cargo v\u00e1lido con descripcion " + tipoCargo + " para generar la linea. Favor parametrizar correctamente el cargo.");
        }
        BigDecimal amount = order.getTotalLines().multiply(rate.divide(BigDecimal.valueOf(100L))).negate();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setC_Charge_ID(chargeId);
        orderLine.setQty(Env.ONE);
        orderLine.setPriceEntered(amount);
        orderLine.setPriceActual(amount);
        orderLine.setDescription("Generado a partir de los datos de solicitud " + this.requisition.getDocumentNo() + " (" + tipoCargo + "=" + String.valueOf(rate) + "%).");
        orderLine.saveEx();
        return "cargo " + tipoCargo;
    }

    private int getChargeId(String tipoCargo) {
        return DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(C_Charge_ID) FROM C_Charge  WHERE IsActive = 'Y'  AND LOWER(Description) LIKE ?  AND AD_Client_ID = ?", (Object[])new Object[]{"%" + tipoCargo.toLowerCase() + "%", Env.getAD_Client_ID((Properties)this.getCtx())});
    }
}

