/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.gdexpress;

import dteboxcliente.GrupoBusqueda;
import dteboxcliente.ResultadoDocumentos;
import dteboxcliente.ResumenDTE;
import dteboxcliente.Servicio;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MOrg;
import org.compiere.model.MSysConfig;
import org.compiere.model.X_AJC_VendorInvoiceImport;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class EKProcessGDExpressVendorInvoice
extends SvrProcess {
    private static final String PARAM_DATE_FROM = "DateFrom";
    private static final String PARAM_DATE_TO = "DateTo";
    private static final String PARAM_FIXED_QTY = "FixedQty";
    private Timestamp dateFrom = Timestamp.from(Instant.now().minus(7L, ChronoUnit.DAYS));
    private Timestamp dateTo = Timestamp.from(Instant.now());
    private int pageSize = 10;
    private int p_AD_Org_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (PARAM_DATE_FROM.equals(name)) {
                this.dateFrom = para.getParameterAsTimestamp();
                continue;
            }
            if (PARAM_DATE_TO.equals(name)) {
                this.dateTo = para.getParameterAsTimestamp();
                continue;
            }
            if (PARAM_FIXED_QTY.equals(name)) {
                this.pageSize = para.getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para.getParameterAsInt();
                continue;
            }
            this.log.warning("No se encuentra par\u00e1metro: " + name);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String doIt() throws Exception {
        String apiURL = MSysConfig.getValue((String)"DTEBoxServer", (String)"http://200.6.96.14/api/Core.svc/Core");
        String apiAuth = MSysConfig.getValue((String)"DTEBoxPass", (String)"a497c198-a553-4ad0-8576-3cd227dc2f57");
        Servicio servicio = new Servicio(apiURL, apiAuth);
        String ambiente = "P";
        GrupoBusqueda grupo = GrupoBusqueda.Recibidos;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String fecha_desde = sdf.format(this.dateFrom == null ? Timestamp.from(Instant.now().minus(7L, ChronoUnit.DAYS)) : this.dateFrom);
        String fecha_hasta = sdf.format(this.dateTo == null ? Timestamp.from(Instant.now()) : this.dateTo);
        String consulta = "(FchEmis:[" + fecha_desde + " TO 9999-12-31] AND FchEmis:[1000-01-01 TO " + fecha_hasta + "] AND NOT(TipoDTE:52)";
        if (this.p_AD_Org_ID > 0) {
            MOrg org = MOrg.get((Properties)this.getCtx(), (int)this.p_AD_Org_ID);
            String rutRecep = org.get_ValueAsString("EK_Value");
            if (rutRecep.length() <= 7) return "RUT " + rutRecep + " no es v\u00e1lido.";
            consulta = consulta + " AND RUTRecep:" + rutRecep;
        }
        consulta = consulta + ")";
        int page = 1;
        ResultadoDocumentos resultado = servicio.BuscarDocumentos(ambiente, grupo, consulta, page, this.pageSize);
        int docCount = 0;
        if (resultado.getResultadoServicio().getEstado() == 0) {
            if (resultado.getTotalDocumentos() <= 0) return "No se encontraron documentos.";
            int pages = resultado.getTotalPages();
            do {
                this.log.info("Procesando p\u00e1gina: " + page);
                for (ResumenDTE doc : resultado.getDocumentos()) {
                    if (doc != null) {
                        String gde_id = "T" + doc.TipoDTE + "F" + doc.Folio + "E" + doc.RUTEmisor;
                        int invoiceAlreadyExists = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(AJC_VendorInvoiceImport_ID) FROM AJC_VendorInvoiceImport WHERE AJ_GDExpressCode LIKE ?", (String)gde_id);
                        if (invoiceAlreadyExists > 0 || !this.saveDocument(doc, gde_id)) continue;
                        ++docCount;
                        continue;
                    }
                    this.log.warning("Documento inv\u00e1lido (null)");
                }
                if (++page > pages) continue;
                resultado = servicio.BuscarDocumentos(ambiente, grupo, consulta, page, this.pageSize);
            } while (page <= pages && resultado.getResultadoServicio().getEstado() == 0);
            return docCount == 1 ? "Se rescata " + docCount + " documento" : "Se rescatan " + docCount + " documentos.";
        } else {
            String error = resultado.getResultadoServicio().getDescripcion();
            resultado.getResultadoServicio().getExcepcionOriginal().printStackTrace();
            throw new AdempiereException(error);
        }
    }

    private boolean saveDocument(ResumenDTE doc, String gde_id) {
        X_AJC_VendorInvoiceImport invoice = new X_AJC_VendorInvoiceImport(this.getCtx(), 0, this.get_TrxName());
        invoice.setEK_SIICode(String.valueOf(doc.TipoDTE));
        invoice.setValue(doc.RUTEmisor);
        invoice.setName(doc.RznSoc);
        invoice.setAddress1(doc.CmnaOrigen);
        invoice.setDateInvoiced(new Timestamp(doc.FchEmis.getTime()));
        invoice.setDateAcct(new Timestamp(doc.FchRecepSII.getTime()));
        invoice.setDueDate(doc.FchVenc != null ? new Timestamp(doc.FchVenc.getTime()) : new Timestamp(doc.FchEmis.getTime()));
        invoice.setAJ_GDExpressCode(gde_id);
        invoice.setAJ_DocNo(String.valueOf(doc.Folio));
        if (doc.MntNeto.length() > 0) {
            invoice.setTotalLines(new BigDecimal(doc.MntNeto));
        }
        if (doc.MntExe.length() > 0) {
            invoice.setExemptAmt(new BigDecimal(doc.MntExe));
        }
        if (doc.IVA.length() > 0) {
            invoice.setTaxAmt(new BigDecimal(doc.IVA));
        }
        invoice.setGrandTotal(new BigDecimal(doc.MntTotal));
        if (invoice.save()) {
            int client_id = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT MAX(AD_Client_ID) FROM AD_Org WHERE UPPER(EK_Value) LIKE ?", (String)doc.RUTRecep);
            String sql = "UPDATE AJC_VendorInvoiceImport i SET AD_Client_ID = ?, C_BPartner_ID = (SELECT MAX(cbp.C_BPartner_ID) FROM C_BPartner cbp WHERE cbp.Value LIKE ? AND AD_Client_ID=?), C_DocType_ID = (SELECT MAX(cdt.C_DocType_ID) FROM C_DocType cdt WHERE cdt.SerNo LIKE ? AND AD_Client_ID=?), AD_Org_ID = (SELECT MIN(AD_Org_ID) FROM AD_Org WHERE UPPER(EK_Value) LIKE ?) WHERE AJC_VendorInvoiceImport_ID=?";
            Object[] params = new Object[]{client_id, invoice.getValue(), client_id, invoice.getEK_SIICode(), client_id, doc.RUTRecep, invoice.getAJC_VendorInvoiceImport_ID()};
            DB.executeUpdate((String)sql, (Object[])params, (boolean)true, (String)this.get_TrxName());
            return true;
        }
        return false;
    }
}

