/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.gdexpress;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MInvoice;
import org.compiere.model.X_AJC_VendorInvoiceImport;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessGDExpressMatchInvoiceVendor
extends SvrProcess {
    private final int p_AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());

    protected void prepare() {
    }

    protected String doIt() throws Exception {
        this.cleanMissRecordsMatched();
        this.updatePartnerID();
        this.updateDocTypeID();
        Object sql = "SELECT AJC_VendorInvoiceImport_ID, AD_Client_ID, C_BPartner_ID, C_DocType_ID, AJ_DocNo, GrandTotal, DateInvoiced FROM AJC_VendorInvoiceImport WHERE IsActive='Y' AND (AJ_MatchType <> 'EM' OR AJ_MatchType IS NULL) AND C_BPartner_ID IS NOT NULL AND C_DocType_ID IS NOT NULL AND AJ_DocNo IS NOT NULL AND GrandTotal IS NOT NULL";
        if (this.p_AD_Client_ID != 0) {
            sql = (String)sql + " AND AD_Client_ID=" + this.p_AD_Client_ID;
        }
        sql = (String)sql + " ORDER BY AD_Client_ID, DateInvoiced, AJ_DocNo";
        CPreparedStatement pstmImport = DB.prepareStatement((String)sql, (String)this.get_TrxName());
        ResultSet rsImport = pstmImport.executeQuery();
        int exMatchCount = 0;
        int paMatchCount = 0;
        block0: while (rsImport.next()) {
            int import_client_id = rsImport.getInt("AD_Client_ID");
            int import_bp_id = rsImport.getInt("C_BPartner_ID");
            int import_dt_id = rsImport.getInt("C_DocType_ID");
            String import_docNo = rsImport.getString("AJ_DocNo");
            BigDecimal import_total = rsImport.getBigDecimal("GrandTotal");
            Timestamp import_date = rsImport.getTimestamp("DateInvoiced");
            sql = "SELECT C_Invoice_ID, DocumentNo, GrandTotal FROM C_Invoice WHERE IsActive='Y' AND AD_Client_ID=? AND DocStatus IN ('CO','CL') AND C_BPartner_ID=? AND C_DocType_ID=? AND DateInvoiced =? AND (AJ_MatchType <> 'EM' OR AJ_MatchType IS NULL) ORDER BY AD_Client_ID, DateInvoiced, Documentno";
            CPreparedStatement pstmInvoice = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmInvoice.setInt(1, import_client_id);
            pstmInvoice.setInt(2, import_bp_id);
            pstmInvoice.setInt(3, import_dt_id);
            pstmInvoice.setTimestamp(4, import_date);
            ResultSet rsInvoice = pstmInvoice.executeQuery();
            while (rsInvoice.next()) {
                MInvoice i;
                X_AJC_VendorInvoiceImport ii;
                boolean sameTotalTolerance;
                boolean sameTotal;
                String invoice_docNo = rsInvoice.getString("DocumentNo");
                BigDecimal invoice_total = rsInvoice.getBigDecimal("GrandTotal");
                boolean sameDocNo = import_docNo.equals(invoice_docNo);
                boolean bl = sameTotal = import_total.compareTo(invoice_total) == 0;
                if (sameDocNo && sameTotal) {
                    MInvoice i2;
                    X_AJC_VendorInvoiceImport ii2 = new X_AJC_VendorInvoiceImport(this.getCtx(), rsImport.getInt("AJC_VendorInvoiceImport_ID"), this.get_TrxName());
                    if (this.setMatchStatus(ii2, i2 = MInvoice.get(this.getCtx(), rsInvoice.getInt("C_Invoice_ID")), "EM")) {
                        // empty if block
                    }
                    ++exMatchCount;
                    DB.close((ResultSet)rsInvoice, (Statement)pstmInvoice);
                    continue block0;
                }
                BigDecimal fromTotal = invoice_total.subtract(invoice_total.multiply(new BigDecimal(0.05)));
                BigDecimal toTotal = invoice_total.add(invoice_total.multiply(new BigDecimal(0.05)));
                boolean bl2 = sameTotalTolerance = invoice_total.compareTo(fromTotal) >= 0 && invoice_total.compareTo(toTotal) <= 0;
                if (sameDocNo && sameTotalTolerance) {
                    ii = new X_AJC_VendorInvoiceImport(this.getCtx(), rsImport.getInt("AJC_VendorInvoiceImport_ID"), this.get_TrxName());
                    if (this.setMatchStatus(ii, i = MInvoice.get(this.getCtx(), rsInvoice.getInt("C_Invoice_ID")), "MA")) {
                        ++paMatchCount;
                    }
                    DB.close((ResultSet)rsInvoice, (Statement)pstmInvoice);
                    continue block0;
                }
                if (!sameTotal) continue;
                ii = new X_AJC_VendorInvoiceImport(this.getCtx(), rsImport.getInt("AJC_VendorInvoiceImport_ID"), this.get_TrxName());
                i = MInvoice.get(this.getCtx(), rsInvoice.getInt("C_Invoice_ID"));
                this.setMatchStatus(ii, i, "MD");
                ++paMatchCount;
                DB.close((ResultSet)rsInvoice, (Statement)pstmInvoice);
                continue block0;
            }
        }
        return "Se asosian " + exMatchCount + " Coincidencias Exactas y " + paMatchCount + " Parciales.";
    }

    private boolean setMatchStatus(X_AJC_VendorInvoiceImport ii, MInvoice i, String matchType) {
        ii.setC_Invoice_ID(i.getC_Invoice_ID());
        ii.setAJ_MatchType(matchType);
        ii.setAJ_IsMatched(true);
        i.set_CustomColumn("AJC_VendorInvoiceImport_ID", ii.getAJC_VendorInvoiceImport_ID());
        i.set_CustomColumn("AJ_MatchType", matchType);
        i.set_CustomColumn("AJ_IsMatched", true);
        return ii.save() && i.save();
    }

    private void updatePartnerID() {
        Object sql = "UPDATE AJC_VendorInvoiceImport i SET C_BPartner_ID = (SELECT MAX(cbp.C_BPartner_ID) FROM C_BPartner cbp WHERE cbp.Value LIKE i.Value AND cbp.AD_Client_ID=i.AD_Client_ID) WHERE C_BPartner_ID IS NULL AND IsActive='Y'";
        if (this.p_AD_Client_ID != 0) {
            sql = (String)sql + " AND AD_Client_ID=" + this.p_AD_Client_ID;
        }
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
    }

    private void updateDocTypeID() {
        Object sql = "UPDATE AJC_VendorInvoiceImport i SET C_DocType_ID = (SELECT MAX(cdt.C_DocType_ID) FROM C_DocType cdt WHERE cdt.SerNo LIKE i.EK_SIICode AND cdt.AD_Client_ID=i.AD_Client_ID) WHERE C_DocType_ID IS NULL AND IsActive='Y'";
        if (this.p_AD_Client_ID != 0) {
            sql = (String)sql + " AND AD_Client_ID=" + this.p_AD_Client_ID;
        }
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
    }

    private void cleanMissRecordsMatched() {
        Object sql = "UPDATE AJC_VendorInvoiceImport i SET AJ_IsMatched = 'N', AJ_MatchType = NULL WHERE C_Invoice_ID IS NULL AND (AJ_IsMatched='Y' OR AJ_MatchType IS NOT NULL)";
        if (this.p_AD_Client_ID != 0) {
            sql = (String)sql + " AND AD_Client_ID=" + this.p_AD_Client_ID;
        }
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
        sql = "UPDATE C_Invoice i SET AJ_IsMatched = 'N', AJ_MatchType = NULL WHERE AJC_VendorInvoiceImport_ID IS NULL AND (AJ_IsMatched='Y' OR AJ_MatchType IS NOT NULL)";
        if (this.p_AD_Client_ID != 0) {
            sql = (String)sql + " AND AD_Client_ID=" + this.p_AD_Client_ID;
        }
        DB.executeUpdate((String)sql, (String)this.get_TrxName());
    }
}

