/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.email;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MUser;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.EMail;

public class EKProcessSendGerencialSummaryStatus
extends SvrProcess {
    private int adClientId;

    protected void prepare() {
        this.adClientId = this.getAD_Client_ID();
    }

    protected String doIt() throws Exception {
        String sqlUsuarios = "SELECT u.ad_user_id, u.email, u.name FROM ad_user u JOIN c_job j ON u.c_job_id = j.c_job_id JOIN c_jobcategory jc ON jc.c_jobcategory_id=j.c_jobcategory_id WHERE jc.name ilike 'gerencia' AND u.email IS NOT NULL";
        CPreparedStatement ps = DB.prepareStatement((String)sqlUsuarios, (String)this.get_TrxName());
        ResultSet rs = ps.executeQuery();
        int enviados = 0;
        while (rs.next()) {
            int userId = rs.getInt("ad_user_id");
            String emailTo = rs.getString("email");
            String userName = rs.getString("name");
            String tablaHtml = this.generarTablaHtml(userId);
            if (tablaHtml == null) continue;
            String cuerpo = "Estimados,<br><br>Adjunto encontrar\u00e1n el resumen semanal de actividad por usuario correspondiente a la \u00faltima semana.<br><br>Este informe considera:<br>1.- Cantidad de sesiones iniciadas en el sistema.<br>2.- N\u00famero de documentos creados (\u00f3rdenes de venta o compra).<br>3.- Cantidad de inventarios f\u00edsicos registrados.<br><br>La informaci\u00f3n est\u00e1 agrupada por semana y por usuario, e incluye el RUT y nombre del socio de negocio asociado a cada usuario.<br><br>A continuaci\u00f3n, se detalla la informaci\u00f3n correspondiente:<br><br>" + tablaHtml + "<br><br>Saludos cordiales,<br>Equipo AJAH";
            MClient client = MClient.get((Properties)this.getCtx(), (int)this.adClientId);
            String remitente = client.getRequestEMail();
            EMail mail = new EMail(client, remitente, emailTo, "Resumen semanal de actividad de usuarios", cuerpo);
            mail.createAuthenticator(remitente, client.getRequestUserPW());
            mail.setMessageText(null);
            mail.setMessageHTML(null);
            String finalHtml = "<!DOCTYPE html><html><head><meta http-equiv='Content-Type' content='text/html; charset=UTF-8'><style>table { border-collapse: collapse; } td, th { padding: 4px 8px; }</style></head><body>" + cuerpo + "</body></html>";
            mail.setMessageHTML("Resumen semanal de actividad", finalHtml);
            String result = mail.send();
            if (!"OK".equals(result)) continue;
            ++enviados;
        }
        rs.close();
        ps.close();
        return "Correos enviados correctamente: " + enviados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generarTablaHtml(int userId) {
        String string;
        MUser user = MUser.get((Properties)this.getCtx(), (int)userId);
        String sql = "SELECT * FROM RJG_MailAP1 WHERE ad_client_id = ?";
        CPreparedStatement ps = null;
        ResultSet rs = null;
        StringBuilder sb = new StringBuilder();
        try {
            ps = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ps.setInt(1, user.getAD_Client_ID());
            rs = ps.executeQuery();
            sb.append("<table border='1' cellpadding='5' cellspacing='0' style='border-collapse: collapse; width: 100%; font-family: Arial, sans-serif; font-size: 13px;'>");
            sb.append("<tr>").append("<th style='background-color: #A9C3A9; color: black; border: 1px solid #ccc;'>Semana</th>").append("<th style='background-color: #A9C3A9; color: black; border: 1px solid #ccc;'>Usuario</th>").append("<th style='background-color: #A9C3A9; color: black; border: 1px solid #ccc;'>RUT</th>").append("<th style='background-color: #A9C3A9; color: black; border: 1px solid #ccc;'>Socio</th>").append("<th style='background-color: #A9C3A9; color: black; border: 1px solid #ccc;'>Sesiones</th>").append("<th style='background-color: #A9C3A9; color: black; border: 1px solid #ccc;'>Documentos</th>").append("<th style='background-color: #A9C3A9; color: black; border: 1px solid #ccc;'>Inventarios</th>").append("</tr>");
            boolean tieneDatos = false;
            boolean esPar = false;
            while (rs.next()) {
                tieneDatos = true;
                String bgColor = esPar ? "#F0F0F0" : "#FFFFFF";
                esPar = !esPar;
                sb.append("<tr>").append("<td style='background-color: ").append(bgColor).append("; border: 1px solid #ccc;'>").append(rs.getString("semana")).append("</td>").append("<td style='background-color: ").append(bgColor).append("; border: 1px solid #ccc;'>").append(rs.getString("nombre_usuario")).append("</td>").append("<td style='background-color: ").append(bgColor).append("; border: 1px solid #ccc;'>").append(rs.getString("rut")).append("</td>").append("<td style='background-color: ").append(bgColor).append("; border: 1px solid #ccc;'>").append(rs.getString("nombre_socio_negocio")).append("</td>").append("<td style='background-color: ").append(bgColor).append("; text-align: center; border: 1px solid #ccc;'>").append(rs.getInt("cantidad_sesiones")).append("</td>").append("<td style='background-color: ").append(bgColor).append("; text-align: center; border: 1px solid #ccc;'>").append(rs.getInt("documentos_creados")).append("</td>").append("<td style='background-color: ").append(bgColor).append("; text-align: center; border: 1px solid #ccc;'>").append(rs.getInt("inventarios_fisicos_creados")).append("</td>").append("</tr>");
            }
            if (!tieneDatos) {
                sb.append("<tr>").append("<td colspan='4' style='text-align:center; font-style: italic; background-color: #FFFFFF; border: 1px solid #ccc;'>Sin registros</td>").append("<td style='text-align:center; background-color: #FFFFFF; border: 1px solid #ccc;'>0</td>").append("<td style='text-align:center; background-color: #FFFFFF; border: 1px solid #ccc;'>0</td>").append("<td style='text-align:center; background-color: #FFFFFF; border: 1px solid #ccc;'>0</td>").append("</tr>");
            }
            sb.append("</table>");
            string = sb.toString();
        }
        catch (Exception e) {
            String string2;
            try {
                this.log.severe("Error generando tabla: " + e.getMessage());
                string2 = null;
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)ps);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)ps);
            return string2;
        }
        DB.close((ResultSet)rs, (Statement)ps);
        return string;
    }
}

