/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process.commercial;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.Query;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class EKProcessCreateLinesFromScript
extends SvrProcess {
    private int p_C_Order_ID;

    protected void prepare() {
        this.p_C_Order_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_C_Order_ID <= 0) {
            return "ID de orden no encontrada";
        }
        Object msj = "";
        int cantInsert = 0;
        int cantNoInsert = 0;
        MOrder order = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
        String textInLines = order.get_ValueAsString("Script");
        if (textInLines == null || textInLines.length() < 1) {
            return "No se llena correctamente campo Script";
        }
        NumberFormat nf = NumberFormat.getInstance(new Locale("es", "CL"));
        for (String linea : textInLines.split("\n")) {
            BigDecimal price;
            BigDecimal qty;
            String description;
            if ((linea = linea.trim()).isEmpty() || linea.startsWith("Codigo")) continue;
            String[] columnas = linea.split("\t");
            if (columnas.length < 4) {
                this.log.warning("Linea \"" + linea + "\" no tiene 4 columnas. Revisar formato, debe estar separado por tabulaciones.");
                continue;
            }
            String value = columnas[0].trim();
            if (this.createLine(order, value, description = columnas[1].trim(), qty = new BigDecimal(nf.parse(columnas[2].trim()).toString()), price = new BigDecimal(nf.parse(columnas[3].trim()).toString()))) {
                ++cantInsert;
                continue;
            }
            ++cantNoInsert;
        }
        msj = cantInsert == 1 ? "Se genera 1 l\u00ednea" : (cantInsert > 1 ? "Se generan " + cantInsert + " l\u00edneas" : "No se generan l\u00edneas");
        msj = cantNoInsert > 0 ? (String)msj + "(" + cantNoInsert + " no generadas)." : (String)msj + ".";
        return msj;
    }

    private boolean createLine(MOrder order, String value, String description, BigDecimal qty, BigDecimal price) {
        try {
            int M_Product_ID = new Query(this.getCtx(), "M_Product", "Value = ? AND AD_Client_ID = ?", this.get_TrxName()).setParameters(new Object[]{value, order.getAD_Client_ID()}).firstId();
            if (M_Product_ID <= 0) {
                this.log.warning("Producto c\u00f3digo " + value + " no encontrado.");
                return false;
            }
            MProduct prod = MProduct.get(this.getCtx(), M_Product_ID);
            String sql = "SELECT max(ppv.M_Product_ID) FROM M_PriceList pl JOIN M_PriceList_Version plv ON (pl.M_PriceList_ID = plv.M_PriceList_ID) JOIN M_ProductPrice ppv ON (plv.M_PriceList_Version_ID = ppv.M_PriceList_Version_ID) WHERE pl.M_PriceList_ID = ? AND plv.ValidFrom <= ? AND ppv.M_Product_ID = ? ORDER BY plv.ValidFrom DESC";
            int found = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{order.getM_PriceList_ID(), order.getDateOrdered(), M_Product_ID});
            if (found <= 0) {
                this.log.warning("Producto c\u00f3digo " + value + " no est\u00e1 en la lista de precios activa.");
                return false;
            }
            MOrderLine line = new MOrderLine(order);
            line.setM_Product_ID(M_Product_ID, true);
            line.setQty(qty);
            line.setPrice(price);
            line.setDescription(description);
            line.setPriceEntered(price);
            line.setPriceActual(price);
            line.setPriceList(price);
            line.setLineNetAmt();
            line.saveEx();
        }
        catch (Exception e) {
            this.log.warning("Producto c\u00f3digo " + value + " no fue importado ==> " + e.getMessage());
            return false;
        }
        return true;
    }
}

