/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.print.MPrintFormat;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class EKProcess_CopyPrintFormat
extends SvrProcess {
    private int p_PrintFormat_ID;

    protected void prepare() {
        this.p_PrintFormat_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        StringBuilder sqlReturnBuilder = new StringBuilder();
        MPrintFormat pf = new MPrintFormat(this.getCtx(), this.p_PrintFormat_ID, this.get_TrxName());
        if (pf.get_ID() <= 0) {
            return "No se encontr\u00f3 el PrintFormat con ID: " + this.p_PrintFormat_ID;
        }
        ArrayList<Integer> client_ids = new ArrayList<Integer>();
        String sqlClientIds = "SELECT ad_client_id FROM ad_client WHERE ad_client_id NOT IN (11, 0, ?)";
        try (CPreparedStatement pstmt = DB.prepareStatement((String)sqlClientIds, (String)this.get_TrxName());){
            pstmt.setInt(1, pf.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                client_ids.add(rs.getInt("ad_client_id"));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error al obtener ad_client_id", (Throwable)e);
            return "Error al obtener ad_client_id: " + e.getMessage();
        }
        if (client_ids.isEmpty()) {
            return "No se encontraron ad_client_id para copiar.";
        }
        int totalCopied = 0;
        for (Integer Client_ID : client_ids) {
            MPrintFormat to_pf;
            this.log.info("Copying from AD_Client_ID=" + Client_ID);
            String isekcopy = DB.getSQLValueString((String)this.get_TrxName(), (String)"select isekcopy from AD_PrintFormat where description= ? and ad_client_id= ?", (Object[])new Object[]{pf.getDescription(), Client_ID});
            int to_AD_PrintFormat_ID = DB.getSQLValue((String)this.get_TrxName(), (String)"select AD_PrintFormat_ID from AD_PrintFormat where description= ? and ad_client_id= ?", (Object[])new Object[]{pf.getDescription(), Client_ID});
            if (to_AD_PrintFormat_ID <= 0) {
                this.log.info("Copying PrintFormat '" + pf.getDescription() + "' to AD_Client_ID=" + Client_ID);
                try {
                    to_pf = MPrintFormat.copyToClient((Properties)this.getCtx(), (int)this.p_PrintFormat_ID, (int)Client_ID);
                    to_pf.setName(EKProcess_CopyPrintFormat.stripClientArrowPrefix(to_pf.getName()));
                    to_pf.saveEx();
                    sqlReturnBuilder.append("Copiado: ").append(to_pf.getName()).append(" #").append(to_pf.getItemCount()).append("\n");
                    ++totalCopied;
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Error al copiar AD_PrintFormat", (Throwable)e);
                    return "Error al copiar AD_PrintFormat: " + e.getMessage();
                }
            }
            if (to_AD_PrintFormat_ID <= 0 || !"Y".equals(isekcopy)) continue;
            this.log.info("Updating PrintFormat '" + pf.getDescription() + "' for AD_Client_ID=" + Client_ID);
            try {
                DB.executeUpdate((String)"DELETE FROM AD_PrintFormatItem_Trl WHERE AD_PrintFormatItem_ID in(select AD_PrintFormatItem_ID from AD_PrintFormatItem where AD_PrintFormat_ID=?)", (int)to_AD_PrintFormat_ID, (boolean)false, (String)this.get_TrxName());
                DB.executeUpdate((String)"DELETE FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID= ?", (int)to_AD_PrintFormat_ID, (boolean)false, (String)this.get_TrxName());
                to_pf = MPrintFormat.copy((Properties)this.getCtx(), (int)this.p_PrintFormat_ID, (int)to_AD_PrintFormat_ID);
                to_pf.setName(EKProcess_CopyPrintFormat.stripClientArrowPrefix(to_pf.getName()));
                to_pf.saveEx();
                sqlReturnBuilder.append("actualizado: ").append(to_pf.getName()).append(" #").append(to_pf.getItemCount()).append("\n");
                ++totalCopied;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Error al actualizado AD_PrintFormat", (Throwable)e);
                DB.rollback((boolean)true, (String)this.get_TrxName());
                return "Error al copiar AD_PrintFormat: " + e.getMessage();
            }
        }
        DB.commit((boolean)true, (String)this.get_TrxName());
        sqlReturnBuilder.append("Total de AD_PrintFormat copiados/actualizados: ").append(totalCopied).append("\n");
        return sqlReturnBuilder.toString();
    }

    private static String stripClientArrowPrefix(String name) {
        return name.replaceFirst("^[^>]+->\\s*", "");
    }
}

