/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.MTree;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcess_CopyMenuToClient
extends SvrProcess {
    private int p_Dst_Client_ID = 0;
    private boolean p_CheckOrphans = true;

    protected void prepare() {
        for (ProcessInfoParameter p : this.getParameter()) {
            String name = p.getParameterName();
            if ("AD_Client_ID_Destination".equalsIgnoreCase(name)) {
                this.p_Dst_Client_ID = p.getParameterAsInt();
                continue;
            }
            if ("CheckOrphans".equalsIgnoreCase(name)) {
                this.p_CheckOrphans = "Y".equalsIgnoreCase(p.getParameterAsString());
                continue;
            }
            this.log.warning("Par\u00e1metro no soportado: " + name);
        }
    }

    protected String doIt() throws Exception {
        int roleId = this.getRecord_ID();
        StringBuilder resultMessage = new StringBuilder("Resumen de inserciones:\n");
        StringBuilder errorMessage = new StringBuilder("Errores encontrados:\n");
        if (this.p_Dst_Client_ID <= 0) {
            return "Debe indicar AD_Client_ID_Destination.";
        }
        int srcTreeId = this.detectRoleTreeId(roleId);
        if (srcTreeId <= 0) {
            throw new AdempiereUserError("No se encontr\u00f3 AD_Tree_ID en el Rol actual.");
        }
        String trxName = this.get_TrxName();
        MTree srcTree = new MTree(this.getCtx(), srcTreeId, trxName);
        if (srcTree.get_ID() <= 0) {
            return "\u00c1rbol origen no encontrado: AD_Tree_ID=" + srcTreeId;
        }
        if (srcTree.getDescription() == null) {
            return "\u00c1rbol origen sin Description: se requiere que Description contenga el nombre 'sin c\u00f3digo de compa\u00f1\u00eda'.";
        }
        int srcClientId = srcTree.getAD_Client_ID();
        if (srcClientId == this.p_Dst_Client_ID) {
            return "El cliente destino es el mismo que el origen; no hay nada que copiar.";
        }
        if (this.p_Dst_Client_ID == 0 || this.p_Dst_Client_ID == 11) {
            return "Cliente destino inv\u00e1lido (0 o 11).";
        }
        try {
            int to_tree_id = DB.getSQLValue((String)trxName, (String)"SELECT AD_Tree_ID FROM AD_Tree WHERE Description=? AND AD_Client_ID=?", (Object[])new Object[]{srcTree.getDescription(), this.p_Dst_Client_ID});
            String isdescription = DB.getSQLValueString((String)trxName, (String)"SELECT 'Y' FROM AD_Tree WHERE Description IS NULL AND Name=? AND AD_Client_ID=?", (Object[])new Object[]{srcTree.getName(), this.p_Dst_Client_ID});
            if ("Y".equals(isdescription)) {
                String cliente = DB.getSQLValueString((String)trxName, (String)"SELECT Name FROM AD_Client WHERE AD_Client_ID=?", (int)this.p_Dst_Client_ID);
                return "Cliente " + cliente + " tiene \u00e1rbol con el mismo nombre, pero sin Description.";
            }
            String isekcopy = null;
            if (to_tree_id <= 0) {
                String clientValueSrc = DB.getSQLValueString((String)trxName, (String)"SELECT Value FROM AD_Client WHERE AD_Client_ID=?", (int)srcClientId);
                String clientValueDst = DB.getSQLValueString((String)trxName, (String)"SELECT Value FROM AD_Client WHERE AD_Client_ID=?", (int)this.p_Dst_Client_ID);
                String isdescription2 = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT 'Y' FROM ad_tree WHERE description is null and name = ? AND ad_client_id = ?", (Object[])new Object[]{srcTree.getName().replaceFirst("^" + clientValueSrc, clientValueDst), this.p_Dst_Client_ID});
                if ("Y".equals(isdescription2)) {
                    String cliente = DB.getSQLValueString((String)this.get_TrxName(), (String)"select name from ad_client where ad_client_id= ?", (int)this.p_Dst_Client_ID);
                    return "cliente " + cliente + " tiene \u00e1rbol con el nombre " + srcTree.getName().replaceFirst("^" + clientValueSrc, clientValueDst) + ", pero sin descripcion, si no desea actualizar este menu, debe quitar check Copia Centralizado";
                }
                MTree to_tree = new MTree(this.getCtx(), 0, trxName);
                PO.copyValues((PO)srcTree, (PO)to_tree);
                to_tree.set_ValueOfColumn("AD_Client_ID", (Object)this.p_Dst_Client_ID);
                to_tree.set_ValueOfColumn("AD_Org_ID", (Object)0);
                String newTreeName = srcTree.getName().replaceFirst("^" + clientValueSrc, clientValueDst);
                to_tree.setName(newTreeName);
                to_tree.saveEx();
                to_tree_id = to_tree.getAD_Tree_ID();
                isekcopy = "Y";
                resultMessage.append("Nuevo \u00e1rbol creado: ").append(newTreeName).append(" con AD_Tree_ID = ").append(to_tree_id).append(" -> ");
                this.log.info("Nuevo \u00e1rbol creado en destino AD_Client_ID=" + this.p_Dst_Client_ID + " AD_Tree_ID=" + to_tree_id);
            } else {
                isekcopy = DB.getSQLValueString((String)trxName, (String)"SELECT isekcopy FROM AD_Tree WHERE AD_Tree_ID=? AND AD_Client_ID=?", (Object[])new Object[]{to_tree_id, this.p_Dst_Client_ID});
                if ("Y".equals(isekcopy)) {
                    try {
                        String deleteSql = "DELETE FROM ad_treenodemm WHERE ad_tree_id = ?";
                        int rowsDeleted = DB.executeUpdate((String)deleteSql, (Object[])new Object[]{to_tree_id}, (boolean)false, (String)trxName);
                        this.log.info("Nodos eliminados en ad_treenodemm destino AD_Tree_ID=" + to_tree_id + ": " + rowsDeleted);
                    }
                    catch (Exception e) {
                        this.log.log(Level.SEVERE, "Error al eliminar nodos previos en destino", (Throwable)e);
                        errorMessage.append("Error al eliminar nodos previos en destino: ").append(e.getMessage()).append("\n");
                        DB.rollback((boolean)true, (String)trxName);
                        return resultMessage.append("\n").append((CharSequence)errorMessage).toString();
                    }
                } else {
                    this.log.info("El \u00e1rbol destino existe y isekcopy='N'. No se copiar\u00e1n nodos.");
                    return "El \u00e1rbol destino existe y isekcopy='N'. No se realiz\u00f3 copia de nodos.";
                }
            }
            if ("Y".equals(isekcopy)) {
                String sqlInsert = "INSERT INTO ad_treenodemm (ad_tree_id, node_id, ad_client_id, ad_org_id, isactive, created, createdby,  updated, updatedby, parent_id, seqno, uuid) SELECT ?, node_id, ?, 0, isactive, NOW(), ?, NOW(), ?, parent_id, seqno, gen_random_uuid() FROM ad_treenodemm WHERE ad_tree_id = ?";
                Object[] params = new Object[]{to_tree_id, this.p_Dst_Client_ID, Env.getAD_User_ID((Properties)this.getCtx()), Env.getAD_User_ID((Properties)this.getCtx()), srcTreeId};
                try {
                    int rowsInserted = DB.executeUpdate((String)sqlInsert, (Object[])params, (boolean)false, (String)trxName);
                    resultMessage.append("ad_treenodemm: ").append(rowsInserted).append(" registros insertados para AD_Client_ID = ").append(this.p_Dst_Client_ID).append(".\n");
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Error al insertar en ad_treenodemm", (Throwable)e);
                    errorMessage.append("Error insertando nodos en destino: ").append(e.getMessage()).append("\n");
                    DB.rollback((boolean)true, (String)trxName);
                    return resultMessage.append("\n").append((CharSequence)errorMessage).toString();
                }
            }
            if (this.p_CheckOrphans) {
                int huMM = DB.getSQLValue((String)trxName, (String)"SELECT COUNT(*) FROM AD_TreeNodeMM d WHERE d.AD_Tree_ID=? AND d.Parent_ID IS NOT NULL AND NOT EXISTS (SELECT 1 FROM AD_TreeNodeMM p WHERE p.AD_Tree_ID=? AND p.Node_ID=d.Parent_ID)", (int)to_tree_id, (int)to_tree_id);
                int huGen = DB.getSQLValue((String)trxName, (String)"SELECT COUNT(*) FROM AD_TreeNode d WHERE d.AD_Tree_ID=? AND d.Parent_ID IS NOT NULL AND NOT EXISTS (SELECT 1 FROM AD_TreeNode p WHERE p.AD_Tree_ID=? AND p.Node_ID=d.Parent_ID)", (int)to_tree_id, (int)to_tree_id);
                resultMessage.append("Hu\u00e9rfanos MM=").append(huMM).append(", Gen=").append(huGen).append(". ");
            }
            DB.commit((boolean)true, (String)trxName);
            resultMessage.append("\nCopia completada con \u00e9xito hacia AD_Client_ID=").append(this.p_Dst_Client_ID);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Fallo general en copia de \u00e1rbol", (Throwable)e);
            DB.rollback((boolean)true, (String)trxName);
            errorMessage.append("Excepci\u00f3n: ").append(e.getMessage());
            return resultMessage.append("\n").append((CharSequence)errorMessage).toString();
        }
        return resultMessage.append("\n").append((CharSequence)errorMessage).toString();
    }

    private int detectRoleTreeId(int roleId) throws AdempiereUserError {
        MRole role = new MRole(this.getCtx(), roleId, this.get_TrxName());
        int id = role.getAD_Tree_Menu_ID();
        if (id <= 0) {
            throw new AdempiereUserError("El rol=" + roleId + " no tiene AD_Tree_Menu_ID.");
        }
        return id;
    }
}

