/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MTree;
import org.compiere.model.PO;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcess_CopyMenu
extends SvrProcess {
    private int p_Tree_ID;

    protected void prepare() {
        this.p_Tree_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        StringBuilder resultMessage = new StringBuilder("Resumen de inserciones:\n");
        StringBuilder errorMessage = new StringBuilder("Errores encontrados:\n");
        MTree tree = new MTree(this.getCtx(), this.p_Tree_ID, this.get_TrxName());
        if (tree.getDescription() == null) {
            return "Descripcion Vacia: descripcion debe tener nombre del nodo sin codigo de la compa\u00f1ia";
        }
        ArrayList<Integer> client_ids = new ArrayList<Integer>();
        String sqlClientIds = "SELECT ad_client_id FROM ad_client WHERE ad_client_id NOT IN (11, 0, ?)";
        try (CPreparedStatement pstmt = DB.prepareStatement((String)sqlClientIds, (String)this.get_TrxName());){
            pstmt.setInt(1, tree.getAD_Client_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                client_ids.add(rs.getInt("ad_client_id"));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error al obtener ad_client_id", (Throwable)e);
            return "Error al obtener ad_client_id: " + e.getMessage();
        }
        if (client_ids.isEmpty()) {
            return "No se encontraron ad_client_id para copiar.";
        }
        String trxName = this.get_TrxName();
        for (Integer Client_ID : client_ids) {
            try {
                String isekcopy;
                int to_tree_id;
                block26: {
                    to_tree_id = DB.getSQLValue((String)trxName, (String)"SELECT AD_Tree_ID FROM AD_Tree WHERE Description = ? AND AD_Client_ID = ?", (Object[])new Object[]{tree.getDescription(), Client_ID});
                    isekcopy = DB.getSQLValueString((String)trxName, (String)"SELECT isekcopy FROM ad_tree WHERE ad_tree_id = ? AND ad_client_id = ?", (Object[])new Object[]{to_tree_id, Client_ID});
                    String isdescription = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT 'Y' FROM ad_tree WHERE description is null and name = ? AND ad_client_id = ?", (Object[])new Object[]{tree.getName(), Client_ID});
                    if ("Y".equals(isdescription)) {
                        String cliente = DB.getSQLValueString((String)this.get_TrxName(), (String)"select name from ad_client where ad_client_id= ?", (int)Client_ID);
                        return "cliente " + cliente + " tiene \u00e1rbol con el mismo nombre, pero sin descripcion";
                    }
                    if (to_tree_id <= 0) {
                        String clientValue = DB.getSQLValueString((String)trxName, (String)"SELECT value FROM ad_client WHERE ad_client_id = ?", (int)tree.getAD_Client_ID());
                        String to_ClientValue = DB.getSQLValueString((String)trxName, (String)"SELECT value FROM ad_client WHERE ad_client_id = ?", (int)Client_ID);
                        String isdescription2 = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT 'Y' FROM ad_tree WHERE description is null and name = ? AND ad_client_id = ?", (Object[])new Object[]{tree.getName().replaceFirst("^" + clientValue, to_ClientValue), Client_ID});
                        if ("Y".equals(isdescription2)) {
                            String cliente = DB.getSQLValueString((String)this.get_TrxName(), (String)"select name from ad_client where ad_client_id= ?", (int)Client_ID);
                            return "cliente " + cliente + " tiene \u00e1rbol con el nombre " + tree.getName().replaceFirst("^" + clientValue, to_ClientValue) + ", pero sin descripcion, si no desea actualizar este menu, debe quitar check Copia Centralizado";
                        }
                        MTree to_tree = new MTree(this.getCtx(), 0, trxName);
                        PO.copyValues((PO)tree, (PO)to_tree);
                        to_tree.set_ValueOfColumn("AD_Client_ID", (Object)Client_ID);
                        String newTreeName = tree.getName().replaceFirst("^" + clientValue, to_ClientValue);
                        to_tree.setName(newTreeName);
                        to_tree.saveEx();
                        to_tree_id = to_tree.getAD_Tree_ID();
                        isekcopy = "Y";
                        resultMessage.append("Nuevo \u00e1rbol creado: " + newTreeName + " con AD_Tree_ID = " + to_tree_id + "->");
                        this.log.info("Nuevo \u00e1rbol creado: " + newTreeName + " con AD_Tree_ID = " + to_tree_id);
                    } else {
                        if ("Y".equals(isekcopy)) {
                            try {
                                String deleteSql = "DELETE FROM ad_treenodemm WHERE ad_tree_id = ?";
                                int rowsDeleted = DB.executeUpdate((String)deleteSql, (Object[])new Object[]{to_tree_id}, (boolean)false, (String)trxName);
                                this.log.info("Nodos eliminados en ad_treenodemm para AD_Tree_ID = " + to_tree_id + ": " + rowsDeleted);
                                break block26;
                            }
                            catch (Exception e) {
                                this.log.log(Level.SEVERE, "Error al eliminar nodos en ad_treenodemm para AD_Client_ID = " + Client_ID, (Throwable)e);
                                errorMessage.append("Error al eliminar nodos para AD_Client_ID = ").append(Client_ID).append(": ").append(e.getMessage()).append("\n");
                                continue;
                            }
                        }
                        this.log.info("El \u00e1rbol ya existe y `isekcopy` es 'N'. No se realiza la copia de nodos.");
                        continue;
                    }
                }
                if (!"Y".equals(isekcopy)) continue;
                String sql_node = "INSERT INTO ad_treenodemm (ad_tree_id, node_id, ad_client_id, ad_org_id, isactive, created, createdby, updated, updatedby, parent_id, seqno, uuid) SELECT ?, node_id, ?, 0, isactive, NOW(), ?, NOW(), ?, parent_id, seqno, gen_random_uuid() FROM ad_treenodemm WHERE ad_tree_id = ?";
                Object[] params = new Object[]{to_tree_id, Client_ID, Env.getAD_User_ID((Properties)this.getCtx()), Env.getAD_User_ID((Properties)this.getCtx()), tree.getAD_Tree_ID()};
                try {
                    int rowsInserted = DB.executeUpdate((String)sql_node, (Object[])params, (boolean)false, (String)trxName);
                    resultMessage.append("ad_treenodemm: ").append(rowsInserted).append(" registros insertados para AD_Client_ID = ").append(Client_ID).append(", \n");
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, "Error al insertar en ad_treenodemm", (Throwable)e);
                    errorMessage.append("Error en ad_treenodemm para AD_Client_ID = ").append(Client_ID).append(": ").append(e.getMessage()).append("\n");
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Error al copiar \u00e1rbol para AD_Client_ID = " + Client_ID, (Throwable)e);
                errorMessage.append("Error para AD_Client_ID = ").append(Client_ID).append(": ").append(e.getMessage()).append("\n");
            }
        }
        if (errorMessage.length() > "Errores encontrados:\n".length()) {
            DB.rollback((boolean)true, (String)trxName);
            resultMessage.append("\nRollback realizado debido a errores.");
        } else {
            DB.commit((boolean)true, (String)trxName);
            resultMessage.append("\nCopia completada con \u00e9xito para todos los clientes.");
        }
        return resultMessage.append("\n").append((CharSequence)errorMessage).toString();
    }
}

