/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MBPartner;
import org.compiere.model.MConversionRate;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.Query;
import org.compiere.process.InOutCreateInvoiceAbstract;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class EKProcessVoidInvoice
extends InOutCreateInvoiceAbstract {
    private int p_Invoice_ID = 0;

    protected void prepare() {
        this.p_Invoice_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        if (this.p_Invoice_ID == 0) {
            return null;
        }
        MInvoice inv = new MInvoice(this.getCtx(), this.p_Invoice_ID, this.get_TrxName());
        String getDoc = "";
        Object sql = "";
        boolean flag = false;
        int counter = 0;
        int i = 0;
        if (inv != null) {
            if (inv.getDocStatus().compareTo("VO") == 0) {
                return "Documento ya nulo";
            }
            getDoc = inv.getDocumentNo().concat("-VOID-");
            if (getDoc == null) {
                return null;
            }
            while (!flag) {
                sql = "SELECT count(1) from c_invoice where documentno like '%" + getDoc.concat(String.valueOf(i)) + "'";
                counter = DB.getSQLValue((String)this.get_TrxName(), (String)sql);
                this.log.config("counter " + counter);
                if (counter == 0) {
                    flag = true;
                    continue;
                }
                ++i;
            }
            if (inv.getDocStatus().compareTo("CO") != 0) {
                inv.processIt("VO");
                inv.setDocumentNo(getDoc.concat(String.valueOf(i)));
                inv.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
                inv.saveEx(this.get_TrxName());
                this.deleteTax(inv);
            } else if (inv.getDocStatus().compareTo("CO") == 0) {
                MInvoiceLine[] lines;
                for (MInvoiceLine line : lines = inv.getLines(false)) {
                    BigDecimal old = line.getQtyInvoiced();
                    if (old.compareTo(Env.ZERO) != 0 || line.getPriceActual().compareTo(Env.ZERO) != 0) {
                        line.setQty(Env.ZERO);
                        line.setPriceEntered(Env.ZERO);
                        line.setPriceActual(Env.ZERO);
                        line.setTaxAmt(Env.ZERO);
                        line.setLineNetAmt(Env.ZERO);
                        line.setLineTotalAmt(Env.ZERO);
                        line.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided") + " (" + String.valueOf(old) + ")");
                        if (line.getM_InOutLine_ID() != 0) {
                            MInOutLine ioLine = new MInOutLine(this.getCtx(), line.getM_InOutLine_ID(), this.get_TrxName());
                            ioLine.setIsInvoiced(false);
                            ioLine.save(this.get_TrxName());
                            line.setM_InOutLine_ID(0);
                        }
                        if (line.save(this.get_TrxName())) {
                            int orderLineID = line.getC_OrderLine_ID();
                            if (inv.getC_DocType().getDocBaseType().equals("ARC")) {
                                if (!inv.get_ValueAsString("AJ_CodRef").equals("1")) {
                                    orderLineID = 0;
                                } else if (orderLineID <= 0) {
                                    this.log.warning("Linea " + line.getLine() + " de la nota de credito no tiene linea de orden asociada.");
                                }
                            }
                            if (orderLineID > 0) {
                                this.returnQtyInvoiced(line, old, orderLineID);
                                this.deleteMatchInv(line);
                                this.deleteMatchPO(line);
                            }
                        }
                    }
                    this.deleteLandedCost(line);
                    this.deleteCostDetail(line);
                }
                inv.addDescription(Msg.getMsg((Properties)this.getCtx(), (String)"Voided"));
                inv.setIsPaid(true);
                inv.setC_Payment_ID(0);
                inv.setTotalLines(Env.ZERO);
                BigDecimal oldGrandTotal = inv.getGrandTotal();
                inv.setGrandTotal(Env.ZERO);
                inv.setProcessed(true);
                inv.setDocAction("--");
                inv.setDocStatus("VO");
                inv.setDocumentNo(getDoc.concat(String.valueOf(i)));
                if (inv.save()) {
                    this.deleteTax(inv);
                    this.deleteAcct(inv);
                    this.updateCreditBP(inv, oldGrandTotal);
                    this.voidAllocations(inv);
                }
            }
        }
        return "Documento anulado";
    }

    private void deleteTax(MInvoice inv) {
        String sql = "update c_invoicetax set taxamt=0 where c_invoice_id=" + inv.getC_Invoice_ID();
        DB.executeUpdate((String)sql, (String)inv.get_TrxName());
    }

    private int deleteAcct(MInvoice inv) {
        String sql = "DELETE Fact_Acct WHERE AD_Table_ID=" + inv.get_Table_ID() + " AND Record_ID=" + inv.get_ID();
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        if (no != 0) {
            this.log.info("deleted=" + no);
        }
        inv.setPosted(true);
        inv.saveEx();
        return no;
    }

    public void returnQtyInvoiced(MInvoiceLine il, BigDecimal qtyInvoiced, int orderLineID) {
        if (il.getC_Invoice().getC_DocType().getDocBaseType().contains("ARC") || il.getC_Invoice().getC_DocType().getDocBaseType().contains("APC")) {
            qtyInvoiced = qtyInvoiced.negate();
        }
        String sql = "update c_orderline set qtyinvoiced=qtyinvoiced-(?) where c_orderline_id=?";
        DB.executeUpdateEx((String)sql, (Object[])new Object[]{qtyInvoiced, orderLineID}, (String)il.get_TrxName());
    }

    public void deleteMatchInv(MInvoiceLine il) {
        String sqlAcct = "DELETE FROM Fact_Acct WHERE AD_Table_ID = (SELECT AD_Table_ID FROM AD_Table WHERE TableName='M_MatchInv') AND Record_ID IN (SELECT M_MatchInv_ID FROM M_MatchInv WHERE C_InvoiceLine_ID=?)";
        DB.executeUpdateEx((String)sqlAcct, (Object[])new Object[]{il.getC_InvoiceLine_ID()}, (String)il.get_TrxName());
        String sql = "DELETE FROM M_MatchInv WHERE C_InvoiceLine_ID=?";
        DB.executeUpdateEx((String)sql, (Object[])new Object[]{il.getC_InvoiceLine_ID()}, (String)il.get_TrxName());
    }

    private void deleteMatchPO(MInvoiceLine il) {
        String sql = "DELETE FROM m_matchpo WHERE c_invoiceline_id=?";
        DB.executeUpdateEx((String)sql, (Object[])new Object[]{il.getC_InvoiceLine_ID()}, (String)il.get_TrxName());
    }

    private void deleteCostDetail(MInvoiceLine line) {
        String sql = "DELETE FROM M_CostDetail WHERE c_invoiceline_id=?";
        DB.executeUpdateEx((String)sql, (Object[])new Object[]{line.getC_InvoiceLine_ID()}, (String)line.get_TrxName());
    }

    private void deleteLandedCost(MInvoiceLine line) {
        DB.executeUpdateEx((String)"DELETE FROM C_LandedCostAllocation WHERE C_InvoiceLine_ID = ?", (Object[])new Object[]{line.getC_InvoiceLine_ID()}, (String)line.get_TrxName());
        String sqlDeleteLC = "DELETE FROM C_LandedCost lc WHERE lc.C_InvoiceLine_ID = ? AND NOT EXISTS (   SELECT 1 FROM C_LandedCostAllocation lca   WHERE lca.C_InvoiceLine_ID = lc.C_InvoiceLine_ID)";
        int rows = DB.executeUpdateEx((String)sqlDeleteLC, (Object[])new Object[]{line.getC_InvoiceLine_ID()}, (String)line.get_TrxName());
        if (rows > 0) {
            this.log.info("Cabeceras C_LandedCost eliminadas: " + rows + "  (InvoiceLine=" + line.getC_InvoiceLine_ID() + ")");
        }
    }

    private void updateCreditBP(MInvoice inv, BigDecimal oldGrandTotal) {
        MBPartner partner = new MBPartner(this.getCtx(), inv.getC_BPartner_ID(), this.get_TrxName());
        BigDecimal invAmt = MConversionRate.convertBase(this.getCtx(), oldGrandTotal, inv.getC_Currency_ID(), inv.getDateAcct(), inv.getC_ConversionType_ID(), inv.getAD_Client_ID(), inv.getAD_Org_ID());
        BigDecimal newBalance = partner.getTotalOpenBalance(false);
        this.log.config("total Open Balance:" + String.valueOf(newBalance));
        if (newBalance == null) {
            newBalance = Env.ZERO;
        }
        if (inv.isSOTrx()) {
            boolean isCreditMemo = "ARC".equals(inv.getC_DocType().getDocBaseType());
            if (isCreditMemo) {
                newBalance = newBalance.add(invAmt);
                BigDecimal newLifeAmt = partner.getActualLifeTimeValue();
                if (newLifeAmt == null) {
                    newLifeAmt = Env.ZERO;
                }
                newLifeAmt = newLifeAmt.add(invAmt);
                BigDecimal newCreditAmt = partner.getSO_CreditUsed();
                if (newCreditAmt == null) {
                    newCreditAmt = Env.ZERO;
                }
                newCreditAmt = newCreditAmt.add(invAmt);
                partner.setActualLifeTimeValue(newLifeAmt);
                partner.setSO_CreditUsed(newCreditAmt);
            } else {
                newBalance = newBalance.subtract(invAmt);
                BigDecimal newLifeAmt = partner.getActualLifeTimeValue();
                newLifeAmt = newLifeAmt == null ? invAmt : newLifeAmt.subtract(invAmt);
                BigDecimal newCreditAmt = partner.getSO_CreditUsed();
                newCreditAmt = newCreditAmt == null ? invAmt : newCreditAmt.subtract(invAmt);
                partner.setActualLifeTimeValue(newLifeAmt);
                partner.setSO_CreditUsed(newCreditAmt);
            }
        } else {
            newBalance = newBalance.add(invAmt);
        }
        partner.setTotalOpenBalance(newBalance);
        partner.setSOCreditStatus();
        partner.saveEx();
    }

    private void voidAllocations(MInvoice inv) {
        List allocations = new Query(inv.getCtx(), "C_AllocationHdr", "C_AllocationHdr_ID IN (SELECT C_AllocationHdr_ID FROM C_AllocationLine WHERE C_Invoice_ID = ?)", inv.get_TrxName()).setParameters(new Object[]{inv.getC_Invoice_ID()}).list();
        for (MAllocationHdr alloc : allocations) {
            if (alloc.getDocStatus().equals("VO")) continue;
            alloc.processIt("VO");
            alloc.setDocAction("--");
            alloc.saveEx();
        }
    }
}

