/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class EKProcessUpdate_DocumentActionAccess
extends SvrProcess {
    private int p_Client_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("AD_Client_ID")) {
                this.p_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        StringBuilder sqlReturnBuilder = new StringBuilder();
        ArrayList<Integer> role_ids = new ArrayList<Integer>();
        String sqlRoleIds = "select AD_Role_ID from AD_Role where AD_Client_ID = ?";
        try (CPreparedStatement pstmt = DB.prepareStatement((String)sqlRoleIds, (String)this.get_TrxName());){
            pstmt.setInt(1, this.p_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                role_ids.add(rs.getInt("AD_Role_ID"));
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Error al obtener AD_Role_ID", (Throwable)e);
            return "Error al obtener AD_Role_ID: " + e.getMessage();
        }
        if (role_ids.isEmpty()) {
            return "No se encontraron ad_client_id para copiar.";
        }
        for (Integer Role_ID : role_ids) {
            try {
                DB.executeUpdate((String)"DELETE FROM AD_Document_Action_Access da \tWHERE da.AD_Role_ID = ?   AND NOT EXISTS (       SELECT 1       FROM (SELECT dt.name, MAX(dt.C_DocType_ID) AS max_doctype_id           \tFROM AD_Document_Action_Access da_inner JOIN C_DocType dt ON da_inner.C_DocType_ID = dt.C_DocType_ID           \tWHERE da_inner.AD_Role_ID = ? \t\t\t\tGROUP BY dt.name       ) AS keep_rows       WHERE da.C_DocType_ID = keep_rows.max_doctype_id);", (Object[])new Object[]{Role_ID, Role_ID}, (boolean)false, (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Error al borrar AD_PrintFormat", (Throwable)e);
                DB.rollback((boolean)true, (String)this.get_TrxName());
                return "Error al borrar AD_Document_Action_Access repetidos: " + e.getMessage();
            }
            String sql = "UPDATE adempiere.AD_Document_Action_Access da  SET C_DocType_ID = COALESCE((SELECT min(dt2.C_DocType_ID)  FROM adempiere.C_DocType dt  JOIN adempiere.C_DocType dt2 ON dt.Name = dt2.Name  LEFT JOIN adempiere.AD_Role ar ON da.AD_Role_ID = ar.AD_Role_ID  WHERE dt2.AD_Client_ID = ?  AND dt.C_DocType_ID <> dt2.C_DocType_ID   AND dt.C_DocType_ID = da.C_DocType_ID  AND ar.Name NOT ILIKE '%Administracion General%'), da.C_DocType_ID)  \tWHERE da.AD_Client_ID = ? and da.AD_Role_ID=?  and da.C_DocType_ID in(select max(dt2.C_DocType_ID) \t\t\t\t\t\t\tfrom AD_Document_Action_Access daa \t\t\t\t\t\t\tjoin C_DocType dt2 ON daa.C_DocType_ID=dt2.C_DocType_ID \t\t\t\t\t\t\twhere dt2.C_DocType_ID = daa.C_DocType_ID and daa.AD_Role_ID = da.AD_Role_ID \t\t\t\t\t\t\tgroup by dt2.Name,daa.AD_Role_ID,daa.AD_Ref_List_ID)";
            Object[] params = new Object[]{this.p_Client_ID, this.p_Client_ID, Role_ID};
            try {
                DB.executeUpdate((String)sql, (Object[])params, (boolean)false, (String)this.get_TrxName());
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
            }
        }
        return "AD_Document_Action_Access actualizadas";
    }
}

