/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MSysConfig;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessRefreshPrintFormats
extends SvrProcess {
    private static final String SC_TEMPLATE_CLIENT_ID = "TEMPLATE_CLIENT_ID";
    private int p_AD_PrintFormat_ID;

    protected void prepare() {
        this.p_AD_PrintFormat_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String trxName;
        if (this.p_AD_PrintFormat_ID <= 0) {
            return "No hay AD_PrintFormat seleccionado.";
        }
        Properties ctx = this.getCtx();
        MPrintFormat targetPF = new MPrintFormat(ctx, this.p_AD_PrintFormat_ID, trxName = this.get_TrxName());
        if (targetPF.getAD_PrintFormat_ID() <= 0) {
            return "No se pudo cargar el Formato de Impresi\u00f3n destino.";
        }
        if (!targetPF.get_ValueAsBoolean("IsEkCopy")) {
            return "Este formato no permite ser actualizado (IsEkCopy = N).";
        }
        String matchDesc = EKProcessRefreshPrintFormats.safeTrim(targetPF.getDescription());
        if (matchDesc == null || matchDesc.isEmpty()) {
            matchDesc = EKProcessRefreshPrintFormats.safeTrim(targetPF.getName());
        }
        if (matchDesc == null || matchDesc.isEmpty()) {
            return "El PrintFormat destino no tiene Descripci\u00f3n ni Nombre para emparejar.";
        }
        int templateClientId = MSysConfig.getIntValue((String)SC_TEMPLATE_CLIENT_ID, (int)0, (int)Env.getAD_Client_ID((Properties)ctx));
        if (templateClientId <= 0) {
            return "No hay SC_TEMPLATE_CLIENT_ID definido";
        }
        MPrintFormat templatePF = this.findTemplateByDescription(targetPF.getAD_Table_ID(), templateClientId, matchDesc, trxName);
        if (templatePF == null) {
            return "No se encontr\u00f3 en el cliente " + templateClientId + " un PrintFormat est\u00e1ndar con descripci\u00f3n (o nombre) = '" + matchDesc + "' para AD_Table_ID=" + targetPF.getAD_Table_ID() + ".";
        }
        if (templatePF.getAD_Table_ID() != targetPF.getAD_Table_ID()) {
            return "La plantilla no corresponde a la misma AD_Table_ID del destino.";
        }
        int deleted = DB.executeUpdateEx((String)"DELETE FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID=?", (Object[])new Object[]{targetPF.getAD_PrintFormat_ID()}, (String)trxName);
        this.log.info("Items borrados en destino: " + deleted);
        int inserted = this.copyItems(templatePF, targetPF, trxName);
        this.log.info("Items copiados desde plantilla: " + inserted);
        return "Formato actualizado desde cliente " + templateClientId + " por descripci\u00f3n='" + matchDesc + "'. Borrados: " + deleted + " | Insertados: " + inserted;
    }

    private static String safeTrim(String s) {
        return s == null ? null : s.trim();
    }

    private MPrintFormat findTemplateByDescription(int tableId, int clientId, String matchDesc, String trxName) {
        MPrintFormat pf = (MPrintFormat)new Query(this.getCtx(), "AD_PrintFormat", "AD_Client_ID=? AND AD_Table_ID=? AND IsActive='Y' AND COALESCE(Description,'') ILIKE ?", trxName).setParameters(new Object[]{clientId, tableId, "%" + matchDesc + "%"}).setOrderBy("IsDefault DESC, Updated DESC").first();
        if (pf != null) {
            return pf;
        }
        pf = (MPrintFormat)new Query(this.getCtx(), "AD_PrintFormat", "AD_Client_ID=? AND AD_Table_ID=? AND IsActive='Y' AND COALESCE(Name,'') ILIKE ?", trxName).setParameters(new Object[]{clientId, tableId, "%" + matchDesc + "%"}).setOrderBy("IsDefault DESC, Updated DESC").first();
        return pf;
    }

    private int copyItems(MPrintFormat templatePF, MPrintFormat targetPF, String trxName) throws Exception {
        int count = 0;
        String sql = "SELECT * FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID=? ORDER BY SeqNo";
        try (CPreparedStatement ps = DB.prepareStatement((String)"SELECT * FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID=? ORDER BY SeqNo", (String)trxName);){
            ps.setInt(1, templatePF.getAD_PrintFormat_ID());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    MPrintFormatItem src = new MPrintFormatItem(this.getCtx(), rs, trxName);
                    MPrintFormatItem dst = new MPrintFormatItem(this.getCtx(), 0, trxName);
                    PO.copyValues((PO)src, (PO)dst);
                    dst.setAD_PrintFormat_ID(targetPF.getAD_PrintFormat_ID());
                    dst.set_ValueOfColumn("AD_Client_ID", (Object)targetPF.getAD_Client_ID());
                    dst.setAD_Org_ID(targetPF.getAD_Org_ID());
                    dst.setIsActive(true);
                    if (dst.getSeqNo() <= 0) {
                        dst.setSeqNo(10000 + count);
                    }
                    dst.saveEx();
                    ++count;
                }
            }
        }
        return count;
    }
}

