/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MSysConfig;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessImportPrintFormats
extends SvrProcess {
    private static final String SC_TEMPLATE_CLIENT_ID = "TEMPLATE_CLIENT_ID";
    private Properties ctx;
    private String trxName;
    private int currentClientId;
    private int templateClientId;
    private String p_TablePrefix = "rj%";
    private int created = 0;
    private int updated = 0;
    private int skipped = 0;

    protected void prepare() {
        String sc;
        this.ctx = this.getCtx();
        this.trxName = this.get_TrxName();
        this.currentClientId = Env.getAD_Client_ID((Properties)this.ctx);
        this.p_TablePrefix = "rj%";
        ProcessInfoParameter[] params = this.getParameter();
        if (params != null) {
            block8: for (ProcessInfoParameter p : params) {
                String name = p.getParameterName();
                if (name == null) continue;
                switch (name) {
                    case "TablePrefix": {
                        if (p.getParameter() == null) continue block8;
                        this.p_TablePrefix = p.getParameter().toString().trim();
                        continue block8;
                    }
                }
            }
        }
        if ((sc = MSysConfig.getValue((String)SC_TEMPLATE_CLIENT_ID, (int)this.currentClientId)) == null || sc.trim().isEmpty()) {
            throw new AdempiereException("SysConfig TEMPLATE_CLIENT_ID no est\u00e1 definido.");
        }
        try {
            this.templateClientId = Integer.parseInt(sc.trim());
        }
        catch (Exception e) {
            throw new AdempiereException("SysConfig TEMPLATE_CLIENT_ID no es num\u00e9rico: " + sc);
        }
        if (this.templateClientId <= 0 || this.templateClientId == this.currentClientId) {
            throw new AdempiereException("Cliente plantilla inv\u00e1lido.");
        }
    }

    protected String doIt() throws Exception {
        String sqlSrc = "SELECT pf.AD_PrintFormat_ID, pf.Name, pf.Description, pf.AD_Table_ID, pf.AD_ReportView_ID,        pf.HeaderMargin, pf.FooterMargin, pf.AD_PrintColor_ID, pf.AD_PrintFont_ID,        pf.AD_PrintPaper_ID, t.TableName FROM AD_PrintFormat pf JOIN AD_Table t ON t.AD_Table_ID = pf.AD_Table_ID WHERE pf.AD_Client_ID=? AND pf.IsActive='Y' AND t.TableName ILIKE ? ORDER BY t.TableName, pf.Name";
        try (CPreparedStatement ps = DB.prepareStatement((String)sqlSrc, (String)this.trxName);){
            ps.setInt(1, this.templateClientId);
            ps.setString(2, this.p_TablePrefix);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int srcPFId = rs.getInt("AD_PrintFormat_ID");
                    int adTableId = rs.getInt("AD_Table_ID");
                    String name = rs.getString("Name");
                    String descr = rs.getString("Description");
                    Integer tgtPFId = this.findTargetByDescription(descr, adTableId);
                    if (tgtPFId <= 0) {
                        MPrintFormat to_pf = MPrintFormat.copyToClient((Properties)this.getCtx(), (int)srcPFId, (int)this.currentClientId);
                        to_pf.set_TrxName(this.trxName);
                        to_pf.set_ValueOfColumn("IsEkCopy", (Object)true);
                        to_pf.setName(name);
                        if (descr != null) {
                            to_pf.setDescription(descr);
                        }
                        to_pf.saveEx();
                        ++this.created;
                        this.addLog("Creado (auto-copy): " + to_pf.getName() + " [ID=" + to_pf.getAD_PrintFormat_ID() + "] tabla=" + rs.getString("TableName"));
                        continue;
                    }
                    if (tgtPFId > 0 && this.isEkCopy(tgtPFId)) {
                        MPrintFormat srcPF = new MPrintFormat(this.getCtx(), srcPFId, this.trxName);
                        MPrintFormat tgtPF = new MPrintFormat(this.getCtx(), tgtPFId.intValue(), this.trxName);
                        String keepName = tgtPF.getName();
                        DB.executeUpdate((String)"DELETE FROM AD_PrintFormatItem_Trl WHERE AD_PrintFormatItem_ID IN (SELECT AD_PrintFormatItem_ID FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID=?)", (int)tgtPFId, (boolean)false, (String)this.trxName);
                        DB.executeUpdate((String)"DELETE FROM AD_PrintFormatItem WHERE AD_PrintFormat_ID=?", (int)tgtPFId, (boolean)false, (String)this.trxName);
                        MPrintFormat.copy((Properties)this.getCtx(), (int)srcPFId, (int)tgtPFId);
                        tgtPF.set_ValueOfColumn("IsEkCopy", (Object)true);
                        if (descr != null) {
                            tgtPF.setDescription(descr);
                        }
                        tgtPF.saveEx(this.trxName);
                        ++this.updated;
                        this.addLog("Actualizado : " + keepName);
                        continue;
                    }
                    ++this.skipped;
                    this.addLog("Saltado: " + name + " (Description coincide pero IsEkCopy='N')");
                }
            }
        }
        return "Importaci\u00f3n por tabla '" + this.p_TablePrefix + "': " + this.created + " creados, " + this.updated + " actualizados, " + this.skipped + " saltados.";
    }

    private int findTargetByDescription(String descr, int adTableId) {
        if (descr == null) {
            String sqlNull = "SELECT AD_PrintFormat_ID FROM AD_PrintFormat WHERE AD_Client_ID=? AND AD_Table_ID=? AND Description IS NULL ORDER BY Updated DESC";
            int id = DB.getSQLValue((String)this.trxName, (String)"SELECT AD_PrintFormat_ID FROM AD_PrintFormat WHERE AD_Client_ID=? AND AD_Table_ID=? AND Description IS NULL ORDER BY Updated DESC", (int)this.currentClientId, (int)adTableId);
            return id > 0 ? id : 0;
        }
        String sql = "SELECT AD_PrintFormat_ID FROM AD_PrintFormat WHERE AD_Client_ID=? AND AD_Table_ID=? AND Description=? ORDER BY Updated DESC";
        int id = DB.getSQLValue((String)this.trxName, (String)"SELECT AD_PrintFormat_ID FROM AD_PrintFormat WHERE AD_Client_ID=? AND AD_Table_ID=? AND Description=? ORDER BY Updated DESC", (Object[])new Object[]{this.currentClientId, adTableId, descr});
        return id > 0 ? id : 0;
    }

    private boolean isEkCopy(int adPrintFormatId) {
        String sql = "SELECT COALESCE(IsEkCopy,'N') FROM AD_PrintFormat WHERE AD_PrintFormat_ID=?";
        String flag = DB.getSQLValueStringEx((String)this.trxName, (String)"SELECT COALESCE(IsEkCopy,'N') FROM AD_PrintFormat WHERE AD_PrintFormat_ID=?", (Object[])new Object[]{adPrintFormatId});
        return "Y".equalsIgnoreCase(flag);
    }
}

