/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.ajah.model.utils.fintoc.FintocAccount;
import org.ajah.model.utils.fintoc.FintocLink;
import org.ajah.model.utils.fintoc.FintocModel;
import org.ajah.model.utils.fintoc.FintocMovement;
import org.compiere.model.MBPartner;
import org.compiere.model.MBank;
import org.compiere.model.MBankAccount;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.Query;
import org.compiere.model.X_AJ_BankTransaction;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class EKProcessImportFintocTransaction
extends SvrProcess {
    private String apiKey;
    private int transactionQty = 30;

    protected void prepare() {
        ProcessInfoParameter[] parameters;
        this.apiKey = "sk_live_bKmFiomeUSjmC3SbFPHazYcUiqYQSxB8";
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            String name = para.getParameterName();
            if (para.getParameter() == null) continue;
            if (name.equals("FixedQty")) {
                this.transactionQty = para.getParameterAsInt();
                continue;
            }
            this.log.warning("Unknown parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        List bankList = new Query(this.getCtx(), "C_Bank", "IsActive='Y' AND AJ_FintocToken LIKE 'link_%'", this.get_TrxName()).list();
        int c = 0;
        for (MBank bank : bankList) {
            MClient client = new MClient(this.getCtx(), bank.getAD_Client_ID(), this.get_TrxName());
            int client_id = bank.getAD_Client_ID();
            String token = bank.get_ValueAsString("AJ_FintocToken");
            FintocModel fm = new FintocModel(token, this.apiKey);
            if (this.transactionQty > 0) {
                fm.setItemPerPage(this.transactionQty);
            }
            if (fm.getLinks() == null || fm.getLinks().isEmpty()) {
                this.log.warning("No se encontraron enlaces (links) en Fintoc.");
                return "No se encontraron enlaces en Fintoc.";
            }
            for (FintocLink link : fm.getLinks()) {
                if (link.getAccounts() == null || link.getAccounts().isEmpty()) {
                    this.log.warning("No se encontraron cuentas para el link: " + token + " (" + bank.getName() + "||" + client.getName() + ")");
                    continue;
                }
                block2: for (FintocAccount acc : link.getAccounts()) {
                    List<FintocMovement> movements = fm.getMovements(acc.getId());
                    if (movements == null || movements.isEmpty()) {
                        this.log.warning("No se encontraron movimientos para la " + acc.getName() + ":" + acc.getNumber() + " (" + bank.getName() + "||" + client.getName() + ")");
                        continue;
                    }
                    for (FintocMovement mov : movements) {
                        int mov_id = DB.getSQLValue((String)this.get_TrxName(), (String)"select max(AJ_BankTransaction_ID) from AJ_BankTransaction where aj_fintocid=?", (String)mov.getId());
                        if (mov_id > 0) continue;
                        X_AJ_BankTransaction bt = new X_AJ_BankTransaction(bank.getCtx(), 0, bank.get_TrxName());
                        bt.setAD_Org_ID(bank.getAD_Org_ID());
                        bt.setAJ_FintocID(mov.getId());
                        BigDecimal amt = new BigDecimal(mov.getAmount());
                        if (mov.getCurrency().equals("USD")) {
                            amt = amt.divide(new BigDecimal(100));
                        }
                        bt.setAmt(amt);
                        bt.setDescription(mov.getDescription());
                        bt.setType(mov.getType());
                        bt.setBankName(link.getInstitution().getName());
                        bt.setAccount(acc.getNumber());
                        bt.setAccountName(acc.getName());
                        bt.setAJ_Country(link.getInstitution().getCountry().toUpperCase());
                        bt.setISO_Code(mov.getCurrency());
                        bt.setIsReceipt(mov.getAmount() > 0.0);
                        if (mov.getTransactionDate() != null) {
                            bt.setDateTrx(Timestamp.valueOf(mov.getTransactionDate()));
                        }
                        bt.setDateAcct(Timestamp.valueOf(mov.getPostDate()));
                        bt.setAJ_FintocID(mov.getId());
                        bt.setReferenceNo(mov.getReferenceId());
                        bt.setComments(mov.getComment());
                        bt.setAJ_DocNo(mov.getHolderAccount().getHolderId());
                        if (bt.getAJ_DocNo() != null) {
                            String input = bt.getAJ_DocNo();
                            String rut = input.substring(0, input.length() - 1) + "-" + input.substring(input.length() - 1).toUpperCase();
                            MBPartner bp = (MBPartner)new Query(this.getCtx(), "C_BPartner", "ad_client_id=? and upper(value)=?", this.get_TrxName()).setParameters(new Object[]{bank.getAD_Client_ID(), rut}).first();
                            if (bp != null) {
                                bt.setC_BPartner_ID(bp.getC_BPartner_ID());
                            }
                        }
                        if (bt.getAccount() != null) {
                            MBankAccount ba = (MBankAccount)new Query(this.getCtx(), "C_BankAccount", "BBAN like ?", this.get_TrxName()).setParameters(new Object[]{bt.getAccount()}).first();
                            if (ba != null) {
                                bt.setC_BankAccount_ID(ba.getC_BankAccount_ID());
                                bt.setC_Bank_ID(ba.getC_Bank_ID());
                            } else {
                                this.log.warning(acc.getName() + " " + bank.getName() + " N\u00b0:" + bt.getAccount() + " de Empresa " + client.getName() + " no encontrada en el sistema. Revise nombre BBAN");
                                continue block2;
                            }
                        }
                        if (bt.getISO_Code() != null) {
                            bt.setC_Currency_ID(MCurrency.get((Properties)this.getCtx(), (String)bt.getISO_Code()).getC_Currency_ID());
                        }
                        if (!bt.save()) continue;
                        ++c;
                        DB.executeUpdate((String)("update AJ_BankTransaction set ad_client_id=" + bank.getAD_Client_ID() + " where AJ_BankTransaction_id=" + bt.getAJ_BankTransaction_ID()), (String)this.get_TrxName());
                    }
                }
            }
        }
        return "Se importaron " + c + " movimientos.";
    }
}

