/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import dteboxcliente.GrupoBusqueda;
import dteboxcliente.ResultadoDocumentos;
import dteboxcliente.ResumenDTE;
import dteboxcliente.Servicio;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.process.SvrProcess;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EKProcessGDExpressGetPDF
extends SvrProcess {
    private int p_c_invoice_id;
    private String ambiente = "";
    private String serverHostName = "";

    protected void prepare() {
        this.p_c_invoice_id = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MInvoice inv = new MInvoice(this.getCtx(), this.p_c_invoice_id, this.get_TrxName());
        MOrg org = new MOrg(this.getCtx(), inv.getAD_Org_ID(), this.get_TrxName());
        MDocType docType = new MDocType(this.getCtx(), inv.getC_DocTypeTarget_ID(), this.get_TrxName());
        this.ambiente = org.get_ValueAsString("AJ_DTEBoxEnvironment");
        InetAddress ip = InetAddress.getLocalHost();
        this.serverHostName = ip.getHostName();
        String estado = this.getPDFUrl(inv, org, docType);
        return estado;
    }

    private boolean createPDF(byte[] pdf, String exportDir, String nameFile) throws Exception {
        try {
            String filePath = exportDir + nameFile + ".pdf";
            FileOutputStream out = new FileOutputStream(filePath);
            ((OutputStream)out).write(pdf);
            ((OutputStream)out).close();
            Path path = Paths.get(filePath, new String[0]);
            Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
            Files.setPosixFilePermissions(path, permissions);
            return true;
        }
        catch (Exception e) {
            throw new Exception("Error:" + String.valueOf(e));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getPDFUrl(MInvoice inv, MOrg org, MDocType docType) {
        int pageSize;
        String folio;
        String rutEmisor;
        String apiURL = "http://200.6.96.14/api/Core.svc/Core";
        String apiAuth = "a497c198-a553-4ad0-8576-3cd227dc2f57";
        Servicio servicio = new Servicio(apiURL, apiAuth);
        GrupoBusqueda grupo = GrupoBusqueda.Emitidos;
        String DTE = docType.get_ValueAsString("EK_SIICode");
        String consulta = "(TipoDTE:" + DTE + " AND RUTEmisor:" + (rutEmisor = org.get_ValueAsString("EK_Value")) + " AND Folio:" + (folio = inv.getDocumentNo()) + ")";
        ResultadoDocumentos resultado = servicio.BuscarDocumentos(this.ambiente, grupo, consulta, 0, pageSize = 10);
        if (resultado.getResultadoServicio().getEstado() != 0) {
            String error = resultado.getResultadoServicio().getDescripcion();
            resultado.getResultadoServicio().getExcepcionOriginal().printStackTrace();
            throw new AdempiereException(error);
        }
        if (resultado.getTotalDocumentos() <= 0) {
            inv.set_CustomColumn("EK_URLXML", "No esta presente la URL del PDF.");
            inv.saveEx(this.get_TrxName());
            return "No esta presente la URL del PDF.";
        }
        int pages = resultado.getTotalPages();
        int page = 0;
        int count = 0;
        do {
            System.out.println("P\u00e1gina: " + page);
            System.out.println("-------------------------------------------------------");
            for (ResumenDTE doc : resultado.getDocumentos()) {
                folio = "";
                rutEmisor = "";
                if (doc != null) {
                    folio = String.valueOf(doc.Folio);
                    rutEmisor = doc.RUTEmisor;
                }
                System.out.println(count++ + " - " + folio + " - " + rutEmisor);
            }
            inv.set_CustomColumn("EK_URLXML", this.getXMLTag(resultado.getXml(), "DownloadCustomerDocumentUrl"));
            inv.saveEx(this.get_TrxName());
            if (++page < pages) {
                resultado = servicio.BuscarDocumentos(this.ambiente, grupo, consulta, page, pageSize);
            }
            if (page >= pages) return "Se obtiene url del PDF";
        } while (resultado.getResultadoServicio().getEstado() == 0);
        return "Se obtiene url del PDF";
    }

    private String getXMLTag(String xmlString, String tagName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xmlString)));
            NodeList nodeList = document.getElementsByTagName(tagName);
            if (nodeList.getLength() > 0) {
                Element element = (Element)nodeList.item(0);
                String tagContent = element.getTextContent();
                return tagContent;
            }
            return "El tag " + tagName + " no se encontr\u00f3 en el XML.";
        }
        catch (Exception e) {
            throw new AdempiereException("Error al obtener tag " + tagName + ": " + e.toString());
        }
    }
}

