/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import DocumentoDTE.SiiDte.CampoStringA;
import DocumentoDTE.SiiDte.CdgItem;
import DocumentoDTE.SiiDte.DTEDefType;
import DocumentoDTE.SiiDte.DTEType;
import DocumentoDTE.SiiDte.DTE_Choice;
import DocumentoDTE.SiiDte.Detalle;
import DocumentoDTE.SiiDte.DocPersonalizadoA;
import DocumentoDTE.SiiDte.Documento;
import DocumentoDTE.SiiDte.Emisor;
import DocumentoDTE.SiiDte.Encabezado;
import DocumentoDTE.SiiDte.IdDoc;
import DocumentoDTE.SiiDte.IdDoc_IndTraslado;
import DocumentoDTE.SiiDte.IdDoc_TipoDespacho;
import DocumentoDTE.SiiDte.PersonalizadosA;
import DocumentoDTE.SiiDte.Receptor;
import DocumentoDTE.SiiDte.Totales;
import com.liquid_technologies.ltxmllib12.DateTime;
import com.liquid_technologies.ltxmllib12.DateTimeType;
import dteboxcliente.ResultadoEnvioDocumento;
import dteboxcliente.Servicio;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MCity;
import org.compiere.model.MDocType;
import org.compiere.model.MMovement;
import org.compiere.model.MMovementLine;
import org.compiere.model.MOrg;
import org.compiere.model.MSysConfig;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.Env;

public class EKProcessGDExpressDTEMovement
extends SvrProcess {
    private Properties m_ctx;
    private int p_M_Movement_ID = 0;
    public String urlPdf = "";
    private String apiURL = "";
    private String apiAuth = "";
    private String ambiente;

    protected void prepare() {
        this.p_M_Movement_ID = this.getRecord_ID();
        this.m_ctx = Env.getCtx();
    }

    protected String doIt() throws Exception {
        MMovement mov = new MMovement(this.m_ctx, this.p_M_Movement_ID, this.get_TrxName());
        MOrg org = new MOrg(this.getCtx(), mov.getAD_Org_ID(), this.get_TrxName());
        String msg = "";
        this.apiURL = MSysConfig.getValue((String)"DTEBoxServer", (String)"http://200.6.96.14/api/Core.svc/Core");
        this.apiAuth = MSysConfig.getValue((String)"DTEBoxPass", (String)"a497c198-a553-4ad0-8576-3cd227dc2f57");
        this.ambiente = org.get_ValueAsString("AJ_DTEBoxEnvironment");
        msg = this.CreateXML(mov);
        return msg;
    }

    public String CreateXML(MMovement mov) {
        String error = "";
        String ted = "";
        String pdf417 = "";
        try {
            DTEDefType dte = new DTEDefType();
            dte.setDTE_Choice(new DTE_Choice());
            MOrg org = MOrg.get((Properties)mov.getCtx(), (int)mov.getAD_Org_ID());
            MDocType docType = new MDocType(mov.getCtx(), mov.getC_DocType_ID(), mov.get_TrxName());
            dte.getDTE_Choice().setDocumento(new Documento());
            Documento doc = dte.getDTE_Choice().getDocumento();
            doc.setEncabezado(new Encabezado());
            IdDoc idDoc = new IdDoc();
            if (docType.get_ValueAsString("EK_SIICode").compareTo("33") == 0) {
                idDoc.setTipoDTE(DTEType.n33);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("34") == 0) {
                idDoc.setTipoDTE(DTEType.n34);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("56") == 0) {
                idDoc.setTipoDTE(DTEType.n56);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("61") == 0) {
                idDoc.setTipoDTE(DTEType.n61);
            } else if (docType.get_ValueAsString("EK_SIICode").compareTo("52") == 0) {
                idDoc.setTipoDTE(DTEType.n52);
            } else {
                throw new AdempiereException("Codigo SII no presente en tipo de documento");
            }
            idDoc.setFolio(BigInteger.valueOf(Integer.parseInt(mov.getDocumentNo())));
            idDoc.setFchEmis(new DateTime(DateTimeType.date, this.ConverDateToString(mov.getMovementDate())));
            boolean isBPSet = mov.getC_BPartner_ID() > 0;
            IdDoc_IndTraslado indTraslado = IdDoc_IndTraslado.n5;
            if (isBPSet) {
                indTraslado = IdDoc_IndTraslado.n6;
            }
            idDoc.setTipoDespacho(IdDoc_TipoDespacho.n2);
            idDoc.setIndTraslado(indTraslado);
            doc.getEncabezado().setIdDoc(idDoc);
            Emisor emisor = new Emisor();
            emisor.setRUTEmisor((String)org.get_Value("EK_Value"));
            String nameRzn = org.getDescription();
            if (nameRzn == null) {
                nameRzn = " ";
            }
            if ((nameRzn = nameRzn.trim()).length() < 2) {
                nameRzn = org.getName();
            }
            emisor.setRznSoc(nameRzn);
            String giroEmisStr = (String)org.get_Value("EK_BusinessType");
            giroEmisStr = giroEmisStr.replace("'", "");
            giroEmisStr = giroEmisStr.replace("\"", "");
            emisor.setGiroEmis(giroEmisStr);
            emisor.getActeco().add(BigInteger.valueOf(Integer.parseInt((String)org.get_Value("EK_EconomicActivityCode"))));
            emisor.setDirOrigen((String)org.get_Value("EK_Address"));
            emisor.setCmnaOrigen((String)org.get_Value("EK_Commune"));
            emisor.setCiudadOrigen((String)org.get_Value("EK_City"));
            if (mov.getSalesRep_ID() > 0) {
                emisor.setCdgVendedor(mov.getSalesRep().getName());
            }
            doc.getEncabezado().setEmisor(emisor);
            String rutRecep = (String)org.get_Value("EK_Value");
            String RznSocRecepStr = nameRzn;
            String dirRecepStr = (String)org.get_Value("EK_Address");
            String strContacto = mov.getSalesRep().getName();
            String CmnaRecepStr = (String)org.get_Value("EK_Commune");
            String ciudadTxt = (String)org.get_Value("EK_City");
            String giroRecep = (String)org.get_Value("EK_BusinessType");
            if (isBPSet) {
                if (mov.getC_BPartner_Location_ID() <= 0) {
                    throw new AdempiereUserError("Socio sin direccion de referencia definida.");
                }
                MBPartner BP = new MBPartner(mov.getCtx(), mov.getC_BPartner_ID(), mov.get_TrxName());
                MBPartnerLocation bloc = new MBPartnerLocation(mov.getCtx(), mov.getC_BPartner_Location_ID(), mov.get_TrxName());
                rutRecep = BP.getValue();
                RznSocRecepStr = BP.getName();
                dirRecepStr = bloc.get_ValueAsString("Address1");
                strContacto = bloc.get_ValueAsString("Phone");
                if (bloc.get_ValueAsInt("C_City_ID") > 0) {
                    MCity dCity = new MCity(mov.getCtx(), bloc.get_ValueAsInt("C_City_ID"), mov.get_TrxName());
                    CmnaRecepStr = dCity.getName();
                }
                ciudadTxt = CmnaRecepStr;
                int regionId = bloc.get_ValueAsInt("C_Region_ID");
                if (regionId == 1000002) {
                    ciudadTxt = "Santiago";
                }
                giroRecep = BP.get_Value("EK_BusinessType") != null ? (String)BP.get_Value("EK_BusinessType") : "";
            }
            Receptor receptor = new Receptor();
            receptor.setRUTRecep(rutRecep);
            receptor.setRznSocRecep(RznSocRecepStr);
            RznSocRecepStr = RznSocRecepStr.replace("'", "");
            RznSocRecepStr = RznSocRecepStr.replace("\"", "");
            receptor.setRznSocRecep(RznSocRecepStr);
            dirRecepStr = dirRecepStr.replace("'", "");
            dirRecepStr = dirRecepStr.replace("\"", "");
            receptor.setDirRecep(dirRecepStr);
            receptor.setCmnaRecep(CmnaRecepStr);
            receptor.setCiudadRecep(ciudadTxt != null ? ciudadTxt : "Santiago");
            receptor.setGiroRecep(giroRecep);
            receptor.setContacto(strContacto);
            doc.getEncabezado().setReceptor(receptor);
            Totales totales = new Totales();
            totales.setMntTotal(new BigInteger("1"));
            totales.setMntNeto(new BigInteger("1"));
            totales.setIVA(new BigInteger("0"));
            doc.getEncabezado().setTotales(totales);
            MMovementLine[] mLines = mov.getLines(false);
            int lineInvoice = 0;
            boolean lineDiscount = false;
            for (int i = 0; i < mLines.length; ++i) {
                MMovementLine mLine = mLines[i];
                if (mLine.getM_Product_ID() <= 0) continue;
                ++lineInvoice;
                Detalle det = new Detalle();
                CdgItem cdgItem = new CdgItem();
                cdgItem.setTpoCodigo("INT1");
                cdgItem.setVlrCodigo(mLine.getProduct().getValue());
                det.getCdgItem().add(cdgItem);
                det.setNroLinDet(BigInteger.valueOf(lineInvoice));
                String pname = "";
                pname = mLine.getProduct().getName();
                pname = pname.replace("'", "");
                pname = pname.replace("\"", "");
                det.setNmbItem(pname);
                det.setQtyItem(mLine.getMovementQty());
                det.setPrcItem(Env.ONE);
                det.setMontoItem(new BigInteger("1"));
                det.setDscItem(mLine.getDescription() == null ? " " : mLine.getDescription());
                String unmdItemStr = "";
                unmdItemStr = mLine.getM_Product_ID() > 0 ? mLine.getM_Product().getC_UOM().getUOMSymbol() : "UN";
                if (unmdItemStr == null) {
                    unmdItemStr = "UN";
                }
                det.setUnmdItem(unmdItemStr);
                doc.getDetalle().add(det);
            }
            PersonalizadosA personalizados = new PersonalizadosA();
            dte.setPersonalizados(personalizados);
            if (mov.getDescription() != null) {
                personalizados.setDocPersonalizado(new DocPersonalizadoA());
                CampoStringA campoString = new CampoStringA();
                campoString.setName("Notas");
                campoString.setPrimitiveValue(mov.getDescription());
                personalizados.getDocPersonalizado().getCampoString().add(campoString);
            }
            String fechaResolucion = "2014-08-22";
            int numeroResolucion = 80;
            int tipoPdf417 = 1;
            Servicio servicio = new Servicio(this.apiURL, this.apiAuth);
            ResultadoEnvioDocumento resultado = servicio.EnviarDocumento(dte, this.ambiente, fechaResolucion, numeroResolucion, tipoPdf417);
            dte.toXml();
            this.log.config("dte " + dte.toXml());
            this.log.config("resultado " + resultado.getResultadoServicio().getEstado());
            if (resultado.getResultadoServicio().getEstado() == 0) {
                ted = resultado.getTED();
                pdf417 = resultado.getPDF417();
                error = "DTE Enviado con Exito";
            } else {
                error = resultado.getResultadoServicio().getDescripcion();
            }
            mov.set_CustomColumn("AJ_DescriptionGDE", (Object)error);
            mov.saveEx(mov.get_TrxName());
        }
        catch (Exception e) {
            this.log.config(e.toString());
            error = e.toString();
        }
        return "Procesado " + error + " - " + ted + " - " + pdf417;
    }

    public String ConverDateToString(Timestamp fecha) {
        Object dateReturn = "";
        this.log.config("month" + fecha.getMonth() + "1");
        this.log.config("day" + fecha.getDate());
        int month = fecha.getMonth() + 1;
        int day = fecha.getDate();
        dateReturn = fecha.getMonth() + 1 < 10 && fecha.getDate() < 10 ? fecha.getYear() + 1900 + "-0" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : (fecha.getMonth() + 1 < 10 && fecha.getDate() >= 10 ? fecha.getYear() + 1900 + "-0" + (fecha.getMonth() + 1) + "-" + fecha.getDate() : (fecha.getMonth() + 1 >= 10 && fecha.getDate() < 10 ? fecha.getYear() + 1900 + "-" + (fecha.getMonth() + 1) + "-0" + fecha.getDate() : fecha.getYear() + 1900 + "-" + (fecha.getMonth() + 1) + "-" + fecha.getDate()));
        return dateReturn;
    }
}

