/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessFixIPaymentFromShopifyDirect
extends SvrProcess {
    private int p_AD_Client_ID = 0;

    protected void prepare() {
        for (ProcessInfoParameter p : this.getParameter()) {
            if (p == null || p.getParameterName() == null || !"AD_Client_ID".equalsIgnoreCase(p.getParameterName()) || p.getParameter() == null) continue;
            this.p_AD_Client_ID = ((Number)p.getParameter()).intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doIt() throws Exception {
        int clientId;
        String trxName = this.get_TrxName();
        int userId = this.getAD_User_ID();
        int n = clientId = this.p_AD_Client_ID > 0 ? this.p_AD_Client_ID : Env.getAD_Client_ID((Properties)this.getCtx());
        if (clientId <= 0) {
            String msg = "No Hay AD_Client_ID. No se realizaron cambios.";
            this.addLog(msg);
            return msg;
        }
        int scanned = 0;
        int matched = 0;
        int updated = 0;
        int skipped = 0;
        int errors = 0;
        String sqlSelect = "WITH inv_choice AS (   SELECT o.c_order_id, i.c_invoice_id, i.documentno AS invoice_documentno,          row_number() OVER (PARTITION BY o.c_order_id ORDER BY i.dateinvoiced ASC, i.c_invoice_id ASC) AS rn   FROM adempiere.c_order o   JOIN adempiere.c_invoice i ON i.c_order_id = o.c_order_id   WHERE o.ad_client_id = ?     AND i.docstatus IN ('CO','CL')     AND i.isactive = 'Y' ) SELECT ip.i_payment_id,        ip.invoicedocumentno AS current_invoicedocumentno,        ip.bpartnervalue     AS current_bpartnervalue,        ic.invoice_documentno AS new_invoicedocumentno,        bp.value              AS new_bpartnervalue FROM adempiere.i_payment ip JOIN adempiere.c_order o   ON UPPER(BTRIM(o.ajc_shopifypayment)) = UPPER(BTRIM(ip.invoicedocumentno)) JOIN inv_choice ic ON ic.c_order_id = o.c_order_id AND ic.rn = 1 JOIN adempiere.c_bpartner bp ON bp.c_bpartner_id = o.c_bpartner_id WHERE ip.ad_client_id = ?   AND ip.invoicedocumentno IS NOT NULL   AND ip.isactive = 'Y'";
        String sqlUpdate = "UPDATE adempiere.i_payment    SET invoicedocumentno = ?,        bpartnervalue     = ?,        updated           = now(),        updatedby         = ?  WHERE i_payment_id      = ?";
        CPreparedStatement psSel = null;
        CPreparedStatement psUpd = null;
        ResultSet rs = null;
        try {
            psSel = DB.prepareStatement((String)"WITH inv_choice AS (   SELECT o.c_order_id, i.c_invoice_id, i.documentno AS invoice_documentno,          row_number() OVER (PARTITION BY o.c_order_id ORDER BY i.dateinvoiced ASC, i.c_invoice_id ASC) AS rn   FROM adempiere.c_order o   JOIN adempiere.c_invoice i ON i.c_order_id = o.c_order_id   WHERE o.ad_client_id = ?     AND i.docstatus IN ('CO','CL')     AND i.isactive = 'Y' ) SELECT ip.i_payment_id,        ip.invoicedocumentno AS current_invoicedocumentno,        ip.bpartnervalue     AS current_bpartnervalue,        ic.invoice_documentno AS new_invoicedocumentno,        bp.value              AS new_bpartnervalue FROM adempiere.i_payment ip JOIN adempiere.c_order o   ON UPPER(BTRIM(o.ajc_shopifypayment)) = UPPER(BTRIM(ip.invoicedocumentno)) JOIN inv_choice ic ON ic.c_order_id = o.c_order_id AND ic.rn = 1 JOIN adempiere.c_bpartner bp ON bp.c_bpartner_id = o.c_bpartner_id WHERE ip.ad_client_id = ?   AND ip.invoicedocumentno IS NOT NULL   AND ip.isactive = 'Y'", (String)trxName);
            psSel.setInt(1, clientId);
            psSel.setInt(2, clientId);
            rs = psSel.executeQuery();
            psUpd = DB.prepareStatement((String)"UPDATE adempiere.i_payment    SET invoicedocumentno = ?,        bpartnervalue     = ?,        updated           = now(),        updatedby         = ?  WHERE i_payment_id      = ?", (String)trxName);
            while (rs.next()) {
                boolean changeBP;
                ++scanned;
                int iPaymentId = rs.getInt("i_payment_id");
                String curDocNo = rs.getString("current_invoicedocumentno");
                String curBPVal = rs.getString("current_bpartnervalue");
                String newDocNo = rs.getString("new_invoicedocumentno");
                String newBPVal = rs.getString("new_bpartnervalue");
                ++matched;
                boolean changeDoc = !EKProcessFixIPaymentFromShopifyDirect.equalsNullSafe(curDocNo, newDocNo);
                boolean bl = changeBP = !EKProcessFixIPaymentFromShopifyDirect.equalsNullSafe(curBPVal, newBPVal);
                if (!changeDoc && !changeBP) {
                    ++skipped;
                    continue;
                }
                try {
                    if (newDocNo == null) {
                        psUpd.setNull(1, 12);
                    } else {
                        psUpd.setString(1, newDocNo);
                    }
                    if (newBPVal == null) {
                        psUpd.setNull(2, 12);
                    } else {
                        psUpd.setString(2, newBPVal);
                    }
                    psUpd.setInt(3, userId);
                    psUpd.setInt(4, iPaymentId);
                    int n2 = psUpd.executeUpdate();
                    if (n2 > 0) {
                        updated += n2;
                        continue;
                    }
                    ++skipped;
                }
                catch (Exception rowEx) {
                    ++errors;
                    this.addLog("Error actualizando I_Payment_ID=" + iPaymentId + " \u2192 " + rowEx.getMessage());
                    this.log.warning("Error I_Payment_ID=" + iPaymentId + ": " + rowEx.getMessage());
                }
            }
        }
        catch (Exception e) {
            try {
                ++errors;
                this.addLog("Excepci\u00f3n general en el proceso: " + e.getMessage());
                this.log.severe("EXC general: " + e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)psSel);
                DB.close(psUpd);
                rs = null;
                psSel = null;
                psUpd = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)psSel);
            DB.close((Statement)psUpd);
            rs = null;
            psSel = null;
            psUpd = null;
        }
        DB.close((ResultSet)rs, (Statement)psSel);
        DB.close((Statement)psUpd);
        rs = null;
        psSel = null;
        psUpd = null;
        String summary = "Escaneados=" + scanned + " | Coincidencias=" + matched + " | Actualizados=" + updated + " | Sin cambio=" + skipped + " | Errores=" + errors;
        this.addLog(summary);
        return summary;
    }

    private static boolean equalsNullSafe(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

