/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import org.ajah.process.ProductionMaterialAdjuster;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKProcessCreateProductionOrder
extends SvrProcess {
    private int p_C_OrderLine_ID;
    private int p_M_Locator_ID;

    protected void prepare() {
        ProcessInfoParameter[] paras;
        for (ProcessInfoParameter para : paras = this.getParameter()) {
            if (!para.getParameterName().equals("M_Locator_ID")) continue;
            this.p_M_Locator_ID = para.getParameterAsInt();
        }
        this.p_C_OrderLine_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        MOrderLine ol = new MOrderLine(this.getCtx(), this.p_C_OrderLine_ID, this.get_TrxName());
        if (ol.getM_Product_ID() == 0) {
            throw new AdempiereUserError("No hay producto a producir", "Ingrese un producto en la linea para generar orden de produccion");
        }
        if (!ol.getM_Product().isBOM()) {
            throw new AdempiereUserError("Producto sin lista de materiales", "Ingrese un producto con lista de materiales para producir");
        }
        int p_id = DB.getSQLValue((String)this.get_TrxName(), (String)("select coalesce(M_Production_ID,0) from M_Production where docstatus not in ('VO','RE') and C_OrderLine_ID=" + ol.getC_OrderLine_ID()));
        if (p_id > 0) {
            return "Ya existe orden de produccion para esta linea.(M_Production_ID=" + p_id + ").";
        }
        MProduction p = new MProduction(ol);
        p.setName("Creado desde NV " + p.getC_OrderLine().getC_Order().getDocumentNo());
        if (this.p_M_Locator_ID > 0) {
            p.setM_Locator_ID(this.p_M_Locator_ID);
            p.set_CustomColumn("AJC_Designs_ID", ol.get_Value("AJC_Designs_ID"));
        }
        if (p.save()) {
            Timestamp createdTS = DB.getSQLValueTSEx((String)this.get_TrxName(), (String)"SELECT Created FROM M_Production WHERE M_Production_ID = ?", (Object[])new Object[]{p.getM_Production_ID()});
            p.setMovementDate(createdTS);
            p.saveEx();
            p.prepareIt();
            for (MProductionLine prodLine : p.getLines()) {
                if (ol.getM_AttributeSetInstance_ID() > 0 && prodLine.isEndProduct()) {
                    prodLine.setM_AttributeSetInstance_ID(ol.getM_AttributeSetInstance_ID());
                    prodLine.setDescription(ol.getDescription());
                    String helpText = (String)ol.get_Value("Help");
                    if (helpText != null && !helpText.trim().isEmpty()) {
                        prodLine.set_ValueOfColumn("Help", helpText);
                    }
                }
                prodLine.saveEx();
            }
            this.assetAllocation(p);
            this.assignPriority(p);
            try {
                boolean isClientAllowed;
                boolean isFromOrderLine = p.get_ValueAsInt("C_OrderLine_ID") > 0;
                boolean bl = isClientAllowed = p.getAD_Client_ID() == 1000070;
                if (isFromOrderLine && isClientAllowed) {
                    String summary = ProductionMaterialAdjuster.apply(this.getCtx(), p.getM_Production_ID(), this.get_TrxName(), "Cambiar Cono", 1000036, Env.ZERO, false);
                    this.addLog("Ajuste materiales: " + summary);
                }
            }
            catch (Exception e) {
                this.addLog("Error en ajuste de materiales: " + e.getMessage());
                this.log.warning(e.getMessage());
            }
            return "Se genera Produccion N\u00b0" + p.getDocumentNo();
        }
        return "No se genera Orden de Produccion. " + p.getProcessMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assetAllocation(MProduction p) {
        int categoryID = p.getM_Product().getM_Product_Category_ID();
        String sql = "SELECT ap.a_asset_id, COUNT(mp.m_production_id) AS prod_count, MAX(a.created) AS created FROM a_asset_product ap JOIN a_asset a ON ap.a_asset_id = a.a_asset_id LEFT JOIN m_production mp ON mp.a_asset_id = a.a_asset_id WHERE ap.m_product_category_id = ? GROUP BY ap.a_asset_id, a.created";
        int selectedAssetID = 0;
        long minProductions = Long.MAX_VALUE;
        Timestamp newestCreated = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, categoryID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int assetID = rs.getInt("a_asset_id");
                long count = rs.getLong("prod_count");
                Timestamp created = rs.getTimestamp("created");
                if (count >= minProductions && (count != minProductions || newestCreated != null && !created.after(newestCreated))) continue;
                selectedAssetID = assetID;
                minProductions = count;
                newestCreated = created;
            }
        }
        catch (Exception e) {
            try {
                this.log.severe("Error al asignar A_Asset_ID: " + e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (selectedAssetID > 0) {
            p.set_ValueOfColumn("A_Asset_ID", selectedAssetID);
            p.saveEx();
        }
    }

    private void assignPriority(MProduction p) {
        Integer assetID = (Integer)p.get_Value("A_Asset_ID");
        if (assetID == null || assetID == 0) {
            return;
        }
        String sql = "SELECT COALESCE(MAX(CAST(p.PriorityNo AS INTEGER)), 0) FROM m_production p WHERE p.a_asset_id = ? AND p.docstatus <> 'CO' AND p.m_production_id <> ?";
        int maxPriority = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)assetID, (int)p.getM_Production_ID());
        int nextPriority = maxPriority + 1;
        p.set_ValueOfColumn("PriorityNo", nextPriority);
        p.saveEx();
        this.log.info("Asignada prioridad #" + nextPriority + " a producci\u00f3n " + p.getDocumentNo() + " para el activo " + assetID);
    }
}

