/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.logging.Level;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class EKProcessCreateInventoryFromOrderline
extends SvrProcess {
    private int p_Orderline_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (name.equals("C_OrderLine_ID")) {
                this.p_Orderline_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doIt() throws Exception {
        if (this.p_Orderline_ID == 0) {
            return null;
        }
        String sqlCheck = "SELECT M_Inventory_ID FROM C_OrderLine WHERE C_OrderLine_ID=?";
        int prodID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlCheck, (int)this.p_Orderline_ID);
        if (prodID > 0) {
            throw new AdempiereUserError("Ya existe un consumo interno para esta linea.");
        }
        MOrderLine orderline = new MOrderLine(this.getCtx(), this.p_Orderline_ID, this.get_TrxName());
        MOrder order = orderline.getParent();
        MInventory inventory = new MInventory(this.getCtx(), 0, this.get_TrxName());
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE Name='Consumo' and ad_client_id= ?;";
        int doctype_id = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (int)orderline.getAD_Client_ID());
        inventory.setAD_Org_ID(orderline.getAD_Org_ID());
        inventory.setC_DocType_ID(doctype_id);
        inventory.setM_Warehouse_ID(orderline.getC_Order().getM_Warehouse_ID());
        inventory.set_CustomColumn("C_OrderLine_ID", orderline.getC_OrderLine_ID());
        inventory.setDescription("Creado de NV " + orderline.getC_Order().getDocumentNo() + " - Producto: " + orderline.getM_Product().getName());
        if (!inventory.save()) {
            throw new IllegalArgumentException("Cannot save Inventory");
        }
        int warehouseID = order.getM_Warehouse_ID();
        MLocator locator = (MLocator)new Query(this.getCtx(), "M_Locator", "M_Warehouse_ID=? AND IsActive='Y'", this.get_TrxName()).setParameters(new Object[]{warehouseID}).setOrderBy("IsDefault DESC").first();
        if (locator == null) {
            throw new AdempiereUserError("No se encontr\u00f3 una ubicaci\u00f3n activa para el almac\u00e9n ID: " + warehouseID);
        }
        int locatorID = locator.get_ID();
        int chargeID = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT C_Charge_ID FROM C_Charge WHERE LOWER(Name) = 'consumo interno' AND AD_Client_ID=?", (int)orderline.getAD_Client_ID());
        if (chargeID <= 0) {
            throw new AdempiereUserError("No se encontr\u00f3 el Cargo 'Consumo Interno'");
        }
        String sqlBOM = "SELECT pp_product_bom_id FROM pp_product_bom WHERE m_product_id = ?";
        int ppBOM_ID = DB.getSQLValue((String)this.get_TrxName(), (String)sqlBOM, (int)orderline.getM_Product_ID());
        if (ppBOM_ID > 0) {
            BigDecimal qtyPedido = orderline.getQtyEntered();
            String sqlLines = "SELECT m_product_id, qtybom, c_uom_id FROM pp_product_bomline WHERE pp_product_bom_id = ? ";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sqlLines, (String)this.get_TrxName());
                pstmt.setInt(1, ppBOM_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int componenteID = rs.getInt(1);
                    BigDecimal bomQty = rs.getBigDecimal(2);
                    BigDecimal qtyComponente = qtyPedido.multiply(bomQty);
                    int uomID = rs.getInt(3);
                    MInventoryLine line = new MInventoryLine(this.getCtx(), 0, this.get_TrxName());
                    line.setAD_Org_ID(orderline.getAD_Org_ID());
                    line.setM_Inventory_ID(inventory.getM_Inventory_ID());
                    line.setM_Locator_ID(locatorID);
                    line.setM_Product_ID(componenteID);
                    line.setQtyInternalUse(qtyComponente);
                    line.setC_Charge_ID(chargeID);
                    line.setDescription("Componente");
                    line.set_ValueOfColumn("c_uom_id", (Object)uomID);
                    line.saveEx();
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        orderline.set_CustomColumn("M_Inventory_ID", inventory.getM_Inventory_ID());
        orderline.save();
        return "Se creo consumo: " + inventory.getDocumentNo();
    }
}

