/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MClient;
import org.compiere.model.MElementValue;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class EKProcessCreateCombinations
extends SvrProcess {
    private int createdCount = 0;
    private int updatedCount = 0;
    private int errorCount = 0;

    protected void prepare() {
    }

    protected String doIt() throws Exception {
        String sql = "SELECT C_ElementValue_ID FROM C_ElementValue WHERE IsActive='Y' AND ISSUMMARY='N' AND AD_Client_ID=" + this.getAD_Client_ID();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MElementValue account = new MElementValue(this.getCtx(), rs.getInt(1), this.get_TrxName());
                this.CreateCombination(account);
                account.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
            return "Error al crear cuentas =>" + String.valueOf(e);
        }
        DB.executeUpdate((String)("UPDATE C_ValidCombination  set ad_org_id=0,  isactive=(select b.isactive from C_ELEMENTVALUE b where b.C_ELEMENTVALUE_ID = ACCOUNT_ID), description=(select b.name from C_ELEMENTVALUE b where b.C_ELEMENTVALUE_ID = ACCOUNT_ID), combination=substr((select b.value from C_ELEMENTVALUE b where b.C_ELEMENTVALUE_ID = ACCOUNT_ID) ||' - '||(select b.name from C_ELEMENTVALUE b where b.C_ELEMENTVALUE_ID = ACCOUNT_ID),1,59) where ad_client_id=" + this.getAD_Client_ID()), (String)this.get_TrxName());
        this.fixDuplicatedCombinations();
        StringBuilder resultMsg = new StringBuilder();
        resultMsg.append("Cuentas creadas: " + this.createdCount).append("<br>");
        resultMsg.append("Cuentas actualizadas: " + this.updatedCount).append("<br>");
        resultMsg.append("<FONT COLOR=\"red\">").append("Cuentas con error: " + this.errorCount).append("</FONT>");
        return resultMsg.toString();
    }

    public void CreateCombination(MElementValue account) {
        int schemeID = DB.getSQLValue(null, (String)("SELECT C_AcctSchema_ID FROM C_AcctSchema WHERE IsActive='Y' AND AD_Client_ID=" + this.getAD_Client_ID()));
        String sql = "SELECT MIN(C_ValidCombination_ID) FROM C_ValidCombination WHERE AD_Client_ID = ? AND C_AcctSchema_ID = ? AND Account_ID = ?";
        int existingID = DB.getSQLValue((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{this.getAD_Client_ID(), schemeID, account.getC_ElementValue_ID()});
        MClient mClient = MClient.get((Properties)this.getCtx());
        if (existingID > 0) {
            MAccount acct = new MAccount(this.getCtx(), existingID, this.get_TrxName());
            acct.setIsActive(true);
            acct.setAlias(mClient.getValue() + "-" + account.getValue());
            acct.setCombination(account.getValue() + " - " + account.getName());
            acct.setDescription(account.getName());
            if (acct.save()) {
                ++this.updatedCount;
            } else {
                this.log.warning("No se pudo actualizar combinaci\u00f3n existente: " + acct.getCombination());
                ++this.errorCount;
            }
        } else {
            MAccount acct = MAccount.get((Properties)this.getCtx(), (int)this.getAD_Client_ID(), (int)0, (int)schemeID, (int)account.getC_ElementValue_ID(), (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (String)this.get_TrxName());
            acct.setAlias(mClient.getValue() + "-" + account.getValue());
            if (acct.save()) {
                ++this.createdCount;
            } else {
                this.log.warning("No se pudo crear nueva combinaci\u00f3n para cuenta: " + account.getValue());
                ++this.errorCount;
            }
        }
    }

    private int fixDuplicatedCombinations() {
        String sql = "UPDATE C_ValidCombination cvc SET IsActive = 'N' WHERE IsActive = 'Y'   AND cvc.AD_Client_ID = ?   AND EXISTS (     SELECT 1     FROM (       SELECT ad_client_id, account_id, MIN(C_ValidCombination_ID) AS keep_id       FROM C_ValidCombination       WHERE IsActive = 'Y'         AND ad_client_id = ?       GROUP BY ad_client_id, account_id       HAVING COUNT(*) > 1     ) dup     WHERE cvc.ad_client_id = dup.ad_client_id       AND cvc.account_id = dup.account_id       AND cvc.C_ValidCombination_ID <> dup.keep_id   )";
        int c = DB.executeUpdateEx((String)sql, (Object[])new Object[]{this.getAD_Client_ID(), this.getAD_Client_ID()}, (String)this.get_TrxName());
        this.log.config("Se desactivan " + c + " combinaciones duplicadas.");
        return c;
    }
}

