/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import org.compiere.model.MCash;
import org.compiere.model.MCashLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;

public class EKProcessCompletePaySelection
extends SvrProcess {
    private int p_C_PaySelection_ID = 0;
    private String paymentNo = null;

    protected void prepare() {
        ProcessInfoParameter[] parameters;
        for (ProcessInfoParameter para : parameters = this.getParameter()) {
            if (para.getParameter() == null) continue;
            if ("C_PaySelection_ID".equals(para.getParameterName())) {
                this.p_C_PaySelection_ID = para.getParameterAsInt();
                continue;
            }
            this.log.warning("Unknown parameter: " + para.getParameterName());
        }
    }

    protected String doIt() throws Exception {
        if (this.p_C_PaySelection_ID == 0) {
            throw new AdempiereUserError("NoPaySelectionIDprovided");
        }
        MPaySelection paySelection = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
        if (paySelection.get_ID() <= 0) {
            throw new AdempiereUserError("No se encuentra Selecci\u00f3n de pago: " + this.p_C_PaySelection_ID);
        }
        if (paySelection.getC_BankAccount_ID() <= 0) {
            throw new AdempiereUserError("Cuenta bancaria no asignada");
        }
        if (!this.validateLinesAreHomogeneous(paySelection)) {
            throw new AdempiereUserError("La selecci\u00f3n contiene facturas de venta y de compra. No est\u00e1 permitido mezclar.");
        }
        if (this.generatePayment(paySelection)) {
            paySelection.setDocStatus("CO");
            paySelection.setProcessed(true);
            paySelection.set_CustomColumn("C_Payment_ID", (Object)paySelection.get_ValueAsInt("C_Payment_ID"));
            paySelection.saveEx();
            return "Se genera pago N\u00b0" + this.paymentNo;
        }
        return "Error al generar pago";
    }

    private boolean generatePayment(MPaySelection paySelection) throws Exception {
        MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
        boolean isSOTrx = this.isSalesTransaction(paySelection);
        payment.setC_DocType_ID(isSOTrx);
        payment.setAD_Org_ID(paySelection.getAD_Org_ID());
        payment.setC_BPartner_ID(paySelection.get_ValueAsInt("C_BPartner_ID"));
        payment.setPayAmt(paySelection.getTotalAmt());
        payment.setC_Currency_ID(paySelection.getC_BankAccount().getC_Currency_ID());
        payment.setC_BankAccount_ID(paySelection.getC_BankAccount_ID());
        payment.setDateTrx(paySelection.getDateDoc());
        payment.setDateAcct(paySelection.getDateDoc());
        payment.setTenderType("A");
        payment.setIsReceipt(isSOTrx);
        payment.setDocStatus("DR");
        payment.set_CustomColumn("C_PaySelection_ID", paySelection.getC_PaySelection_ID());
        payment.saveEx();
        for (MPaySelectionLine line : paySelection.getLines(true)) {
            int invoiceId = line.getC_Invoice_ID();
            int cashId = line.get_ValueAsInt("C_Cash_ID");
            if (invoiceId > 0) {
                MPaymentAllocate allocate = new MPaymentAllocate(this.getCtx(), 0, this.get_TrxName());
                allocate.setC_Payment_ID(payment.getC_Payment_ID());
                allocate.setC_Invoice_ID(invoiceId);
                allocate.setAmount(line.getPayAmt());
                allocate.setInvoiceAmt(line.getPayAmt());
                allocate.setAD_Org_ID(payment.getAD_Org_ID());
                allocate.saveEx();
                continue;
            }
            if (cashId <= 0) continue;
            MCash cash = new MCash(this.getCtx(), cashId, this.get_TrxName());
            MCashLine cashLine = new MCashLine(cash);
            cashLine.setCashType("T");
            cashLine.setDescription("Asociado a pago generado desde selecci\u00f3n: " + paySelection.getDocumentNo());
            cashLine.setC_Currency_ID(payment.getC_Currency_ID());
            cashLine.setAmount(line.getPayAmt());
            cashLine.setC_Payment_ID(payment.getC_Payment_ID());
            cashLine.setC_BankAccount_ID(payment.getC_BankAccount_ID());
            cashLine.setProcessed(true);
            cashLine.saveEx();
            cash.setDocStatus("CO");
            cash.setProcessed(true);
            cash.saveEx();
            DB.executeUpdate((String)"UPDATE C_Cash SET EndingBalance = BeginningBalance + StatementDifference WHERE C_Cash_ID = ?", (int)cashId, (String)this.get_TrxName());
        }
        if (!payment.processIt("CO")) {
            throw new AdempiereUserError("No se pudo completar el pago: " + payment.getProcessMsg());
        }
        payment.saveEx();
        this.paymentNo = payment.getDocumentNo();
        paySelection.set_CustomColumn("C_Payment_ID", (Object)payment.getC_Payment_ID());
        return true;
    }

    private boolean validateLinesAreHomogeneous(MPaySelection paySelection) throws AdempiereUserError {
        Boolean firstIsSOTrx = null;
        for (MPaySelectionLine line : paySelection.getLines(true)) {
            int invoiceId = line.getC_Invoice_ID();
            int cashId = line.get_ValueAsInt("C_Cash_ID");
            if (invoiceId > 0) {
                MInvoice inv = new MInvoice(this.getCtx(), invoiceId, this.get_TrxName());
                boolean isSO = inv.isSOTrx();
                if (firstIsSOTrx == null) {
                    firstIsSOTrx = isSO;
                    continue;
                }
                if (firstIsSOTrx == isSO) continue;
                throw new AdempiereUserError("No se pueden mezclar facturas de cliente y proveedor en la misma selecci\u00f3n.");
            }
            if (cashId <= 0) continue;
            if (firstIsSOTrx != null && firstIsSOTrx.booleanValue()) {
                throw new AdempiereUserError("No se pueden incluir l\u00edneas de caja (C_Cash_ID) en una selecci\u00f3n de cobros de clientes.");
            }
            if (firstIsSOTrx != null) continue;
            firstIsSOTrx = false;
        }
        return true;
    }

    private boolean isSalesTransaction(MPaySelection paySelection) {
        for (MPaySelectionLine line : paySelection.getLines(true)) {
            if (line.getC_Invoice_ID() <= 0) continue;
            MInvoice inv = new MInvoice(this.getCtx(), line.getC_Invoice_ID(), this.get_TrxName());
            return inv.isSOTrx();
        }
        return false;
    }
}

