/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.process;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MFormAccess;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CopyFormAccessFromRoleTab
extends SvrProcess {
    private int p_AD_Role_ID = 0;
    private int p_AD_Form_ID = 0;

    protected void prepare() {
        ProcessInfoParameter[] para;
        for (ProcessInfoParameter p : para = this.getParameter()) {
            if (p == null || p.getParameterName() == null) continue;
            String name = p.getParameterName();
            if ("AD_Role_ID".equalsIgnoreCase(name)) {
                if (p.getParameter() == null) continue;
                this.p_AD_Role_ID = ((Number)p.getParameter()).intValue();
                continue;
            }
            if (!"AD_Form_ID".equalsIgnoreCase(name) || p.getParameter() == null) continue;
            this.p_AD_Form_ID = ((Number)p.getParameter()).intValue();
        }
    }

    protected String doIt() throws Exception {
        if (this.getTable_ID() != MFormAccess.Table_ID) {
            throw new AdempiereException("Este proceso debe ejecutarse desde la pesta\u00f1a 'Formas Especiales Asignadas' del Rol (AD_Form_Access).");
        }
        int originRoleId = this.p_AD_Role_ID;
        int formId = this.p_AD_Form_ID;
        if (originRoleId <= 0) {
            throw new AdempiereException("No se pudo determinar el Rol origen (par\u00e1metro AD_Role_ID).");
        }
        if (formId <= 0) {
            throw new AdempiereException("No se pudo determinar la Forma Especial origen (par\u00e1metro AD_Form_ID).");
        }
        MRole originRole = new MRole(this.getCtx(), originRoleId, this.get_TrxName());
        int clientId = originRole.getAD_Client_ID();
        String roleDesc = originRole.getDescription();
        if (roleDesc == null || roleDesc.trim().isEmpty()) {
            throw new AdempiereException("El rol origen no tiene descripci\u00f3n.");
        }
        int originTreeId = originRole.getAD_Tree_Menu_ID();
        if (originTreeId <= 0) {
            throw new AdempiereException("El rol origen no tiene \u00c1rbol de Men\u00fa asignado.");
        }
        String treeDesc = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT COALESCE(Description, Name) FROM AD_Tree WHERE AD_Tree_ID=?", (int)originTreeId);
        if (treeDesc == null || treeDesc.trim().isEmpty()) {
            throw new AdempiereException("El \u00c1rbol de Men\u00fa origen no tiene descripci\u00f3n / nombre.");
        }
        List<MenuNode> menuNodes = this.loadMenuNodesFromOrigin(originTreeId, formId);
        boolean hasMenus = !menuNodes.isEmpty();
        List<RoleTree> roles = this.loadRolesWithSameDescription(roleDesc);
        int addedFormAccess = 0;
        int addedMenu = 0;
        for (RoleTree role : roles) {
            if (!this.existsFormAccess(role.AD_Role_ID, formId)) {
                this.insertFormAccess(role.AD_Client_ID, role.AD_Role_ID, formId);
                ++addedFormAccess;
            }
            List<Integer> targetTrees = this.loadTreesWithSameDescription(role.AD_Client_ID, treeDesc);
            for (Integer treeId : targetTrees) {
                for (MenuNode node : menuNodes) {
                    if (this.existsTreeNode(treeId, node.AD_Menu_ID)) continue;
                    this.insertTreeNode(role.AD_Client_ID, treeId, node.AD_Menu_ID, node.Parent_ID, node.SeqNo);
                    ++addedMenu;
                }
            }
        }
        String message = "Formas agregadas: " + addedFormAccess + " | Nodos de men\u00fa agregados: " + addedMenu + " | Descripci\u00f3n de rol usada: '" + roleDesc + "' | Descripci\u00f3n de \u00e1rbol usada: '" + treeDesc + "'";
        if (!hasMenus) {
            message = message + " (Advertencia: La forma no tiene men\u00fa asociado en el \u00e1rbol origen.)";
        }
        return message;
    }

    private List<MenuNode> loadMenuNodesFromOrigin(int treeId, int formId) throws Exception {
        ArrayList<MenuNode> list = new ArrayList<MenuNode>();
        String sql = "SELECT tn.Node_ID, tn.Parent_ID, tn.SeqNo FROM AD_TreeNodeMM tn JOIN AD_Menu m ON (m.AD_Menu_ID = tn.Node_ID) WHERE tn.AD_Tree_ID=? AND m.AD_Form_ID=? AND m.IsActive='Y'";
        CPreparedStatement ps = DB.prepareStatement((String)sql, (String)this.get_TrxName());
        ps.setInt(1, treeId);
        ps.setInt(2, formId);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            MenuNode n = new MenuNode();
            n.AD_Menu_ID = rs.getInt(1);
            n.Parent_ID = rs.getInt(2);
            n.SeqNo = rs.getInt(3);
            list.add(n);
        }
        rs.close();
        ps.close();
        return list;
    }

    private List<RoleTree> loadRolesWithSameDescription(String roleDesc) throws Exception {
        ArrayList<RoleTree> list = new ArrayList<RoleTree>();
        String sql = "SELECT AD_Role_ID, AD_Tree_Menu_ID, AD_Client_ID FROM AD_Role WHERE Description=?   AND AD_Tree_Menu_ID IS NOT NULL   AND IsActive='Y'";
        CPreparedStatement ps = DB.prepareStatement((String)sql, (String)this.get_TrxName());
        ps.setString(1, roleDesc);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            RoleTree rt = new RoleTree();
            rt.AD_Role_ID = rs.getInt(1);
            rt.AD_Tree_ID = rs.getInt(2);
            rt.AD_Client_ID = rs.getInt(3);
            list.add(rt);
        }
        rs.close();
        ps.close();
        return list;
    }

    private List<Integer> loadTreesWithSameDescription(int clientId, String treeDesc) throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        String sql = "SELECT AD_Tree_ID FROM AD_Tree WHERE AD_Client_ID=? AND TreeType='MM'   AND COALESCE(Description, Name)=?";
        CPreparedStatement ps = DB.prepareStatement((String)sql, (String)this.get_TrxName());
        ps.setInt(1, clientId);
        ps.setString(2, treeDesc);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            list.add(rs.getInt(1));
        }
        rs.close();
        ps.close();
        return list;
    }

    private boolean existsFormAccess(int roleId, int formId) {
        return DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM AD_Form_Access WHERE AD_Role_ID=? AND AD_Form_ID=?", (int)roleId, (int)formId) > 0;
    }

    private void insertFormAccess(int clientId, int roleId, int formId) {
        String sql = "INSERT INTO AD_Form_Access (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,  AD_Role_ID, AD_Form_ID, IsReadWrite) VALUES (?, 0, 'Y', NOW(), ?, NOW(), ?, ?, ?, 'Y')";
        Object[] params = new Object[]{clientId, this.getAD_User_ID(), this.getAD_User_ID(), roleId, formId};
        DB.executeUpdateEx((String)sql, (Object[])params, (String)this.get_TrxName());
    }

    private boolean existsTreeNode(int treeId, int menuId) {
        return DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT COUNT(*) FROM AD_TreeNodeMM WHERE AD_Tree_ID=? AND Node_ID=?", (int)treeId, (int)menuId) > 0;
    }

    private void insertTreeNode(int clientId, int treeId, int menuId, int parentId, int seqNo) {
        String sql = "INSERT INTO AD_TreeNodeMM (AD_Client_ID, AD_Org_ID, IsActive, Created, CreatedBy, Updated, UpdatedBy,  AD_Tree_ID, Node_ID, Parent_ID, SeqNo) VALUES (?, 0, 'Y', NOW(), ?, NOW(), ?, ?, ?, ?, ?)";
        Object[] params = new Object[]{clientId, this.getAD_User_ID(), this.getAD_User_ID(), treeId, menuId, parentId, seqNo};
        DB.executeUpdateEx((String)sql, (Object[])params, (String)this.get_TrxName());
    }

    private static class RoleTree {
        int AD_Role_ID;
        int AD_Tree_ID;
        int AD_Client_ID;

        private RoleTree() {
        }
    }

    private static class MenuNode {
        int AD_Menu_ID;
        int Parent_ID;
        int SeqNo;

        private MenuNode() {
        }
    }
}

