/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MClient;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelUpdateCashBookOnCashComplete
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelUpdateCashBookOnCashComplete.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("C_Cash", (ModelValidator)this);
        engine.addDocValidate("C_Cash", (ModelValidator)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modelChange(PO po, int type) throws Exception {
        block8: {
            if (!(po instanceof MCash)) {
                return null;
            }
            MCash cash = (MCash)po;
            Properties ctx = cash.getCtx();
            String trxName = cash.get_TrxName();
            if (type != 1 && type != 2) break block8;
            int cashBookId = cash.getC_CashBook_ID();
            if (cashBookId > 0) {
                String docStatus = cash.getDocStatus();
                if (docStatus == null || docStatus.isEmpty()) {
                    docStatus = "DR";
                }
                if ("DR".equals(docStatus) || "IP".equals(docStatus)) {
                    ResultSet rs;
                    CPreparedStatement ps;
                    block7: {
                        String string;
                        String sql = "SELECT C_Cash_ID, Name, DocStatus FROM C_Cash WHERE AD_Client_ID=? AND IsActive='Y' AND C_CashBook_ID=? AND DocStatus IN ('DR','IP') AND C_Cash_ID<>? ORDER BY Updated DESC LIMIT 1";
                        ps = null;
                        rs = null;
                        try {
                            ps = DB.prepareStatement((String)"SELECT C_Cash_ID, Name, DocStatus FROM C_Cash WHERE AD_Client_ID=? AND IsActive='Y' AND C_CashBook_ID=? AND DocStatus IN ('DR','IP') AND C_Cash_ID<>? ORDER BY Updated DESC LIMIT 1", (String)trxName);
                            ps.setInt(1, Env.getAD_Client_ID((Properties)ctx));
                            ps.setInt(2, cashBookId);
                            ps.setInt(3, cash.getC_Cash_ID());
                            rs = ps.executeQuery();
                            if (!rs.next()) break block7;
                            int otherId = rs.getInt(1);
                            String namedoc = rs.getString(2);
                            String otherStatus = rs.getString(3);
                            String statusName = MRefList.getListName((Properties)ctx, (int)131, (String)otherStatus);
                            string = "Ya existe una caja en estado " + statusName + " para esta Caja Menor (Nombre=" + namedoc + ", C_Cash_ID=" + otherId + "). Debe completar/cerrar o revertir esa caja antes de crear otra.";
                        }
                        catch (Throwable throwable) {
                            DB.close(rs, (Statement)ps);
                            throw throwable;
                        }
                        DB.close((ResultSet)rs, (Statement)ps);
                        return string;
                    }
                    DB.close((ResultSet)rs, (Statement)ps);
                }
            }
            if (type == 1 && cash.getC_CashBook_ID() > 0) {
                MCashBook cb = new MCashBook(po.getCtx(), cash.getC_CashBook_ID(), trxName);
                BigDecimal end = (BigDecimal)cb.get_Value("EndingBalance");
                cash.setBeginningBalance(end != null ? end : Env.ZERO);
                log.fine("Init BeginningBalance (NEW) desde CashBook.EndingBalance: " + String.valueOf(cash.getBeginningBalance()));
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (!(po instanceof MCash)) {
            return null;
        }
        if (timing != 9) {
            return null;
        }
        MCash cash = (MCash)po;
        String trxName = cash.get_TrxName();
        int cashBookId = cash.getC_CashBook_ID();
        if (cashBookId <= 0) {
            return null;
        }
        BigDecimal ending = cash.getEndingBalance();
        if (ending == null) {
            ending = Env.ZERO;
        }
        MCashBook cb = new MCashBook(Env.getCtx(), cashBookId, trxName);
        cb.set_ValueOfColumn("EndingBalance", (Object)ending);
        cb.saveEx(trxName);
        log.fine("C_Cash completed -> C_CashBook_ID=" + cashBookId + " EndingBalance=" + String.valueOf(ending));
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

