/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.ajah.model.AbstractValidatingEKModel;
import org.ajah.model.EKModelRutValidator;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class EKModelValidProduction
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelRutValidator.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("M_Production", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        Object error = "";
        if (po instanceof MProduction) {
            MProduction prod = (MProduction)po;
            if (timing == 9) {
                if (this.isValidationEnabled("validAttributeSetInProduction", po) && this.validAttributeSetInProduction(prod) != null) {
                    error = (String)error + String.valueOf(this.validAttributeSetInProduction(prod));
                }
                if (this.isValidationEnabled("processSalesOrderCompletion", po) && this.processSalesOrderCompletion(prod) != null) {
                    error = (String)error + this.processSalesOrderCompletion(prod);
                }
                if (this.isValidationEnabled("ValidProductionStock", po) && this.ValidProductionStock(prod, po) != null) {
                    error = (String)error + this.ValidProductionStock(prod, po);
                }
            }
            if (timing == 7 && this.isValidationEnabled("copyAttributesToOrderLine", po) && this.copyAttributesToOrderLine(prod) != null) {
                error = (String)error + this.copyAttributesToOrderLine(prod);
            }
        }
        return error == "" ? null : error;
    }

    private Object validAttributeSetInProduction(MProduction prod) {
        for (MProductionLine prodLine : prod.getLines()) {
            if (!prodLine.isEndProduct()) continue;
            if (prodLine.getM_Product().getM_AttributeSet_ID() <= 0 || prodLine.getM_AttributeSetInstance_ID() > 0) break;
            return "Producto final con conjunto de atributo favor llenar datos.";
        }
        return null;
    }

    public String copyAttributesToOrderLine(MProduction prod) {
        int ol_id = prod.getC_OrderLine_ID();
        if (ol_id >= 0) {
            for (MProductionLine prodLine : prod.getLines_OrderedByIsEndProduct()) {
                if (!prodLine.isEndProduct()) continue;
                String sql = "UPDATE C_OrderLine SET M_AttributeSetInstance_ID=?, Description=? WHERE C_OrderLine_ID=?";
                DB.executeUpdate((String)sql, (Object[])new Object[]{prodLine.getM_AttributeSetInstance_ID(), this.getAttributeDescription(prodLine.getM_AttributeSetInstance_ID()), ol_id}, (boolean)true, (String)prod.get_TrxName());
                break;
            }
        }
        return null;
    }

    private String processSalesOrderCompletion(MProduction production) {
        int orderLineId = production.getC_OrderLine_ID();
        if (orderLineId <= 0) {
            return null;
        }
        MOrderLine orderLine = new MOrderLine(production.getCtx(), orderLineId, production.get_TrxName());
        MOrder order = orderLine.getParent();
        if (!"CO".equals(order.getDocStatus())) {
            boolean ok = order.processIt("CO");
            String msg = order.getProcessMsg();
            log.warning("Intentando completar orden ID=" + order.get_ID() + ", resultado: " + ok + ", mensaje: " + msg);
            if (!ok) {
                return "Error al completar la orden: " + msg;
            }
            order.setDocStatus("CO");
            order.setProcessed(ok);
            order.saveEx();
        }
        return null;
    }

    public String getAttributeDescription(int M_AttributeSetInstance_ID) {
        MAttributeSetInstance masi = new MAttributeSetInstance(Env.getCtx(), M_AttributeSetInstance_ID, null);
        String sql = "select ma.name||':'||mai.value as attribute from m_attributeinstance mai join m_attribute ma on ma.m_attribute_id=mai.m_attribute_id join m_attributeuse mau on (mau.m_attribute_id=ma.m_attribute_id and mau.m_attributeset_id=?) where m_attributesetinstance_id=? order by mau.seqno";
        CPreparedStatement ps = null;
        ResultSet rs = null;
        String serno = masi.getSerNo() == null ? "" : "N\u00b0Serie:" + masi.getSerNo().concat(" | ");
        String lot = masi.getLot() == null ? "" : "Lote:" + masi.getLot().concat(" | ");
        Object desc = serno + lot;
        try {
            ps = DB.prepareStatement((String)sql, null);
            ps.setInt(1, masi.getM_AttributeSet_ID());
            ps.setInt(2, masi.getM_AttributeSetInstance_ID());
            rs = ps.executeQuery();
            while (rs.next()) {
                desc = ((String)desc).concat(rs.getString("attribute").concat("|"));
            }
        }
        catch (Exception e) {
            log.warning("Error:" + e.getMessage());
        }
        return desc;
    }

    public String ValidProductionStock(MProduction prod, PO po) {
        try {
            String trxName = prod.get_TrxName();
            if (!prod.get_ValueAsBoolean("MustBeStocked")) {
                return null;
            }
            MProductionLine[] lines = prod.getLines();
            boolean isUnpack = false;
            for (MProductionLine l : lines) {
                if (l.getMovementQty() == null || l.getMovementQty().signum() >= 0 || !l.get_ValueAsBoolean("IsEndProduct")) continue;
                isUnpack = true;
                break;
            }
            for (MProductionLine line : lines) {
                int M_Product_ID;
                BigDecimal movementQty;
                if (!line.getM_Product().isStocked() || (movementQty = line.getMovementQty()) == null || movementQty.signum() >= 0 || (M_Product_ID = line.getM_Product_ID()) <= 0) continue;
                boolean isEnd = line.get_ValueAsBoolean("IsEndProduct");
                if (isUnpack && !isEnd || !isUnpack && isEnd) continue;
                int M_Locator_ID = line.getM_Locator_ID();
                int M_ASI_ID = line.getM_AttributeSetInstance_ID();
                BigDecimal needed = movementQty.abs();
                BigDecimal onHand = this.getQtyOnHandInLocator(M_Product_ID, M_ASI_ID, M_Locator_ID);
                if (onHand == null) {
                    onHand = Env.ZERO;
                }
                if (onHand.compareTo(needed) >= 0) continue;
                String prodValue = DB.getSQLValueString((String)trxName, (String)"SELECT Value FROM M_Product WHERE M_Product_ID=?", (int)M_Product_ID);
                String prodName = DB.getSQLValueString((String)trxName, (String)"SELECT Name FROM M_Product WHERE M_Product_ID=?", (int)M_Product_ID);
                String rol = isUnpack ? "producto final" : "componente";
                String msg = "Stock insuficiente para el " + rol + " " + (String)(Util.isEmpty((String)prodValue, (boolean)true) ? "" : prodValue + " - ") + (String)(Util.isEmpty((String)prodName, (boolean)true) ? "ID:" + M_Product_ID : prodName) + " en la ubicaci\u00f3n de la Linea. Necesita " + String.valueOf(needed) + " y solo hay " + String.valueOf(onHand) + (M_ASI_ID > 0 ? " (mismo ASI)." : ".");
                throw new AdempiereUserError(msg);
            }
        }
        catch (AdempiereUserError e) {
            return e.getMessage();
        }
        catch (Exception ex) {
            log.severe("Error validando stock : " + ex.getMessage());
            return "Error al validar stock : " + ex.getMessage();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigDecimal getQtyOnHandInLocator(int M_Product_ID, int M_ASI_ID, int M_Locator_ID) {
        int Prodct = M_Product_ID;
        int asi = M_ASI_ID;
        int locator = M_Locator_ID;
        StringBuilder sql = new StringBuilder().append("SELECT COALESCE(SUM(s.QtyOnHand),0) ").append("FROM M_Storage s ").append("WHERE s.M_Product_ID=? AND s.M_Locator_ID=? ");
        if (M_ASI_ID > 0) {
            sql.append("AND s.M_AttributeSetInstance_ID=? ");
        }
        try (CPreparedStatement ps = DB.prepareStatement((String)sql.toString(), null);){
            int i = 1;
            ps.setInt(i++, M_Product_ID);
            ps.setInt(i++, M_Locator_ID);
            if (M_ASI_ID > 0) {
                ps.setInt(i++, M_ASI_ID);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return Env.ZERO;
                BigDecimal bigDecimal = rs.getBigDecimal(1);
                return bigDecimal;
            }
        }
        catch (Exception e) {
            log.warning("getQtyOnHandInLocator error: " + e.getMessage());
        }
        return Env.ZERO;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

