/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.Normalizer;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MIssue;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MRefList;
import org.compiere.model.MStorage;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class EKModelValidOrder
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelValidOrder.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addModelChange("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MOrder order;
        Object error = "";
        if ((type == 5 || type == 4) && po instanceof MOrder && po.is_ValueChanged("IsSOTrx")) {
            order = (MOrder)po;
            if (this.isValidationEnabled("fixInvalidIsSOTrx", po) && this.fixInvalidIsSOTrx(order) != null) {
                error = (String)error + this.fixInvalidIsSOTrx(order);
            }
        }
        if ((type == 1 || type == 2) && po instanceof MOrder) {
            order = (MOrder)po;
            if (this.isValidationEnabled("DateValidator", po) && this.DateValidator(order) != null) {
                error = (String)error + this.DateValidator(order);
            }
            if (this.isValidationEnabled("OrderReadyForApproval", po) && this.OrderReadyForApproval(order) != null) {
                error = (String)error + this.OrderReadyForApproval(order);
            }
        }
        return error == "" ? null : error;
    }

    private String fixInvalidIsSOTrx(MOrder order) {
        String docBaseType = order.getC_DocTypeTarget().getDocBaseType();
        if (!(!order.getC_DocTypeTarget().getDocBaseType().equals("SOO") || order.isSOTrx() && order.getM_PriceList().isSOPriceList())) {
            String error = "ERROR: Se intenta crear nota de venta como compra (Order:" + order.getDocumentNo() + ").";
            log.severe(error);
            MIssue issue = new MIssue(order.getCtx(), 0, order.get_TrxName());
            issue.setIssueSummary(error);
            issue.setVersion("1");
            issue.setReleaseNo("3.9.4");
            issue.setReleaseTag("ERROR_NV");
            issue.setIsVanillaSystem("N");
            issue.setComments("AJAH");
            issue.setSystemStatus("P");
            issue.saveEx();
            int priceListID = MPriceList.getDefault(null, (boolean)true).getM_PriceList_ID();
            order.setIsSOTrx(true);
            order.setM_PriceList_ID(priceListID);
            order.saveEx();
        }
        return null;
    }

    private String OrderReadyForApproval(MOrder order) {
        if (!order.isSOTrx()) {
            return null;
        }
        String COL_READY = "IsReadyforApproval";
        String COL_DATEP = "Dateprocessed";
        Boolean ready = (Boolean)order.get_Value("IsReadyforApproval");
        Object datepObj = order.get_Value("Dateprocessed");
        if (Boolean.TRUE.equals(ready) && datepObj == null) {
            order.set_ValueOfColumn("Dateprocessed", new Timestamp(System.currentTimeMillis()));
        }
        return null;
    }

    private String DateValidator(MOrder order) {
        if (!order.isSOTrx()) {
            return null;
        }
        Timestamp dateOrdered = order.getDateOrdered();
        Timestamp datePromised = order.getDatePromised();
        if (datePromised != null && dateOrdered != null && datePromised.before(dateOrdered)) {
            log.log(Level.WARNING, "Fecha Prometida menor que Fecha de Orden");
            return "La Fecha Prometida no puede ser menor que la Fecha de la Orden.";
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        Object error = "";
        if (po instanceof MOrder) {
            MOrder order = (MOrder)po;
            MDocType dt = new MDocType(po.getCtx(), order.getC_DocType_ID(), po.get_TrxName());
            if (timing == 7 && order.isSOTrx()) {
                if (this.isValidationEnabled("wrongAffectsLines", po) && this.wrongAffectsLines(order, dt) != null) {
                    error = (String)error + this.wrongAffectsLines(order, dt);
                }
                if (this.isValidationEnabled("wrongExemptLines", po) && this.wrongExemptLines(order, dt) != null) {
                    error = (String)error + this.wrongExemptLines(order, dt);
                }
                if (this.isValidationEnabled("wrongWarehouseOrg", po) && this.wrongWarehouseOrg(order, dt) != null) {
                    error = (String)error + String.valueOf(this.wrongWarehouseOrg(order, dt));
                }
                if (this.isValidationEnabled("productionNotComplete", po) && this.productionNotComplete(order, dt) != null) {
                    error = (String)error + this.productionNotComplete(order, dt);
                }
                if (this.isValidationEnabled("stockNotAvailable", po) && this.stockNotAvailable(order, dt) != null) {
                    error = (String)error + this.stockNotAvailable(order, dt);
                }
                if (this.isValidationEnabled("OrderProductionValidator", po) && this.OrderProductionValidator(order, dt) != null) {
                    error = (String)error + this.OrderProductionValidator(order, dt);
                }
            }
            if (timing == 4 && this.isValidationEnabled("updateQtyReserved", po) && this.updateQtyReserved(order, dt) != null) {
                error = (String)error + this.updateQtyReserved(order, dt);
            }
        }
        return error == "" ? null : error;
    }

    public String wrongAffectsLines(MOrder order, MDocType dt) {
        boolean taxExempt = dt.get_ValueAsBoolean("IsTaxExempt");
        if (taxExempt) {
            MOrderLine[] lines;
            for (MOrderLine line : lines = order.getLines()) {
                if (line.getC_Tax().isTaxExempt()) continue;
                return "L\u00ednea " + line.getLine() + " no puede ser afecta en documento exento. \n";
            }
        }
        return null;
    }

    public String wrongExemptLines(MOrder order, MDocType dt) {
        boolean taxExempt = dt.get_ValueAsBoolean("IsTaxExempt");
        if (!taxExempt) {
            MOrderLine[] lines;
            for (MOrderLine line : lines = order.getLines()) {
                if (!line.getC_Tax().isTaxExempt()) continue;
                return "L\u00ednea " + line.getLine() + " no puede ser exenta en documento afecto. \n";
            }
        }
        return null;
    }

    private Object wrongWarehouseOrg(MOrder order, MDocType dt) {
        int whOrg = order.getM_Warehouse().getAD_Org_ID();
        int ordOrg = order.getAD_Org_ID();
        if (ordOrg != whOrg) {
            return Msg.getMsg((Properties)order.getCtx(), (String)"WarehouseOrgConflict").concat("\n");
        }
        return null;
    }

    private String productionNotComplete(MOrder order, MDocType dt) {
        MOrderLine[] lines;
        for (MOrderLine line : lines = order.getLines()) {
            MProduction prod;
            int p_id = DB.getSQLValue((String)order.get_TrxName(), (String)("select coalesce(M_Production_ID,0) from M_Production where docstatus not in ('VO','RE') and C_OrderLine_ID=" + line.getC_OrderLine_ID()));
            if (p_id <= 0 || (prod = new MProduction(order.getCtx(), p_id, order.get_TrxName())).getDocStatus().equals("CO")) continue;
            return "Se debe completar produccion " + prod.getDocumentNo() + " asociada a la linea" + line.getLine() + " producto " + line.getM_Product().getName() + ". \n";
        }
        return null;
    }

    private String stockNotAvailable(MOrder order, MDocType dt) {
        if (this.shouldSkipForSalesReturn(order, dt)) {
            return null;
        }
        MOrderLine[] lines = order.getLines();
        StringBuilder error = new StringBuilder();
        for (MOrderLine line : lines) {
            BigDecimal qtyOrdered;
            if (line.getM_Product_ID() <= 0 || !line.getM_Product().isStocked()) continue;
            int asiID = line.getM_AttributeSetInstance_ID();
            Object sql = "SELECT SUM(s.qtyonhand) FROM m_storage s JOIN m_locator l ON s.m_locator_id = l.m_locator_id WHERE s.m_product_id = ? AND l.m_warehouse_id = ?";
            BigDecimal qtyOnHand = Env.ZERO;
            if (asiID > 0) {
                sql = (String)sql + " AND s.m_attributesetinstance_id = ?";
                qtyOnHand = DB.getSQLValueBD((String)order.get_TrxName(), (String)sql, (Object[])new Object[]{line.getM_Product_ID(), order.getM_Warehouse_ID(), asiID});
            } else {
                qtyOnHand = DB.getSQLValueBD((String)order.get_TrxName(), (String)sql, (Object[])new Object[]{line.getM_Product_ID(), order.getM_Warehouse_ID()});
            }
            if (qtyOnHand == null) {
                qtyOnHand = BigDecimal.ZERO;
            }
            if (qtyOnHand.compareTo(qtyOrdered = line.getQtyOrdered()) >= 0) continue;
            error.append("No hay stock suficiente para el producto ").append(line.getM_Product().getName());
            if (asiID > 0) {
                error.append(" (atributo ").append(asiID).append(")");
            }
            error.append(" en la l\u00ednea ").append(line.getLine()).append(" bodega ").append(order.getM_Warehouse().getName()).append(". Disponible: ").append(qtyOnHand).append(", Requerido: ").append(qtyOrdered).append("\n");
        }
        return error.length() > 0 ? error.toString() : null;
    }

    private boolean shouldSkipForSalesReturn(MOrder order, MDocType dt) {
        if (dt == null) {
            int docTypeId;
            int n = docTypeId = order.getC_DocTypeTarget_ID() > 0 ? order.getC_DocTypeTarget_ID() : order.getC_DocType_ID();
            if (docTypeId > 0) {
                dt = new MDocType(order.getCtx(), docTypeId, order.get_TrxName());
            }
        }
        if (dt == null || dt.getName() == null) {
            return false;
        }
        String name = this.normalize(dt.getName());
        return name.contains("devolucion") && name.contains("venta");
    }

    private String normalize(String s) {
        String n = Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").toLowerCase(Locale.ROOT).trim().replaceAll("\\s+", " ");
        return n;
    }

    private String updateQtyReserved(MOrder order, MDocType dt) {
        MOrderLine[] lines;
        if ((dt.getDescription() == null ? "" : dt.getDescription()).contains("Devolucion")) {
            return null;
        }
        for (MOrderLine line : lines = order.getLines()) {
            int locatorId;
            if (line.getM_Product_ID() <= 0 || !line.getM_Product().isStocked() || line.getQtyReserved().signum() == 0) continue;
            int n = locatorId = line.getM_Locator_ID() <= 0 ? line.getM_Product().getM_Locator_ID() : line.getM_Locator_ID();
            if (locatorId <= 0) {
                locatorId = MStorage.getM_Locator_ID(order.getM_Warehouse_ID(), line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), Env.ZERO, line.get_TrxName());
            }
            MStorage.add(line.getCtx(), line.getM_Warehouse_ID(), locatorId, line.getM_Product_ID(), line.getM_AttributeSetInstance_ID(), 0, Env.ZERO, line.getQtyReserved().negate(), Env.ZERO, line.get_TrxName());
            line.setQtyReserved(Env.ZERO);
            line.saveEx();
        }
        return null;
    }

    private String OrderProductionValidator(MOrder order, MDocType dt) {
        if (!order.isSOTrx()) {
            return null;
        }
        if (dt == null) {
            int docTypeId;
            int n = docTypeId = order.getC_DocTypeTarget_ID() > 0 ? order.getC_DocTypeTarget_ID() : order.getC_DocType_ID();
            if (docTypeId > 0) {
                dt = MDocType.get((Properties)order.getCtx(), (int)docTypeId);
            }
        }
        if (dt != null && "WR".equals(dt.getDocSubTypeSO())) {
            return null;
        }
        for (MOrderLine line : order.getLines()) {
            MProduct product = line.getProduct();
            if (product == null || !product.isBOM()) continue;
            int orderLineId = line.getC_OrderLine_ID();
            int prodCount = DB.getSQLValue(null, (String)"SELECT COUNT(*) FROM M_Production WHERE C_OrderLine_ID=?", (int)orderLineId);
            if (prodCount <= 0) {
                return "El producto " + product.getName() + " no tiene una producci\u00f3n creada, revise si todo est\u00e1 correcto.";
            }
            int hasCO = DB.getSQLValue(null, (String)"SELECT 1 FROM M_Production WHERE C_OrderLine_ID=? AND DocStatus='CO' LIMIT 1", (int)orderLineId);
            if (hasCO == 1) continue;
            List productions = new Query(Env.getCtx(), "M_Production", "C_OrderLine_ID=?", null).setParameters(new Object[]{orderLineId}).setOnlyActiveRecords(true).setClient_ID().list();
            HashSet<String> codes = new HashSet<String>();
            for (MProduction prod : productions) {
                codes.add(prod.getDocStatus());
            }
            String statuses = codes.stream().map(code -> MRefList.getListName((Properties)Env.getCtx(), (int)131, (String)code)).sorted().collect(Collectors.joining(", "));
            String anyStatus = DB.getSQLValueString(null, (String)"SELECT DocStatus FROM M_Production WHERE C_OrderLine_ID=? ORDER BY Updated DESC LIMIT 1", (int)orderLineId);
            return "El producto " + product.getName() + " tiene producciones asociadas pero ninguna est\u00e1 completada. Estados encontrados: " + statuses;
        }
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

