/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import org.ajah.model.EKModelRutValidator;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;

public class EKModelValidInvoiceQtyOrder
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelRutValidator.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        Object error = null;
        if (timing == 7 && po instanceof MInvoice) {
            MInvoice inv = (MInvoice)po;
            MDocType dt = new MDocType(po.getCtx(), inv.getC_DocType_ID(), po.get_TrxName());
            if (inv.isSOTrx()) {
                MInvoiceLine[] lines = inv.getLines();
                String sql = "select coalesce(sum(cil.qtyinvoiced),0) from c_invoice ci join c_invoiceline cil on cil.c_invoice_id=ci.c_invoice_id where ci.docstatus in ('CO','CL') and cil.c_orderline_id=?";
                for (MInvoiceLine line : lines) {
                    if (line.getC_OrderLine_ID() <= 0) continue;
                    BigDecimal qtyInvoiced = DB.getSQLValueBD((String)po.get_TrxName(), (String)sql, (int)line.getC_OrderLine_ID());
                    BigDecimal totalQtyInvoiced = qtyInvoiced.add(line.getQtyEntered());
                    if (line.getC_OrderLine().getQtyOrdered().compareTo(totalQtyInvoiced) >= 0) continue;
                    return "Cantidad a facturar supera la cantidad ordenada.(Ordenada=" + line.getC_OrderLine().getQtyOrdered().stripTrailingZeros().toPlainString() + " || Ya Facturada=" + qtyInvoiced.stripTrailingZeros().toPlainString() + " || Por Facturar=" + line.getQtyEntered().stripTrailingZeros().toPlainString() + " || Total=" + totalQtyInvoiced.stripTrailingZeros().toPlainString() + ").";
                }
            }
        }
        return null;
    }

    public int getAD_Client_ID() {
        return 0;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

