/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelValidInvoice2
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelValidInvoice2.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_Invoice", (ModelValidator)this);
        engine.addModelChange("C_InvoiceLine", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        Object error = "";
        if (type == 1 && po instanceof MInvoice) {
            MInvoice invoice = (MInvoice)po;
            if (this.isValidationEnabled("InvoiceDescriptionAppender", po) && this.InvoiceDescriptionAppender(invoice, po) != null) {
                error = (String)error + this.InvoiceDescriptionAppender(invoice, po);
            }
        }
        if (po instanceof MInvoiceLine) {
            MInvoiceLine il = (MInvoiceLine)po;
            if (type == 4 && this.isValidationEnabled("CommissionSetterLine", po)) {
                this.CommissionSetterLine(il, type);
            }
        }
        return error == "" ? null : error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CommissionSetterLine(MInvoiceLine il, int type) {
        boolean recalc;
        boolean bl = recalc = type == 4 || il.is_ValueChanged("M_Product_ID") || il.is_ValueChanged("PriceActual") || il.is_ValueChanged("QtyInvoiced") || il.is_ValueChanged("LineNetAmt");
        if (!recalc) {
            return;
        }
        BigDecimal pct = Env.ZERO;
        BigDecimal amt = Env.ZERO;
        int orderLineId = il.getC_OrderLine_ID();
        if (orderLineId > 0) {
            MOrderLine ol = new MOrderLine(il.getCtx(), orderLineId, il.get_TrxName());
            BigDecimal pctOL = (BigDecimal)ol.get_Value("aj_percentagefrom");
            BigDecimal amtOL = (BigDecimal)ol.get_Value("comision");
            if (pctOL != null) {
                pct = pctOL;
            }
            if (amtOL != null) {
                amt = amtOL;
            }
        } else {
            String sql = "SELECT comision_pct, comision_monto_total FROM adempiere.ajc_productcommissionfrominnvoice WHERE c_invoiceline_id=?";
            CPreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = DB.prepareStatement((String)"SELECT comision_pct, comision_monto_total FROM adempiere.ajc_productcommissionfrominnvoice WHERE c_invoiceline_id=?", (String)il.get_TrxName());
                ps.setInt(1, il.getC_InvoiceLine_ID());
                rs = ps.executeQuery();
                if (rs.next()) {
                    BigDecimal pctDB = rs.getBigDecimal(1);
                    BigDecimal amtDB = rs.getBigDecimal(2);
                    if (pctDB != null) {
                        pct = pctDB;
                    }
                    if (amtDB != null) {
                        amt = amtDB;
                    }
                }
                DB.close((ResultSet)rs, (Statement)ps);
            }
            catch (Exception e) {
                log.warning("CommissionSetterLine query failed: " + e.getMessage());
            }
            finally {
                DB.close(rs, (Statement)ps);
            }
        }
        String trxName = il.get_TrxName();
        MInvoice inv = new MInvoice(il.getCtx(), il.getC_Invoice_ID(), trxName);
        int docTypeId = inv.getC_DocTypeTarget_ID() > 0 ? inv.getC_DocTypeTarget_ID() : inv.getC_DocType_ID();
        MDocType dt = MDocType.get((Properties)il.getCtx(), (int)docTypeId);
        String docBaseType = dt != null ? dt.getDocBaseType() : null;
        boolean isCredit = "ARC".equals(docBaseType);
        if (isCredit && amt.signum() > 0) {
            amt = amt.negate();
        } else if (!isCredit && amt.signum() < 0) {
            amt = amt.negate();
        }
        if (type == 4 || type == 5) {
            DB.executeUpdateEx((String)"UPDATE C_InvoiceLine SET aj_percentagefrom=?, comision=? WHERE C_InvoiceLine_ID=?", (Object[])new Object[]{pct, amt, il.getC_InvoiceLine_ID()}, (String)il.get_TrxName());
            il.set_ValueOfColumn("aj_percentagefrom", (Object)pct);
            il.set_ValueOfColumn("comision", (Object)amt);
        }
    }

    public String docValidate(PO po, int timing) {
        Object error = "";
        MInvoice invoice = (MInvoice)po;
        if (po.get_TableName().equals("C_Invoice") && timing == 7) {
            if (this.isValidationEnabled("ValidOrderProject", po) && this.ValidOrderProject(invoice) != null) {
                error = (String)error + this.ValidOrderProject(invoice);
            }
            if (invoice.isSOTrx() && !"ARC".equals(invoice.getC_DocType().getDocBaseType()) && this.isValidationEnabled("wrongcomplete", po) && this.wrongcomplete(invoice) != null) {
                error = (String)error + this.wrongcomplete(invoice);
            }
        }
        return error == "" ? null : error;
    }

    public String ValidOrderProject(MInvoice invoice) {
        if (invoice == null || invoice.isSOTrx()) {
            return null;
        }
        int project = invoice.getC_Project_ID();
        int subproject = invoice.get_ValueAsInt("C_ProjectLine_ID");
        if (project <= 0 || subproject <= 0) {
            return "No se puede completar la factura: debe tener asignados un Proyecto y un SubProyecto.";
        }
        return null;
    }

    public String wrongcomplete(MInvoice invoice) {
        MInvoiceLine[] lines;
        for (MInvoiceLine invLine : lines = invoice.getLines(false)) {
            BigDecimal cantidadOrdenada;
            BigDecimal cantidadNueva;
            MOrderLine orderLine;
            BigDecimal yaFacturado;
            BigDecimal totalFacturado;
            if (invLine.getC_OrderLine_ID() <= 0 || invLine.getM_Product_ID() <= 0 || (totalFacturado = (yaFacturado = (orderLine = new MOrderLine(invLine.getCtx(), invLine.getC_OrderLine_ID(), invLine.get_TrxName())).getQtyInvoiced()).add(cantidadNueva = invLine.getQtyEntered())).compareTo(cantidadOrdenada = orderLine.getQtyOrdered()) <= 0) continue;
            return "No se puede completar la factura. La l\u00ednea del producto '" + invLine.getProduct().getName() + "' supera la cantidad ordenada.";
        }
        return null;
    }

    private boolean isOnlySalesInvoice(MInvoice inv) {
        String docBaseType = inv.getC_DocTypeTarget().getDocBaseType();
        return inv.isSOTrx() && "ARI".equals(docBaseType);
    }

    public String InvoiceDescriptionAppender(MInvoice invoice, PO po) {
        String contacto;
        if (!this.isOnlySalesInvoice(invoice)) {
            return null;
        }
        Object desc = invoice.getDescription() != null ? invoice.getDescription() + "\n" : "";
        String comunaDespacho = DB.getSQLValueString((String)po.get_TrxName(), (String)"SELECT cc.Name FROM C_Order co join C_BPartner_Location cb on co.C_BPartner_Location_ID=cb.C_BPartner_Location_ID join C_City cc on cb.C_City_ID=cc.C_City_ID where C_Order_ID = ?", (int)invoice.getC_Order_ID());
        String comunaFacturacion = DB.getSQLValueString((String)po.get_TrxName(), (String)"SELECT cc.Name FROM C_Order co join C_BPartner_Location cb on co.Bill_Location_ID=cb.C_BPartner_Location_ID join C_City cc on cb.C_City_ID=cc.C_City_ID where C_Order_ID = ?", (int)invoice.getC_Order_ID());
        if (comunaDespacho != null) {
            desc = (String)desc + "Comuna despacho: " + comunaDespacho + "\n";
        }
        if (comunaFacturacion != null) {
            desc = (String)desc + "Comuna facturaci\u00f3n: " + comunaFacturacion + "\n";
        }
        if (invoice.getC_Order_ID() > 0 && (contacto = DB.getSQLValueString((String)po.get_TrxName(), (String)"SELECT c.Name FROM AD_User c JOIN C_Order o ON o.SalesRep_ID = c.AD_User_ID WHERE o.C_Order_ID = ?", (int)invoice.getC_Order_ID())) != null) {
            desc = (String)desc + "Contacto cliente: " + contacto + "\n";
        }
        invoice.setDescription(((String)desc).trim());
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

