/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MLocator;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelValidInventory
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelValidInventory.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_Inventory", (ModelValidator)this);
        engine.addDocValidate("M_Inventory", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        Object error = "";
        if (!(po instanceof MInventory)) {
            return null;
        }
        MInventory inv = (MInventory)po;
        if ((type == 1 || type == 2) && this.isValidationEnabled("ValidProject", po) && this.ValidProject(inv) != null) {
            error = (String)error + this.ValidProject(inv);
        }
        return error == "" ? null : error;
    }

    public String ValidProject(MInventory inv) {
        if (inv.getC_Project_ID() <= 0) {
            return "No se puede guardar el consumo: debe tener un Proyecto asociado.";
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        Object error = "";
        if (!(po instanceof MInventory)) {
            return null;
        }
        MInventory inv = (MInventory)po;
        if (timing == 7 && this.isValidationEnabled("ValidInvStock", po) && this.ValidInvStock(inv) != null) {
            error = (String)error + this.ValidInvStock(inv);
        }
        return error == "" ? null : error;
    }

    public String ValidInvStock(MInventory inv) {
        MInventoryLine[] lines;
        String trxName = inv.get_TrxName();
        for (MInventoryLine line : lines = inv.getLines(false)) {
            int locatorId;
            int asiId;
            int productId;
            BigDecimal onHand;
            BigDecimal qtyToConsume;
            BigDecimal bigDecimal = qtyToConsume = line.getQtyInternalUse() != null ? line.getQtyInternalUse() : BigDecimal.ZERO;
            if (qtyToConsume.signum() == 0) {
                BigDecimal count;
                BigDecimal book = line.getQtyBook() != null ? line.getQtyBook() : BigDecimal.ZERO;
                BigDecimal bigDecimal2 = count = line.getQtyCount() != null ? line.getQtyCount() : BigDecimal.ZERO;
                if (count.compareTo(book) < 0) {
                    qtyToConsume = book.subtract(count);
                }
            }
            if (qtyToConsume.signum() <= 0 || (onHand = this.getQtyOnHandInLocator(productId = line.getM_Product_ID(), asiId = line.getM_AttributeSetInstance_ID(), locatorId = line.getM_Locator_ID(), trxName)).subtract(qtyToConsume).signum() >= 0) continue;
            Object pName = line.getM_Product() != null ? line.getM_Product().getName() : "ID:" + productId;
            MLocator loc = MLocator.get((Properties)inv.getCtx(), (int)locatorId);
            Object locatorName = loc != null ? loc.getValue() : "ID:" + locatorId;
            return "No se puede completar el documento de Consumo/Inventario.\nProducto: " + (String)pName + "\nUbicaci\u00f3n: " + (String)locatorName + "\nDisponible: " + String.valueOf(onHand) + "\nIntento de consumo: " + String.valueOf(qtyToConsume) + "\n=> El movimiento dejar\u00eda el stock negativo.";
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigDecimal getQtyOnHandInLocator(int M_Product_ID, int M_ASI_ID, int M_Locator_ID, String trxName) {
        StringBuilder sql = new StringBuilder().append("SELECT COALESCE(SUM(s.QtyOnHand),0) ").append("FROM M_Storage s ").append("WHERE s.M_Product_ID=? AND s.M_Locator_ID=? ");
        if (M_ASI_ID > 0) {
            sql.append("AND s.M_AttributeSetInstance_ID=? ");
        }
        try (CPreparedStatement ps = DB.prepareStatement((String)sql.toString(), (String)trxName);){
            int i = 1;
            ps.setInt(i++, M_Product_ID);
            ps.setInt(i++, M_Locator_ID);
            if (M_ASI_ID > 0) {
                ps.setInt(i++, M_ASI_ID);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return Env.ZERO;
                BigDecimal bigDecimal = rs.getBigDecimal(1);
                return bigDecimal;
            }
        }
        catch (Exception e) {
            log.warning("getQtyOnHandInLocator error: " + e.getMessage());
        }
        return Env.ZERO;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

