/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocator;
import org.compiere.model.MOrder;
import org.compiere.model.MProduct;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelValidInOut
extends AbstractValidatingEKModel
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelValidInOut.class);

    public void initialize(ModelValidationEngine engine, MClient client) {
        engine.addDocValidate("M_InOut", (ModelValidator)this);
        engine.addModelChange("M_InOut", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        MInOut io;
        Object error = "";
        if (type == 4 && po instanceof MInOut && (io = (MInOut)po).isSOTrx() && this.isValidationEnabled("dteDocumentTypeSet", po) && this.dteDocumentTypeSet(io) != null) {
            error = (String)error + this.dteDocumentTypeSet(io);
        }
        return error == "" ? null : error;
    }

    private String dteDocumentTypeSet(MInOut io) {
        if (io.getC_Order_ID() <= 0) {
            return null;
        }
        MOrder nv = new MOrder(io.getCtx(), io.getC_Order_ID(), io.get_TrxName());
        if (nv.getC_BPartner_Location_ID() != nv.getBill_Location_ID()) {
            MDocType dt = MDocType.get((Properties)io.getCtx(), (int)nv.getC_DocType_ID());
            int newDt_id = dt.get_ValueAsInt("C_DocTypeShipmentDTE_ID");
            if (newDt_id > 0) {
                io.setC_DocType_ID(dt.get_ValueAsInt("C_DocTypeShipmentDTE_ID"));
                io.saveEx();
            } else {
                return "Tipo de Documento DTE para la Entrega no seteado (C_DocTypeShipmentDTE_ID=null).";
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        MInOut io;
        Object error = "";
        if (timing == 7 && po instanceof MInOut && (io = (MInOut)po).isSOTrx()) {
            if (this.isValidationEnabled("movementDateOnComplete", po) && this.movementDateOnComplete(io) != null) {
                error = (String)error + this.movementDateOnComplete(io);
            }
            if (this.isValidationEnabled("ValidInOutStock", po) && this.ValidInOutStock(io, timing) != null) {
                error = (String)error + this.ValidInOutStock(io, timing);
            }
        }
        return error == "" ? null : error;
    }

    private String movementDateOnComplete(MInOut io) {
        io.setMovementDate(new Timestamp(System.currentTimeMillis()));
        io.setDateAcct(new Timestamp(System.currentTimeMillis()));
        if (!io.save()) {
            return "Error al tratar guardar:" + io.getProcessMsg();
        }
        return null;
    }

    public String ValidInOutStock(MInOut io, int timing) {
        String trxName = io.get_TrxName();
        MDocType dt = MDocType.get((Properties)io.getCtx(), (int)io.getC_DocType_ID());
        if (dt == null || !"MMS".equals(dt.getDocBaseType())) {
            return null;
        }
        if (io.isReversal()) {
            return null;
        }
        try {
            MInOutLine[] lines = io.getLines();
            if (lines == null || lines.length == 0) {
                return null;
            }
            for (MInOutLine l : lines) {
                int asiId;
                int locatorId;
                BigDecimal qty;
                if (l.getM_Product_ID() <= 0 || l.getM_Locator_ID() <= 0 || (qty = l.getQtyEntered()) == null || qty.signum() == 0) continue;
                BigDecimal consume = qty.abs();
                int productId = l.getM_Product_ID();
                BigDecimal onHand = this.getQtyOnHandInLocator(productId, locatorId = l.getM_Locator_ID(), asiId = l.getM_AttributeSetInstance_ID());
                if (onHand == null) {
                    onHand = Env.ZERO;
                }
                if (onHand.compareTo(consume) >= 0) continue;
                MProduct prod = MProduct.get(io.getCtx(), productId);
                MLocator loc = new MLocator(io.getCtx(), locatorId, trxName);
                return "No se puede completar la Entrega porque quedar\u00eda stock negativo.\nProducto: " + prod.getValue() + " - " + prod.getName() + "\nLocator: " + (String)(loc != null ? loc.getValue() : "ID=" + locatorId) + "\nStock disponible: " + String.valueOf(onHand) + "\nRequerido: " + String.valueOf(consume);
            }
            return null;
        }
        catch (Exception ex) {
            return "Error validando stock en M_InOut: " + ex.getMessage();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BigDecimal getQtyOnHandInLocator(int M_Product_ID, int M_Locator_ID, int M_ASI_ID) {
        String baseSql = "SELECT COALESCE(SUM(s.QtyOnHand),0) FROM M_Storage s WHERE s.M_Product_ID=? AND s.M_Locator_ID=? ";
        String sql = "SELECT COALESCE(SUM(s.QtyOnHand),0) FROM M_Storage s WHERE s.M_Product_ID=? AND s.M_Locator_ID=? " + (M_ASI_ID > 0 ? "AND s.M_AttributeSetInstance_ID=? " : "");
        try (CPreparedStatement ps = DB.prepareStatement((String)sql, null);){
            int i = 1;
            ps.setInt(i++, M_Product_ID);
            ps.setInt(i++, M_Locator_ID);
            if (M_ASI_ID > 0) {
                ps.setInt(i++, M_ASI_ID);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return Env.ZERO;
                BigDecimal bd = rs.getBigDecimal(1);
                BigDecimal bigDecimal = bd != null ? bd : Env.ZERO;
                return bigDecimal;
            }
        }
        catch (Exception e) {
            log.warning("getQtyOnHandInLocator error: " + e.getMessage());
        }
        return Env.ZERO;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

