/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MCharge;
import org.compiere.model.MClient;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKModelProyectOrderGenerate
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelProyectOrderGenerate.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (timing != 9 || !(po instanceof MOrder)) {
            return null;
        }
        try {
            BigDecimal totalQty;
            BigDecimal totalAmt;
            MOrder ord = (MOrder)po;
            if (!ord.isSOTrx()) {
                return null;
            }
            String pb = ord.getC_BPartner().getC_BP_Group().getPriorityBase();
            if (pb == null || !pb.equals("H")) {
                return null;
            }
            if (ord.getC_Project_ID() > 0) {
                return null;
            }
            Properties ctx = po.getCtx();
            String trxName = po.get_TrxName();
            MProject proj = new MProject(ctx, 0, trxName);
            proj.setC_BPartner_ID(ord.getC_BPartner_ID());
            int ORDER_CURRENCY_ID = ord.getC_Currency_ID();
            proj.setC_Currency_ID(ORDER_CURRENCY_ID);
            Object projectName = (String)(ord.getDocumentNo() != null ? ord.getDocumentNo() : "ORD-" + ord.getC_Order_ID()) + " - " + (ord.getC_BPartner() != null && ord.getC_BPartner().getName() != null ? ord.getC_BPartner().getName() : "Sin BP") + (String)(ord.getDescription() != null && !ord.getDescription().isBlank() ? " - " + ord.getDescription().replace("\n", " ") : "");
            if (((String)projectName).length() > 60) {
                projectName = ((String)projectName).substring(0, 60);
            }
            proj.setName((String)projectName);
            try {
                int statusCatId = this.findProjectStatusCategoryEnProceso(ctx, trxName, ord.getAD_Client_ID());
                if (statusCatId > 0) {
                    proj.set_ValueOfColumn("C_ProjectStatusCategory_ID", (Object)statusCatId);
                }
            }
            catch (Exception ignore) {
                log.fine("Columna C_ProjectStatusCategory_ID no disponible o no seteable: " + ignore.getMessage());
            }
            proj.saveEx();
            ord.setC_Project_ID(proj.getC_Project_ID());
            ord.saveEx();
            HashMap<Integer, BigDecimal> prodAmtMap = new HashMap<Integer, BigDecimal>();
            HashMap<Integer, BigDecimal> prodQtyMap = new HashMap<Integer, BigDecimal>();
            HashMap<Integer, BigDecimal> chargeAmtMap = new HashMap<Integer, BigDecimal>();
            HashMap<Integer, BigDecimal> chargeQtyMap = new HashMap<Integer, BigDecimal>();
            int priceScale = Math.max(2, MCurrency.getStdPrecision((Properties)ctx, (int)ORDER_CURRENCY_ID));
            MOrderLine[] lines = ord.getLines(true, null);
            if (lines != null) {
                for (MOrderLine line : lines) {
                    BigDecimal lineQty;
                    if (line == null) continue;
                    BigDecimal lineAmt = line.getLineNetAmt();
                    if (lineAmt == null) {
                        lineAmt = Env.ZERO;
                    }
                    if ((lineQty = line.getQtyOrdered()) == null) {
                        lineQty = Env.ZERO;
                    }
                    int productID = line.getM_Product_ID();
                    int chargeID = line.getC_Charge_ID();
                    if (productID > 0) {
                        prodAmtMap.merge(productID, lineAmt, BigDecimal::add);
                        prodQtyMap.merge(productID, lineQty, BigDecimal::add);
                        continue;
                    }
                    if (chargeID > 0) {
                        chargeAmtMap.merge(chargeID, lineAmt, BigDecimal::add);
                        chargeQtyMap.merge(chargeID, lineQty, BigDecimal::add);
                        continue;
                    }
                    log.fine("L\u00ednea sin producto ni cargo, C_OrderLine_ID=" + line.getC_OrderLine_ID());
                }
            }
            for (Map.Entry entry : prodAmtMap.entrySet()) {
                MProduct prod;
                int prodId = (Integer)entry.getKey();
                totalAmt = (BigDecimal)entry.getValue();
                totalQty = prodQtyMap.getOrDefault(prodId, Env.ZERO);
                String productName = "Sin producto";
                int categoryId = 0;
                String categoryName = "Sin categor\u00eda";
                if (prodId > 0 && (prod = new MProduct(ctx, prodId, trxName)).get_ID() > 0) {
                    MProductCategory cat;
                    if (prod.getName() != null) {
                        productName = prod.getName();
                    }
                    if ((categoryId = prod.getM_Product_Category_ID()) > 0 && (cat = new MProductCategory(ctx, categoryId, trxName)).get_ID() > 0 && cat.getName() != null) {
                        categoryName = cat.getName();
                    }
                }
                MProjectLine pLine = new MProjectLine(proj);
                pLine.setAD_Org_ID(proj.getAD_Org_ID());
                if (prodId > 0) {
                    pLine.setM_Product_ID(prodId);
                }
                try {
                    if (categoryId > 0) {
                        pLine.set_ValueOfColumn("M_Product_Category_ID", (Object)categoryId);
                    }
                }
                catch (Exception cat) {
                    // empty catch block
                }
                pLine.setDescription("Producto: " + productName + " | Categor\u00eda: " + categoryName);
                pLine.setPlannedQty(totalQty != null ? totalQty : Env.ZERO);
                pLine.setPlannedAmt(totalAmt != null ? totalAmt : Env.ZERO);
                BigDecimal plannedPrice = Env.ZERO;
                if (totalQty != null && totalQty.signum() != 0) {
                    plannedPrice = totalAmt.divide(totalQty, priceScale, RoundingMode.HALF_UP);
                }
                pLine.setPlannedPrice(plannedPrice);
                pLine.saveEx();
            }
            for (Map.Entry entry : chargeAmtMap.entrySet()) {
                MCharge ch;
                int chargeId = (Integer)entry.getKey();
                totalAmt = (BigDecimal)entry.getValue();
                totalQty = chargeQtyMap.getOrDefault(chargeId, Env.ZERO);
                String chargeName = "Cargo";
                if (chargeId > 0 && (ch = new MCharge(ctx, chargeId, trxName)).get_ID() > 0 && ch.getName() != null) {
                    chargeName = ch.getName();
                }
                MProjectLine pLine = new MProjectLine(proj);
                pLine.setAD_Org_ID(proj.getAD_Org_ID());
                if (chargeId > 0) {
                    pLine.set_ValueOfColumn("C_Charge_ID", (Object)chargeId);
                }
                pLine.setDescription("Cargo: " + chargeName);
                pLine.setPlannedQty(totalQty != null ? totalQty : Env.ZERO);
                pLine.setPlannedAmt(totalAmt != null ? totalAmt : Env.ZERO);
                BigDecimal plannedPrice = Env.ZERO;
                if (totalQty != null && totalQty.signum() != 0) {
                    plannedPrice = totalAmt.divide(totalQty, priceScale, RoundingMode.HALF_UP);
                }
                pLine.setPlannedPrice(plannedPrice);
                pLine.saveEx();
            }
            log.info("Proyecto creado y vinculado: C_Project_ID=" + proj.getC_Project_ID());
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Error en EKModelProyectOrderGenerate", (Throwable)ex);
        }
        return null;
    }

    private int findProjectStatusCategoryEnProceso(Properties ctx, String trxName, int clientId) {
        String sql = "SELECT C_ProjectStatusCategory_ID FROM C_ProjectStatusCategory WHERE IsActive='Y' AND AD_Client_ID IN (?,0) AND Name ILIKE '%En Proceso%' ORDER BY AD_Client_ID DESC, IsDefault DESC, C_ProjectStatusCategory_ID";
        return DB.getSQLValueEx((String)trxName, (String)"SELECT C_ProjectStatusCategory_ID FROM C_ProjectStatusCategory WHERE IsActive='Y' AND AD_Client_ID IN (?,0) AND Name ILIKE '%En Proceso%' ORDER BY AD_Client_ID DESC, IsDefault DESC, C_ProjectStatusCategory_ID", (Object[])new Object[]{clientId});
    }

    public int getAD_Client_ID() {
        return 0;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

