/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.model.MClient;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class EKModelProdQtySignValidator
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(EKModelProdQtySignValidator.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("M_ProductionLine", (ModelValidator)this);
        engine.addDocValidate("M_Production", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        BigDecimal qty;
        if (!(po instanceof MProductionLine)) {
            return null;
        }
        if (type != 1 && type != 2) {
            return null;
        }
        if (type == 2 && !po.is_ValueChanged("MovementQty") && !po.is_ValueChanged("IsEndProduct")) {
            return null;
        }
        if ("Y".equals(Env.getContext((Properties)po.getCtx(), (String)"EK.SkipProdQtySign"))) {
            return null;
        }
        MProductionLine line = (MProductionLine)po;
        if (line.getM_Production_ID() <= 0) {
            return null;
        }
        BigDecimal bigDecimal = qty = line.getMovementQty() != null ? line.getMovementQty() : Env.ZERO;
        if (qty.signum() == 0) {
            return null;
        }
        boolean isEndProduct = line.isEndProduct();
        String productionTypeName = line.getM_Production().getC_DocType().getName();
        if (!line.getM_Production().getC_DocType().getName().toLowerCase().contains("desempaque")) {
            if (qty.signum() > 0 && !isEndProduct) {
                return "Solo el 'Producto final' puede tener cantidad positiva en " + productionTypeName;
            }
            if (qty.signum() < 0 && isEndProduct) {
                return "El 'Producto final' debe tener cantidad positiva en " + productionTypeName;
            }
        } else {
            if (qty.signum() > 0 && isEndProduct) {
                return "El 'Producto final' debe tener cantidad negativa en " + productionTypeName;
            }
            if (qty.signum() < 0 && !isEndProduct) {
                return "Solo el 'Producto final' puede tener cantidad negativa en " + productionTypeName;
            }
        }
        return null;
    }

    public String docValidate(PO po, int timing) {
        if (!(po instanceof MProduction)) {
            return null;
        }
        if (timing == 2 || timing == 6 || timing == 5) {
            Env.setContext((Properties)po.getCtx(), (String)"EK.SkipProdQtySign", (String)"Y");
            log.info("EK.SkipProdQtySign=Y (timing=" + timing + ") for M_Production_ID=" + po.get_ID());
        }
        if (timing == 10 || timing == 14 || timing == 13) {
            Env.setContext((Properties)po.getCtx(), (String)"EK.SkipProdQtySign", (String)"N");
        }
        return null;
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

