/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.ajah.model.AbstractValidatingEKModel;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MClient;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class EKModelCreditNoteAutoAllocator
extends AbstractValidatingEKModel
implements ModelValidator {
    private static final CLogger log = CLogger.getCLogger(EKModelCreditNoteAutoAllocator.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Invoice", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) {
        return null;
    }

    public String docValidate(PO po, int timing) {
        MOrder srcOrder;
        MDocType orderDT;
        if (!(po instanceof MInvoice)) {
            return null;
        }
        MInvoice creditNote = (MInvoice)po;
        int srcOrderID = creditNote.getC_Order_ID();
        if (srcOrderID > 0 && "WR".equals((orderDT = MDocType.get((Properties)(srcOrder = new MOrder(creditNote.getCtx(), srcOrderID, creditNote.get_TrxName())).getCtx(), (int)srcOrder.getC_DocType_ID())).getDocSubTypeSO())) {
            log.fine("NC derivada de devoluci\u00f3n WR, se salta auto-asignaci\u00f3n.");
            return null;
        }
        MDocType docType = MDocType.get((Properties)creditNote.getCtx(), (int)creditNote.getC_DocTypeTarget_ID());
        if (!"ARC".equals(docType.getDocBaseType())) {
            return null;
        }
        if (timing == 7) {
            boolean hasRef;
            int refInvoiceID = creditNote.get_ValueAsInt("AJ_RefDoc_ID");
            int orderID = creditNote.getC_Order_ID();
            boolean bl = hasRef = refInvoiceID > 0 || orderID > 0;
            if (!hasRef) {
                return "Debe indicar una referencia: Factura (AJ_RefDoc_ID) o Nota de Venta/Pedido (C_Order_ID).";
            }
            String codRef = creditNote.get_ValueAsString("AJ_CodRef");
            String reasonRef = creditNote.get_ValueAsString("AJ_ReasonRef");
            if (Util.isEmpty((String)codRef, (boolean)true) || Util.isEmpty((String)reasonRef, (boolean)true)) {
                return "Debe indicar el Tipo de referencia (AJ_CodRef) y el Motivo (AJ_ReasonRef).";
            }
            return null;
        }
        if (timing == 9) {
            if (!"ARC".equals(docType.getDocBaseType())) {
                return null;
            }
            int refInvoiceID = creditNote.get_ValueAsInt("AJ_RefDoc_ID");
            if (refInvoiceID <= 0) {
                return "No se encontr\u00f3 la factura de referencia (AJ_RefDoc_ID)";
            }
            MInvoice invoice = new MInvoice(creditNote.getCtx(), refInvoiceID, creditNote.get_TrxName());
            if (invoice.getC_Currency_ID() != creditNote.getC_Currency_ID()) {
                return "Monedas distintas. No se puede asignar autom\u00e1ticamente.";
            }
            if (this.alreadyAllocated(creditNote.getC_Invoice_ID(), invoice.getC_Invoice_ID(), creditNote.get_TrxName())) {
                return "Ya existe una asignaci\u00f3n entre esta NC y la factura original.";
            }
            BigDecimal invoiceOpen = invoice.getOpenAmt(true, null);
            BigDecimal creditOpen = creditNote.getOpenAmt(true, null).abs();
            if (invoiceOpen.signum() <= 0 || creditOpen.signum() <= 0) {
                return "No hay monto abierto para asignar.";
            }
            this.createAllocation(creditNote, invoice);
        }
        return null;
    }

    private boolean alreadyAllocated(int invoiceID1, int invoiceID2, String trxName) {
        String sql = "SELECT COUNT(*) FROM C_AllocationLine WHERE C_Invoice_ID IN (?, ?) GROUP BY C_AllocationHdr_ID HAVING COUNT(DISTINCT C_Invoice_ID) = 2";
        int count = DB.getSQLValue((String)trxName, (String)sql, (int)invoiceID1, (int)invoiceID2);
        return count > 0;
    }

    private void createAllocation(MInvoice creditNote, MInvoice invoice) {
        BigDecimal invoiceOpen = invoice.getOpenAmt(true, null);
        BigDecimal creditOpen = creditNote.getOpenAmt(true, null).abs();
        BigDecimal amountToAllocate = creditOpen.min(invoiceOpen);
        if (amountToAllocate.signum() <= 0) {
            throw new AdempiereException("No hay monto v\u00e1lido para asignar entre NC y factura.");
        }
        MAllocationHdr alloc = new MAllocationHdr(creditNote.getCtx(), false, creditNote.getDateInvoiced(), creditNote.getC_Currency_ID(), "AutoAsignaci\u00f3n NC al completar", creditNote.get_TrxName());
        alloc.setAD_Org_ID(creditNote.getAD_Org_ID());
        alloc.saveEx();
        MAllocationLine line1 = new MAllocationLine(alloc, amountToAllocate, Env.ZERO, Env.ZERO, Env.ZERO);
        line1.setC_Invoice_ID(invoice.getC_Invoice_ID());
        line1.setAD_Org_ID(invoice.getAD_Org_ID());
        line1.saveEx();
        MAllocationLine line2 = new MAllocationLine(alloc, amountToAllocate.negate(), Env.ZERO, Env.ZERO, Env.ZERO);
        line2.setC_Invoice_ID(creditNote.getC_Invoice_ID());
        line2.setAD_Org_ID(creditNote.getAD_Org_ID());
        line2.saveEx();
        if (!alloc.processIt("CO")) {
            throw new AdempiereException("Error al completar asignaci\u00f3n: " + alloc.getProcessMsg());
        }
        alloc.saveEx();
        creditNote = new MInvoice(creditNote.getCtx(), creditNote.getC_Invoice_ID(), creditNote.get_TrxName());
        if (creditNote.getOpenAmt(true, null).signum() == 0) {
            creditNote.set_CustomColumn("IsPaid", true);
            creditNote.saveEx();
        }
    }

    public int getAD_Client_ID() {
        return Env.getAD_Client_ID((Properties)Env.getCtx());
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }
}

