/*
 * Decompiled with CFR 0.152.
 */
package org.ajah.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCashBook;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.MProduct;
import org.compiere.model.MProduction;
import org.compiere.model.MProductionBatch;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class EKCallout
extends CalloutEngine {
    public String orderLineCopyAttributeDesc(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer M_AttributeSetInstance_ID = (Integer)value;
        if (M_AttributeSetInstance_ID == null || M_AttributeSetInstance_ID == 0) {
            return "";
        }
        MAttributeSetInstance masi = new MAttributeSetInstance(ctx, M_AttributeSetInstance_ID, null);
        String sql = "select ma.name||':'||mai.value as attribute from m_attributeinstance mai join m_attribute ma on ma.m_attribute_id=mai.m_attribute_id join m_attributeuse mau on (mau.m_attribute_id=ma.m_attribute_id and mau.m_attributeset_id=?) where m_attributesetinstance_id=? order by mau.seqno";
        CPreparedStatement ps = null;
        ResultSet rs = null;
        String serno = masi.getSerNo() == null ? "" : "N\u00b0Serie:" + masi.getSerNo().concat(" | ");
        String lot = masi.getLot() == null ? "" : "Lote:" + masi.getLot().concat(" | ");
        Object desc = serno + lot;
        try {
            ps = DB.prepareStatement((String)sql, null);
            ps.setInt(1, masi.getM_AttributeSet_ID());
            ps.setInt(2, masi.getM_AttributeSetInstance_ID());
            rs = ps.executeQuery();
            while (rs.next()) {
                desc = ((String)desc).concat(rs.getString("attribute").concat("|"));
            }
        }
        catch (Exception e) {
            return "Error:" + String.valueOf(e);
        }
        mTab.setValue("Description", desc);
        return "";
    }

    public String adjustmentAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Object line;
        int decimalPrecision = 2;
        if (mTab.getValue("C_InvoiceLine_ID") != null) {
            line = new MInvoiceLine(ctx, ((Integer)mTab.getValue("C_InvoiceLine_ID")).intValue(), null);
            decimalPrecision = line.getPrecision();
        } else if (mTab.getValue("C_OrderLine_ID") != null) {
            line = new MOrderLine(ctx, (Integer)mTab.getValue("C_OrderLine_ID"), null);
            decimalPrecision = ((MOrderLine)((Object)line)).getPrecision();
        }
        BigDecimal lineNetAmt = (BigDecimal)mTab.getValue("LineNetAmt");
        BigDecimal finalTotal = lineNetAmt.add((BigDecimal)value).setScale(decimalPrecision, RoundingMode.HALF_UP);
        mTab.setValue("LineNetAmt", (Object)finalTotal);
        return "";
    }

    public String mustBeStockedReplication(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Integer mpb_id = (Integer)mTab.getValue("M_ProductionBatch_ID");
        if (mpb_id == null || mpb_id <= 0) {
            return "";
        }
        Object raw = value != null ? value : mTab.getValue(mField.getColumnName());
        boolean mustBeStocked = Boolean.TRUE.equals(raw) || "Y".equals(raw);
        int mp_id = DB.getSQLValue(null, (String)"SELECT m_production_id FROM m_production WHERE m_productionbatch_id=?", (int)mpb_id);
        if (mp_id > 0) {
            MProduction mp = new MProduction(ctx, mp_id, null);
            mp.setMustBeStocked(mustBeStocked);
            mp.saveEx();
        }
        return "";
    }

    public String productTypeChanged(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        String productType = (String)value;
        if ("I".equals(productType)) {
            mTab.setValue("IsStocked", (Object)"Y");
        }
        return "";
    }

    public String MustBeStockedChanged(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        boolean mustBeStocked = (Boolean)value;
        Integer mpb_id = (Integer)mTab.getValue("M_ProductionBatch_ID");
        if (mpb_id == null || mpb_id <= 0) {
            return "";
        }
        ArrayList<MProduction> productions = new ArrayList<MProduction>();
        String sql = "SELECT M_Production_ID FROM M_Production WHERE M_ProductionBatch_ID = ?";
        try (CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);){
            pstmt.setInt(1, mpb_id);
            try (ResultSet rs = pstmt.executeQuery();){
                while (rs.next()) {
                    MProduction production = new MProduction(ctx, rs.getInt("M_Production_ID"), null);
                    productions.add(production);
                }
            }
        }
        catch (Exception e) {
            this.log.severe("ERROR: " + e.getMessage());
            return "Error al obtener producciones.";
        }
        for (MProduction production : productions) {
            if (!mustBeStocked) continue;
            MProductionBatch mpb = new MProductionBatch(ctx, mpb_id.intValue(), null);
            production.set_CustomColumn("MustBeStocked", mustBeStocked);
            production.saveEx();
        }
        return "";
    }

    public String beginningCashBalance(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        int cb_id = (Integer)mTab.getValue("C_CashBook_ID");
        MCashBook cb = MCashBook.get((Properties)ctx, (int)cb_id);
        BigDecimal amt = (BigDecimal)cb.get_Value("BalanceAmount");
        this.log.warning("SALDO==> " + String.valueOf(amt));
        if (cb.get_Value("BalanceAmount") == null) {
            return "";
        }
        mTab.setValue("BeginningBalance", cb.get_Value("BalanceAmount"));
        return "";
    }

    public String setAttributeInstance(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        mTab.setValue("M_AttributeSetInstance_ID", value);
        return "";
    }

    public String setDateAcct(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Object trxType = mTab.getValue("IsSOTrx");
        boolean isSOTrx = false;
        if (trxType instanceof Boolean) {
            isSOTrx = (Boolean)trxType;
        } else if (trxType instanceof String) {
            isSOTrx = "Y".equals(trxType);
        }
        if (isSOTrx) {
            return "";
        }
        String docStatus = (String)mTab.getValue("DocStatus");
        if ("CO".equals(docStatus) || "CL".equals(docStatus)) {
            return "";
        }
        Timestamp dateInvoiced = (Timestamp)value;
        Timestamp currentDateAcct = (Timestamp)mTab.getValue("DateAcct");
        if (currentDateAcct != null && currentDateAcct.equals(dateInvoiced)) {
            return "";
        }
        mTab.setValue("DateAcct", (Object)dateInvoiced);
        return "";
    }

    public String setAmtFromPaymentOpenAmt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (mTab.getValue("Ref_Payment_ID") == null) {
            mTab.setValue("Amt", (Object)0);
            return "";
        }
        MPayment pay = new MPayment(ctx, (Integer)mTab.getValue("Ref_Payment_ID"), null);
        BigDecimal openAmt = (BigDecimal)pay.get_Value("OpenAmt");
        if (openAmt.compareTo(Env.ZERO) <= 0) {
            return "Pago no tiene saldo pendiente.";
        }
        mTab.setValue("Amt", (Object)openAmt);
        return "";
    }

    public String onChange(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Timestamp newDateAcct = (Timestamp)value;
        int tableID = mTab.getAD_Table_ID();
        int recordID = mTab.getRecord_ID();
        if (recordID == 0) {
            return "";
        }
        int periodID = MPeriod.getC_Period_ID((Properties)ctx, (Timestamp)newDateAcct, (int)Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Org_ID"));
        if (periodID <= 0) {
            return "No se encontr\u00f3 un per\u00edodo contable para la nueva fecha.";
        }
        List facts = new Query(ctx, "Fact_Acct", "AD_Table_ID=? AND Record_ID=?", null).setParameters(new Object[]{tableID, recordID}).list();
        for (MFactAcct fact : facts) {
            fact.setDateAcct(newDateAcct);
            fact.setC_Period_ID(periodID);
            fact.saveEx();
        }
        if (mTab.getField("C_Period_ID") != null) {
            mTab.setValue("C_Period_ID", (Object)periodID);
        }
        return "";
    }

    public String dateAcct(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || value == null || !(value instanceof Timestamp)) {
            return "";
        }
        Object tender = mTab.getValue("TenderType");
        if ("K".equals(tender)) {
            return "";
        }
        mTab.setValue("DateAcct", value);
        return "";
    }

    public String PaymentBankAccount(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        MBankAccount ba;
        if (value == null) {
            return "";
        }
        String tenderType = (String)mTab.getValue("TenderType");
        if (tenderType != null) {
            tenderType = tenderType.toUpperCase();
        }
        boolean isCard = "C".equals(tenderType) || "D".equals(tenderType);
        String medioPago = (String)mTab.getValue("AJ_TenderTypeRef");
        if ("TR".equalsIgnoreCase(medioPago)) {
            medioPago = "Transbank";
        } else if ("GT".equalsIgnoreCase(medioPago)) {
            medioPago = "Getnet";
        } else if ("MP".equalsIgnoreCase(medioPago)) {
            medioPago = "Pago";
        }
        if (isCard && medioPago != null && !medioPago.isEmpty() && (ba = (MBankAccount)new Query(ctx, "C_BankAccount", "UPPER(AccountNo) LIKE ?", null).setParameters(new Object[]{"%" + medioPago.toUpperCase() + "%"}).setClient_ID().setOrderBy("IsDefault DESC").first()) != null) {
            mTab.setValue("C_BankAccount_ID", (Object)ba.get_ID());
        }
        return null;
    }

    public String setScheduleSlotName(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Object newDescription;
        if (value == null) {
            return "";
        }
        String sql = "SELECT Name FROM AJC_ScheduleSlots WHERE AJC_ScheduleSlots_ID = ?";
        int scheduleSlotID = (Integer)value;
        String name = DB.getSQLValueString(null, (String)sql, (int)scheduleSlotID);
        if (name == null || name.isEmpty()) {
            return "";
        }
        String currentDescription = (String)mTab.getValue("Description");
        if (currentDescription == null) {
            currentDescription = "";
        }
        if (!((String)(newDescription = currentDescription.trim())).isEmpty()) {
            newDescription = (String)newDescription + " - ";
        }
        newDescription = (String)newDescription + name;
        mTab.setValue("Description", newDescription);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String onDeliveryViaChange(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        String newDeliveryVia = value.toString();
        boolean isSOTrx = "Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"IsSOTrx"));
        if (!isSOTrx) {
            return "";
        }
        Integer C_BPartner_ID = (Integer)mTab.getValue("C_BPartner_ID");
        if (C_BPartner_ID == null || C_BPartner_ID <= 0) {
            return "";
        }
        if ("H".equals(newDeliveryVia)) {
            String sql = "SELECT AJC_ScheduleSlots_ID FROM C_BPartner WHERE C_BPartner_ID = ?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement((String)sql, null);
                pstmt.setInt(1, C_BPartner_ID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    int scheduleSlotID = rs.getInt("AJC_ScheduleSlots_ID");
                    if (!rs.wasNull()) {
                        mTab.setValue("AJC_ScheduleSlots_ID", (Object)scheduleSlotID);
                    } else {
                        mTab.setValue("AJC_ScheduleSlots_ID", null);
                    }
                }
                DB.close((ResultSet)rs, (Statement)pstmt);
            }
            catch (Exception e) {
                String string = e.getMessage();
                return string;
            }
            finally {
                DB.close(rs, (Statement)pstmt);
            }
        } else {
            mTab.setValue("AJC_ScheduleSlots_ID", null);
        }
        return "";
    }

    public String onReadyForApprovalChange(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        boolean isChecked = false;
        isChecked = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value.toString());
        if (!isChecked) {
            return "";
        }
        Integer C_Order_ID = (Integer)mTab.getValue("C_Order_ID");
        if (C_Order_ID == null || C_Order_ID <= 0) {
            return "";
        }
        Timestamp existingDate = (Timestamp)mTab.getValue("Dateprocessed");
        if (existingDate != null) {
            return "";
        }
        Timestamp now = new Timestamp(System.currentTimeMillis());
        mTab.setValue("Dateprocessed", (Object)now);
        return "";
    }

    public String lineWeightVolume(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        int SCALE = 4;
        Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
        if (M_Product_ID == null || M_Product_ID <= 0) {
            mTab.setValue("Weight", null);
            mTab.setValue("Volume", null);
            return "";
        }
        BigDecimal qtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
        if (qtyEntered == null) {
            qtyEntered = Env.ZERO;
        }
        if (qtyEntered.signum() <= 0) {
            mTab.setValue("Weight", (Object)Env.ZERO.setScale(SCALE, RoundingMode.HALF_UP));
            mTab.setValue("Volume", (Object)Env.ZERO.setScale(SCALE, RoundingMode.HALF_UP));
            return "";
        }
        MProduct product = MProduct.get(ctx, M_Product_ID);
        BigDecimal unitWeight = product.getWeight() != null ? product.getWeight() : Env.ZERO;
        BigDecimal unitVolume = product.getVolume() != null ? product.getVolume() : Env.ZERO;
        BigDecimal lineWeight = unitWeight.multiply(qtyEntered).setScale(SCALE, RoundingMode.HALF_UP);
        BigDecimal lineVolume = unitVolume.multiply(qtyEntered).setScale(SCALE, RoundingMode.HALF_UP);
        mTab.setValue("Weight", (Object)lineWeight);
        mTab.setValue("Volume", (Object)lineVolume);
        return "";
    }

    public String setDesignInDescription(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String existingDesign;
        if (value == null) {
            String cleaned;
            String currentDesc = (String)mTab.getValue("Description");
            if (currentDesc != null && !(cleaned = this.removeDesignTag(currentDesc)).equals(currentDesc)) {
                mTab.setValue("Description", (Object)cleaned.trim());
            }
            return "";
        }
        if (!(value instanceof Integer)) {
            return "";
        }
        int ajcDesignsId = (Integer)value;
        if (ajcDesignsId <= 0) {
            return "";
        }
        String designName = null;
        try {
            designName = mField != null && mField.getLookup() != null ? mField.getLookup().getDisplay(value) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (designName == null || designName.trim().isEmpty()) {
            return "";
        }
        designName = designName.trim();
        String currentDesc = (String)mTab.getValue("Description");
        if (currentDesc == null) {
            currentDesc = "";
        }
        if (designName.equalsIgnoreCase(existingDesign = this.extractDesignTagValue(currentDesc))) {
            return "";
        }
        String base = this.removeDesignTag(currentDesc).trim();
        String newDesc = base.isEmpty() ? "Dise\u00f1o: " + designName : base + " | Dise\u00f1o: " + designName;
        mTab.setValue("Description", (Object)newDesc);
        return "";
    }

    private String removeDesignTag(String text) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        String withoutMiddle = text.replaceAll("(?i)\\s*\\|\\s*Dise\u00f1o:\\s*[^|]+", "");
        String withoutLeading = withoutMiddle.replaceAll("(?i)^\\s*Dise\u00f1o:\\s*[^|]+\\s*\\|?\\s*", "");
        return withoutLeading.replaceAll("\\s*\\|\\s*(\\|\\s*)+", " | ").trim();
    }

    private String extractDesignTagValue(String text) {
        if (text == null) {
            return null;
        }
        Matcher m = Pattern.compile("(?i)Dise\u00f1o:\\s*([^|]+)").matcher(text);
        return m.find() ? m.group(1).trim() : null;
    }

    public String setASIInDescription(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null || (Integer)value <= 0) {
            return "";
        }
        int M_AttributeSetInstance_ID = (Integer)value;
        MAttributeSetInstance masi = new MAttributeSetInstance(ctx, M_AttributeSetInstance_ID, null);
        String sql = "SELECT ma.name || ':' || mai.value FROM m_attributeinstance mai JOIN m_attribute ma ON ma.m_attribute_id=mai.m_attribute_id JOIN m_attributeuse mau ON (mau.m_attribute_id=ma.m_attribute_id AND mau.m_attributeset_id=?) WHERE m_attributesetinstance_id=? ORDER BY mau.seqno";
        StringBuilder asiDesc = new StringBuilder();
        try (CPreparedStatement ps = DB.prepareStatement((String)sql, null);){
            ps.setInt(1, masi.getM_AttributeSet_ID());
            ps.setInt(2, masi.getM_AttributeSetInstance_ID());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    if (asiDesc.length() > 0) {
                        asiDesc.append(" | ");
                    }
                    asiDesc.append(rs.getString(1));
                }
            }
        }
        catch (Exception e) {
            return "";
        }
        if (masi.getSerNo() != null && !masi.getSerNo().trim().isEmpty()) {
            if (asiDesc.length() > 0) {
                asiDesc.insert(0, " | ");
            }
            asiDesc.insert(0, "N\u00b0Serie:" + masi.getSerNo());
        }
        if (masi.getLot() != null && !masi.getLot().trim().isEmpty()) {
            if (asiDesc.length() > 0) {
                asiDesc.insert(0, " | ");
            }
            asiDesc.insert(0, "Lote:" + masi.getLot());
        }
        String newAsiBlock = "ASI:[" + asiDesc.toString() + "]";
        String currentDesc = (String)mTab.getValue("Description");
        if (currentDesc == null) {
            currentDesc = "";
        }
        String cleaned = currentDesc.trim();
        String finalDesc = (cleaned = cleaned.replaceAll("(?s)\\s*ASI:\\[.*?\\]\\s*", " ").trim()).isEmpty() ? newAsiBlock : (cleaned.endsWith("|") ? cleaned + " " + newAsiBlock : cleaned + " | " + newAsiBlock);
        mTab.setValue("Description", (Object)finalDesc);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String InvoiceLineApplyPercent(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal plannedQty;
        BigDecimal percent;
        if (value == null) {
            return null;
        }
        if ("Y".equals(Env.getContext((Properties)ctx, (int)WindowNo, (String)"Percent"))) {
            return null;
        }
        try {
            percent = (BigDecimal)value;
        }
        catch (Exception ex) {
            return "Valor inv\u00e1lido en 'Aplicar % cantidad'.";
        }
        if (percent.compareTo(BigDecimal.ZERO) < 0) {
            return "El porcentaje no puede ser negativo.";
        }
        Integer productId = (Integer)mTab.getValue("M_Product_ID");
        if (productId == null || productId <= 0) {
            return null;
        }
        Boolean processed = (Boolean)mTab.getValue("Processed");
        if (processed != null && processed.booleanValue()) {
            return "La factura ya est\u00e1 procesada; no se puede recalcular la cantidad.";
        }
        Integer invoiceId = (Integer)mTab.getValue("C_Invoice_ID");
        MInvoice invoice = null;
        if (invoiceId != null && invoiceId > 0) {
            invoice = new MInvoice(ctx, (int)invoiceId, null);
        }
        BigDecimal baseQty = null;
        int projectId = 0;
        if (invoice != null) {
            projectId = invoice.getC_Project_ID();
        }
        if (projectId > 0 && (plannedQty = DB.getSQLValueBDEx(null, (String)"SELECT COALESCE(SUM(PlannedQty), 0) FROM C_ProjectLine WHERE C_Project_ID=? AND M_Product_ID=?", (Object[])new Object[]{projectId, productId})) != null && plannedQty.compareTo(BigDecimal.ZERO) > 0) {
            baseQty = plannedQty;
        }
        if (baseQty == null) {
            BigDecimal qtyEntered = (BigDecimal)mTab.getValue("QtyEntered");
            baseQty = qtyEntered != null ? qtyEntered : BigDecimal.ZERO;
        }
        BigDecimal newQty = baseQty.multiply(percent).divide(new BigDecimal(100));
        Env.setContext((Properties)ctx, (int)WindowNo, (String)"Percent", (String)"Y");
        try {
            mTab.setValue("QtyEntered", (Object)newQty);
            mTab.setValue("QtyInvoiced", (Object)newQty);
        }
        finally {
            Env.setContext((Properties)ctx, (int)WindowNo, (String)"Percent", (String)"N");
        }
        return null;
    }

    public String recalcCommissionFromPct(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal pct;
        if (value == null) {
            return "";
        }
        try {
            pct = (BigDecimal)value;
        }
        catch (Exception e) {
            return "";
        }
        pct = pct.setScale(2, RoundingMode.HALF_UP);
        Object lineNetObj = mTab.getValue("LineNetAmt");
        if (lineNetObj == null) {
            return "";
        }
        BigDecimal lineNet = (BigDecimal)lineNetObj;
        BigDecimal amt = Env.ZERO;
        if (lineNet.signum() != 0 && pct.signum() != 0) {
            amt = lineNet.multiply(pct).divide(Env.ONEHUNDRED, 2, RoundingMode.HALF_UP);
        }
        mTab.setValue("comision", (Object)amt);
        return "";
    }
}

